/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.abi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.biojava.bio.BioError;
import org.biojava.bio.chromatogram.AbstractChromatogram;
import org.biojava.bio.chromatogram.Chromatogram;
import org.biojava.bio.chromatogram.UnsupportedChromatogramFormatException;
import org.biojava.bio.program.abi.ABIFParser;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.IntegerAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.SmallMap;

public class ABIFChromatogram
extends AbstractChromatogram {
    public static ABIFChromatogram create(File f) throws IOException, UnsupportedChromatogramFormatException {
        ABIFChromatogram newOne = new ABIFChromatogram();
        newOne.load(f);
        return newOne;
    }

    public static ABIFChromatogram create(InputStream in) throws IOException, UnsupportedChromatogramFormatException {
        ABIFChromatogram newOne = new ABIFChromatogram();
        newOne.load(in);
        return newOne;
    }

    protected ABIFChromatogram load(File f) throws IOException, UnsupportedChromatogramFormatException {
        new Parser(f);
        return this;
    }

    protected ABIFChromatogram load(InputStream in) throws IOException, UnsupportedChromatogramFormatException {
        new Parser(in);
        return this;
    }

    protected AbstractChromatogram reverseComplementInstance() {
        return new ABIFChromatogram();
    }

    protected class Parser
    extends ABIFParser {
        public Parser(InputStream in) throws IOException, UnsupportedChromatogramFormatException {
            super(in);
            this.parse();
        }

        public Parser(File f) throws IOException, UnsupportedChromatogramFormatException {
            super(f);
            this.parse();
        }

        private final void parse() throws IOException, UnsupportedChromatogramFormatException {
            char[] fwo_ = new char[4];
            ABIFParser.TaggedDataRecord fwoRec = this.getDataRecord("FWO_", 1);
            if (fwoRec == null) {
                throw new UnsupportedChromatogramFormatException("No FWO_ (1) record in ABIF file, therefore no trace data");
            }
            fwo_[0] = (char)(fwoRec.dataRecord >>> 24 & 0xFFL);
            fwo_[1] = (char)(fwoRec.dataRecord >>> 16 & 0xFFL);
            fwo_[2] = (char)(fwoRec.dataRecord >>> 8 & 0xFFL);
            fwo_[3] = (char)(fwoRec.dataRecord & 0xFFL);
            ABIFChromatogram.this.clearTraces();
            int i = 0;
            while (i < 4) {
                Symbol sym;
                try {
                    sym = ABIFParser.decodeDNAToken(fwo_[i]);
                }
                catch (IllegalSymbolException ise) {
                    throw new UnsupportedChromatogramFormatException("An unexpected character (" + fwo_[i] + ") was found in the FWO_ tag.  Parsing cannot continue.");
                }
                if (!(sym instanceof AtomicSymbol)) {
                    throw new UnsupportedChromatogramFormatException("An unexpected character (" + fwo_[i] + ") was found in the FWO_ tag.  Parsing cannot continue.");
                }
                this.parseTrace((AtomicSymbol)sym, i + 9);
                ++i;
            }
            this.parseBaseCalls();
        }

        private void parseTrace(AtomicSymbol sym, int whichData) throws IOException, UnsupportedChromatogramFormatException {
            int i;
            ABIFParser.TaggedDataRecord dataPtr = this.getDataRecord("DATA", whichData);
            if (dataPtr.numberOfElements > Integer.MAX_VALUE) {
                throw new UnsupportedChromatogramFormatException("Chromatogram has more than 2147483647 trace samples -- can't handle it");
            }
            int count = (int)dataPtr.numberOfElements;
            this.getDataAccess().seek(dataPtr.dataRecord);
            int[] trace = new int[count];
            int max = -1;
            ABIFChromatogram.this.setBits(8 * dataPtr.elementLength);
            if (dataPtr.elementLength == 2) {
                i = 0;
                while (i < count) {
                    trace[i] = this.getDataAccess().readShort() & 0xFFFF;
                    max = Math.max(trace[i], max);
                    ++i;
                }
            } else if (dataPtr.elementLength == 1) {
                i = 0;
                while (i < count) {
                    trace[i] = this.getDataAccess().readByte() & 0xFF;
                    max = Math.max(trace[i], max);
                    ++i;
                }
            } else {
                throw new UnsupportedChromatogramFormatException("Only 8- and 16-bit trace samples are supported");
            }
            try {
                ABIFChromatogram.this.setTrace(sym, trace, max);
            }
            catch (IllegalSymbolException ise) {
                throw new BioError(ise, "Can't happen");
            }
        }

        private void parseBaseCalls() throws IOException, UnsupportedChromatogramFormatException {
            int i;
            ABIFParser.TaggedDataRecord offsetsPtr = this.getDataRecord("PLOC", 1);
            ABIFParser.TaggedDataRecord basesPtr = this.getDataRecord("PBAS", 1);
            if (offsetsPtr.numberOfElements != basesPtr.numberOfElements) {
                throw new BioError("PLOC and PBAS are different lengths.  Can't proceed.");
            }
            if (offsetsPtr.numberOfElements > Integer.MAX_VALUE) {
                throw new UnsupportedChromatogramFormatException("Chromatogram has more than 2147483647 base calls -- can't handle it");
            }
            int count = (int)offsetsPtr.numberOfElements;
            ArrayList<Symbol> dna = new ArrayList<Symbol>(count);
            ArrayList<IntegerAlphabet.IntegerSymbol> offsets = new ArrayList<IntegerAlphabet.IntegerSymbol>(count);
            this.getDataAccess().seek(offsetsPtr.dataRecord);
            if (offsetsPtr.elementLength == 2) {
                i = 0;
                while ((long)i < offsetsPtr.numberOfElements) {
                    offsets.add(IntegerAlphabet.getInstance().getSymbol(this.getDataAccess().readShort() & 0xFFFF));
                    ++i;
                }
            } else if (offsetsPtr.elementLength == 1) {
                i = 0;
                while ((long)i < offsetsPtr.numberOfElements) {
                    offsets.add(IntegerAlphabet.getInstance().getSymbol(this.getDataAccess().readByte() & 0xFF));
                    ++i;
                }
            } else {
                throw new IllegalStateException("Only 8- and 16-bit trace samples are supported");
            }
            try {
                this.getDataAccess().seek(basesPtr.dataRecord);
                int i2 = 0;
                while ((long)i2 < basesPtr.numberOfElements) {
                    char token = (char)this.getDataAccess().readByte();
                    dna.add(ABIFParser.decodeDNAToken(token));
                    ++i2;
                }
            }
            catch (IllegalSymbolException ise) {
                throw new BioError(ise, "Can't happen");
            }
            try {
                SmallMap baseCalls = new SmallMap(2);
                baseCalls.put(Chromatogram.DNA, ABIFChromatogram.this.createImmutableSymbolList(DNATools.getDNA(), dna));
                baseCalls.put(Chromatogram.OFFSETS, ABIFChromatogram.this.createImmutableSymbolList(IntegerAlphabet.getInstance(), offsets));
                ABIFChromatogram.this.setBaseCallAlignment(ABIFChromatogram.this.createImmutableAlignment(baseCalls));
            }
            catch (IllegalAlphabetException iae) {
                throw new BioError(iae, "Can't happen");
            }
            catch (IllegalSymbolException ise) {
                throw new BioError(ise, "Can't happen");
            }
        }
    }
}

