/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.gff;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.biojava.bio.BioException;
import org.biojava.bio.program.gff.GFFDocumentHandler;
import org.biojava.bio.program.gff.GFFErrorHandler;
import org.biojava.bio.program.gff.GFFRecord;
import org.biojava.bio.program.gff.GFFTools;
import org.biojava.bio.program.gff.IgnoreRecordException;
import org.biojava.bio.program.gff.SimpleGFFRecord;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.utils.ParserException;
import org.biojava.utils.SmallMap;

public class GFFParser {
    private GFFErrorHandler errors = GFFErrorHandler.ABORT_PARSING;

    public void setErrorHandler(GFFErrorHandler errors) {
        this.errors = errors;
    }

    public GFFErrorHandler getErrorHandler() {
        return this.errors;
    }

    public void parse(BufferedReader bReader, GFFDocumentHandler handler) throws IOException, BioException, ParserException {
        this.parse(bReader, handler, "unknown:");
    }

    public void parse(BufferedReader bReader, GFFDocumentHandler handler, String locator) throws IOException, BioException, ParserException {
        handler.startDocument(locator);
        ArrayList<String> aList = new ArrayList<String>();
        int lineNum = 0;
        String line = bReader.readLine();
        while (line != null) {
            block10: {
                ++lineNum;
                try {
                    int ci;
                    aList.clear();
                    if (line.startsWith("#")) {
                        handler.commentLine(line.substring(1));
                        break block10;
                    }
                    if (line.length() == 0) break block10;
                    StringTokenizer st = new StringTokenizer(line, "\t", false);
                    while (st.hasMoreTokens() && aList.size() < 8) {
                        String token = st.nextToken();
                        aList.add(token);
                    }
                    String rest = null;
                    String comment = null;
                    if (st.hasMoreTokens()) {
                        try {
                            rest = st.nextToken("\u0000");
                        }
                        catch (NoSuchElementException nsee) {
                            // empty catch block
                        }
                    }
                    if (rest != null && (ci = rest.indexOf("#")) != -1) {
                        comment = rest.substring(ci);
                        rest = rest.substring(0, ci);
                    }
                    GFFRecord record = this.createRecord(handler, aList, rest, comment);
                    handler.recordLine(record);
                }
                catch (ParserException ex) {
                    throw new ParserException(ex.getMessage(), locator, lineNum, line);
                }
                catch (IgnoreRecordException ex) {
                    // empty catch block
                }
            }
            line = bReader.readLine();
        }
        handler.endDocument();
    }

    protected GFFRecord createRecord(GFFDocumentHandler handler, List aList, String rest, String comment) throws BioException, ParserException, IgnoreRecordException {
        SimpleGFFRecord record = new SimpleGFFRecord();
        record.setSeqName((String)aList.get(0));
        record.setSource((String)aList.get(1));
        record.setFeature((String)aList.get(2));
        int start = -1;
        try {
            start = Integer.parseInt((String)aList.get(3));
        }
        catch (NumberFormatException nfe) {
            start = this.errors.invalidStart((String)aList.get(3));
        }
        record.setStart(start);
        int end = -1;
        try {
            end = Integer.parseInt((String)aList.get(4));
        }
        catch (NumberFormatException nfe) {
            end = this.errors.invalidEnd((String)aList.get(3));
        }
        record.setEnd(end);
        String score = (String)aList.get(5);
        if (score == null || score.equals("") || score.equals(".") || score.equals("0")) {
            record.setScore(GFFTools.NO_SCORE);
        } else {
            double sc = 0.0;
            try {
                sc = Double.parseDouble(score);
            }
            catch (NumberFormatException nfe) {
                sc = this.errors.invalidScore(score);
            }
            record.setScore(sc);
        }
        String strand = (String)aList.get(6);
        if (strand == null || strand.equals("") || strand.equals(".")) {
            record.setStrand(StrandedFeature.UNKNOWN);
        } else if (strand.equals("+")) {
            record.setStrand(StrandedFeature.POSITIVE);
        } else if (strand.equals("-")) {
            record.setStrand(StrandedFeature.NEGATIVE);
        } else {
            record.setStrand(this.errors.invalidStrand(strand));
        }
        String frame = (String)aList.get(7);
        if (frame.equals(".")) {
            record.setFrame(GFFTools.NO_FRAME);
        } else {
            int fr = 0;
            try {
                fr = Integer.parseInt(frame);
            }
            catch (NumberFormatException nfe) {
                fr = this.errors.invalidFrame(frame);
            }
            record.setFrame(fr);
        }
        if (rest != null) {
            record.setGroupAttributes(this.parseAttribute(rest));
        } else {
            record.setGroupAttributes(new SmallMap());
        }
        record.setComment(comment);
        return record;
    }

    protected Map parseAttribute(String attValList) {
        SmallMap attMap = new SmallMap();
        StringTokenizer sTok = new StringTokenizer(attValList, ";", false);
        while (sTok.hasMoreTokens()) {
            String attName;
            String attVal = sTok.nextToken().trim();
            ArrayList<String> valList = new ArrayList<String>();
            int spaceIndx = attVal.indexOf(" ");
            if (spaceIndx == -1) {
                attName = attVal;
            } else {
                attName = attVal.substring(0, spaceIndx);
                attValList = attVal.substring(spaceIndx).trim();
                while (attValList.length() > 0) {
                    if (attValList.startsWith("\"")) {
                        int quoteIndx = 0;
                        do {
                            ++quoteIndx;
                        } while ((quoteIndx = attValList.indexOf("\"", quoteIndx)) != -1 && attValList.charAt(quoteIndx - 1) == '\\');
                        if (quoteIndx > 0) {
                            valList.add(attValList.substring(1, quoteIndx));
                            attValList = attValList.substring(quoteIndx + 1).trim();
                            continue;
                        }
                        valList.add(attValList);
                        attValList = "";
                        continue;
                    }
                    spaceIndx = attValList.indexOf(" ");
                    if (spaceIndx == -1) {
                        valList.add(attValList);
                        attValList = "";
                        continue;
                    }
                    valList.add(attValList.substring(0, spaceIndx));
                    attValList = attValList.substring(spaceIndx).trim();
                }
            }
            attMap.put(attName, valList);
        }
        return attMap;
    }
}

