/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.indexdb;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.bio.program.indexdb.SearchableList;
import org.biojava.utils.FileAsList;

abstract class SearchableFileAsList
extends FileAsList
implements SearchableList {
    public SearchableFileAsList(File file, int recordLen) throws IOException {
        super(file, recordLen);
    }

    public SearchableFileAsList(File file, boolean mutable) throws IOException {
        super(file, mutable);
    }

    public Object search(String id) {
        byte[] idBytes = id.getBytes();
        int min = 0;
        int max = this.size() - 1;
        do {
            int mid;
            byte[] bytes;
            int cmp;
            if ((cmp = this.cmp(bytes = this.rawGet(mid = (min + max) / 2), idBytes)) < 0) {
                if (min != mid) {
                    min = mid;
                    continue;
                }
                min = mid + 1;
                continue;
            }
            if (cmp > 0) {
                if (max != mid) {
                    max = mid;
                    continue;
                }
                max = mid - 1;
                continue;
            }
            if (cmp != 0) continue;
            return this.parseRecord(bytes);
        } while (min <= max);
        throw new NoSuchElementException("No element with ID: " + id);
    }

    public List searchAll(String id) {
        byte[] bytes;
        byte[] idBytes = id.getBytes();
        int min = 0;
        int max = this.size() - 1;
        int mid = -1;
        do {
            int cmp;
            if ((cmp = this.cmp(bytes = this.rawGet(mid = (min + max) / 2), idBytes)) < 0) {
                if (min != mid) {
                    min = mid;
                    continue;
                }
                min = mid + 1;
                continue;
            }
            if (cmp > 0) {
                if (max != mid) {
                    max = mid;
                    continue;
                }
                max = mid - 1;
                continue;
            }
            if (cmp == 0) break;
        } while (min <= max);
        if (min > max) {
            throw new NoSuchElementException("No element with ID: " + id);
        }
        ArrayList<Object> items = new ArrayList<Object>();
        int i = mid - 1;
        while (i >= 0) {
            bytes = this.rawGet(i);
            if (this.cmp(bytes, idBytes) != 0) break;
            items.add(this.parseRecord(bytes));
            --i;
        }
        int i2 = mid;
        while (i2 < this.size()) {
            bytes = this.rawGet(i2);
            if (this.cmp(bytes, idBytes) != 0) {
                System.out.println("Stopped at: " + i2);
                break;
            }
            items.add(this.parseRecord(bytes));
            ++i2;
        }
        return items;
    }

    private int cmp(byte[] a, byte[] b) {
        int iMax = Math.min(a.length, b.length);
        int i = 0;
        while (i < iMax) {
            if (a[i] < b[i]) {
                return -1;
            }
            if (a[i] > b[i]) {
                return 1;
            }
            ++i;
        }
        return 0;
    }
}

