/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax.blastxml;

import org.biojava.bio.program.sax.blastxml.StAXFeatureHandler;
import org.biojava.bio.program.sax.blastxml.StAXHandlerFactory;
import org.biojava.bio.seq.io.game.ElementRecognizer;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StringElementHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class HspHandler
extends StAXFeatureHandler {
    public static final StAXHandlerFactory HSP_HANDLER_FACTORY = new StAXHandlerFactory(){

        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new HspHandler(staxenv);
        }
    };
    private static final String bitScore = "bitScore";
    private static final String score = "score";
    private static final String expectValue = "expectValue";
    private static final String numberOfIdentities = "numberOfIdentities";
    private static final String numberOfPositives = "numberOfPositives";
    private static final String alignmentSize = "alignmentSize";
    private static final String queryFrame = "queryFrame";
    private static final String hitFrame = "hitFrame";
    private static final String queryStrand = "queryStrand";
    private static final String hitStrand = "hitStrand";
    private static final String percentageIdentity = "percentageIdentity";
    AttributesImpl hspAttrs;
    AttributesImpl alignAttrs;
    int iNumberOfIdentities = Integer.MIN_VALUE;
    int iAlignmentSize = Integer.MIN_VALUE;
    String sHsp_qseq = null;
    String sHsp_hseq = null;
    String sHsp_midline = null;
    String sHsp_hit_from = null;
    String sHsp_hit_to = null;
    String sHsp_query_from = null;
    String sHsp_query_to = null;

    public HspHandler(StAXFeatureHandler staxenv) {
        super(staxenv);
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_bit-score"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void setStringValue(String s) {
                        2.access$000(this.this$1).hspAttrs.addAttribute("http://www.biojava.org", "bitScore", "bitScore", "CDATA", s);
                    }
                };
            }

            static /* synthetic */ HspHandler access$000(2 x0) {
                return x0.HspHandler.this;
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_score"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void setStringValue(String s) {
                        4.access$100(this.this$1).hspAttrs.addAttribute("http://www.biojava.org", "score", "score", "CDATA", s);
                    }
                };
            }

            static /* synthetic */ HspHandler access$100(4 x0) {
                return x0.HspHandler.this;
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_evalue"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(this){
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void setStringValue(String s) {
                        6.access$200(this.this$1).hspAttrs.addAttribute("http://www.biojava.org", "expectValue", "expectValue", "CDATA", s);
                    }
                };
            }

            static /* synthetic */ HspHandler access$200(6 x0) {
                return x0.HspHandler.this;
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_query-from"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(this){
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void setStringValue(String s) {
                        8.access$300(this.this$1).sHsp_query_from = s.trim();
                    }
                };
            }

            static /* synthetic */ HspHandler access$300(8 x0) {
                return x0.HspHandler.this;
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_query-to"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(this){
                    private final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void setStringValue(String s) {
                        10.access$400(this.this$1).sHsp_query_to = s.trim();
                    }
                };
            }

            static /* synthetic */ HspHandler access$400(10 x0) {
                return x0.HspHandler.this;
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_hit-from"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(this){
                    private final /* synthetic */ 12 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void setStringValue(String s) {
                        12.access$500(this.this$1).sHsp_hit_from = s.trim();
                    }
                };
            }

            static /* synthetic */ HspHandler access$500(12 x0) {
                return x0.HspHandler.this;
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_hit-to"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(this){
                    private final /* synthetic */ 14 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void setStringValue(String s) {
                        14.access$600(this.this$1).sHsp_hit_to = s.trim();
                    }
                };
            }

            static /* synthetic */ HspHandler access$600(14 x0) {
                return x0.HspHandler.this;
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_query-frame"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(this){
                    private final /* synthetic */ 16 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void setStringValue(String s) throws SAXException {
                        int frameNo = Integer.parseInt(s.trim());
                        if (StAXFeatureHandler.hitSequenceType.equals("protein")) {
                            16.access$700(this.this$1).hspAttrs.addAttribute("http://www.biojava.org", "queryFrame", "queryFrame", "CDATA", HspHandler.access$800(16.access$700(this.this$1), frameNo));
                        } else if (StAXFeatureHandler.hitSequenceType.equals("dna")) {
                            16.access$700(this.this$1).hspAttrs.addAttribute("http://www.biojava.org", "hitStrand", "hitStrand", "CDATA", HspHandler.access$900(16.access$700(this.this$1), frameNo));
                        } else {
                            throw new SAXException("illegal sequence type");
                        }
                    }
                };
            }

            static /* synthetic */ HspHandler access$700(16 x0) {
                return x0.HspHandler.this;
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_hit-frame"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(this){
                    private final /* synthetic */ 18 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void setStringValue(String s) throws SAXException {
                        int frameNo = Integer.parseInt(s.trim());
                        if (StAXFeatureHandler.hitSequenceType.equals("protein")) {
                            18.access$1000(this.this$1).hspAttrs.addAttribute("http://www.biojava.org", "hitFrame", "hitFrame", "CDATA", HspHandler.access$800(18.access$1000(this.this$1), frameNo));
                        } else if (StAXFeatureHandler.hitSequenceType.equals("dna")) {
                            18.access$1000(this.this$1).hspAttrs.addAttribute("http://www.biojava.org", "queryStrand", "queryStrand", "CDATA", HspHandler.access$900(18.access$1000(this.this$1), frameNo));
                        } else {
                            throw new SAXException("illegal sequence type");
                        }
                    }
                };
            }

            static /* synthetic */ HspHandler access$1000(18 x0) {
                return x0.HspHandler.this;
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_identity"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(this){
                    private final /* synthetic */ 20 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void setStringValue(String s) {
                        20.access$1100(this.this$1).iNumberOfIdentities = Integer.parseInt(s.trim());
                        20.access$1100(this.this$1).hspAttrs.addAttribute("http://www.biojava.org", "numberOfIdentities", "numberOfIdentities", "CDATA", s);
                    }
                };
            }

            static /* synthetic */ HspHandler access$1100(20 x0) {
                return x0.HspHandler.this;
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_positive"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(this){
                    private final /* synthetic */ 22 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void setStringValue(String s) {
                        22.access$1200(this.this$1).hspAttrs.addAttribute("http://www.biojava.org", "numberOfPositives", "numberOfPositives", "CDATA", s);
                    }
                };
            }

            static /* synthetic */ HspHandler access$1200(22 x0) {
                return x0.HspHandler.this;
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_align-len"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(this){
                    private final /* synthetic */ 24 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void setStringValue(String s) {
                        24.access$1300(this.this$1).iAlignmentSize = Integer.parseInt(s.trim());
                        24.access$1300(this.this$1).hspAttrs.addAttribute("http://www.biojava.org", "alignmentSize", "alignmentSize", "CDATA", s);
                    }
                };
            }

            static /* synthetic */ HspHandler access$1300(24 x0) {
                return x0.HspHandler.this;
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_qseq"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(this){
                    private final /* synthetic */ 26 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void setStringValue(String s) {
                        26.access$1400(this.this$1).sHsp_qseq = s;
                    }
                };
            }

            static /* synthetic */ HspHandler access$1400(26 x0) {
                return x0.HspHandler.this;
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_hseq"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(this){
                    private final /* synthetic */ 28 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void setStringValue(String s) {
                        28.access$1500(this.this$1).sHsp_hseq = s;
                    }
                };
            }

            static /* synthetic */ HspHandler access$1500(28 x0) {
                return x0.HspHandler.this;
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("Hsp_midline"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new StringElementHandlerBase(this){
                    private final /* synthetic */ 30 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void setStringValue(String s) {
                        30.access$1600(this.this$1).sHsp_midline = s;
                    }
                };
            }

            static /* synthetic */ HspHandler access$1600(30 x0) {
                return x0.HspHandler.this;
            }
        });
    }

    private String stringifyFrame(int frame) throws SAXException {
        switch (frame) {
            case -3: {
                return "minus3";
            }
            case -2: {
                return "minus2";
            }
            case -1: {
                return "minus1";
            }
            case 1: {
                return "plus1";
            }
            case 2: {
                return "plus2";
            }
            case 3: {
                return "plus3";
            }
        }
        throw new SAXException("illegal frame number encountered.");
    }

    private String stringifyStrand(int strand) throws SAXException {
        if (strand > 0) {
            return "plus";
        }
        if (strand < 0) {
            return "minus";
        }
        throw new SAXException("illegal strand number encountered.");
    }

    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
        this.hspAttrs = new AttributesImpl();
    }

    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
        if (this.iNumberOfIdentities == Integer.MIN_VALUE || this.iAlignmentSize == Integer.MIN_VALUE || this.sHsp_qseq == null || this.sHsp_hseq == null || this.sHsp_midline == null || this.sHsp_hit_from == null || this.sHsp_hit_to == null || this.sHsp_query_from == null || this.sHsp_query_to == null) {
            throw new SAXException("<Hsp> is non-compliant.");
        }
        this.hspAttrs.addAttribute("http://www.biojava.org", percentageIdentity, percentageIdentity, "CDATA", Float.toString((float)(100 * this.iNumberOfIdentities) / (float)this.iAlignmentSize));
        this.staxenv.listener.startElement("http://www.biojava.org", "HSP", "http://www.biojava.org:HSP", new AttributesImpl());
        this.staxenv.listener.startElement("http://www.biojava.org", "HSPSummary", "http://www.biojava.org:HSPSummary", this.hspAttrs);
        this.staxenv.listener.endElement("http://www.biojava.org", "HSPSummary", "http://www.biojava.org:HSPSummary");
        this.staxenv.listener.startElement("http://www.biojava.org", "BlastLikeAlignment", "http://www.biojava.org:BlastLikeAlignment", new AttributesImpl());
        AttributesImpl queryAttrs = new AttributesImpl();
        queryAttrs.addAttribute("http://www.biojava.org", "startPosition", "startPosition", "CDATA", this.sHsp_query_from);
        queryAttrs.addAttribute("http://www.biojava.org", "stopPosition", "stopPosition", "CDATA", this.sHsp_query_to);
        this.staxenv.listener.startElement("http://www.biojava.org", "QuerySequence", "http://www.biojava.org:QuerySequence", queryAttrs);
        this.staxenv.listener.characters(this.sHsp_qseq.toCharArray(), 0, this.sHsp_qseq.length());
        this.staxenv.listener.endElement("http://www.biojava.org", "QuerySequence", "http://www.biojava.org:QuerySequence");
        AttributesImpl matchAttrs = new AttributesImpl();
        matchAttrs.addAttribute("xml", "space", "xml:space", "CDATA", "preserve");
        this.staxenv.listener.startElement("http://www.biojava.org", "MatchConsensus", "http://www.biojava.org:MatchConsensus", matchAttrs);
        this.staxenv.listener.characters(this.sHsp_midline.toCharArray(), 0, this.sHsp_midline.length());
        this.staxenv.listener.endElement("http://www.biojava.org", "MatchConsensus", "http://www.biojava.org:MatchConsensus");
        AttributesImpl hitAttrs = new AttributesImpl();
        hitAttrs.addAttribute("http://www.biojava.org", "startPosition", "startPosition", "CDATA", this.sHsp_hit_from);
        hitAttrs.addAttribute("http://www.biojava.org", "stopPosition", "stopPosition", "CDATA", this.sHsp_hit_to);
        this.staxenv.listener.startElement("http://www.biojava.org", "HitSequence", "HitSequence", hitAttrs);
        this.staxenv.listener.characters(this.sHsp_hseq.toCharArray(), 0, this.sHsp_hseq.length());
        this.staxenv.listener.endElement("http://www.biojava.org", "HitSequence", "http://www.biojava.org:HitSequence");
        this.staxenv.listener.endElement("http://www.biojava.org", "BlastLikeAlignment", "http://www.biojava.org:BlastLikeAlignment");
        this.staxenv.listener.endElement("http://www.biojava.org", "HSP", "http://www.biojava.org:HSP");
    }

    static /* synthetic */ String access$800(HspHandler x0, int x1) throws SAXException {
        return x0.stringifyFrame(x1);
    }

    static /* synthetic */ String access$900(HspHandler x0, int x1) throws SAXException {
        return x0.stringifyStrand(x1);
    }
}

