/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssbind;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.AbstractAnnotation;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.SmallAnnotation;
import org.biojava.utils.ChangeVetoException;

public class AnnotationFactory {
    public static Annotation makeAnnotation(Map m) {
        int elements = m.size();
        if (elements == 0) {
            return Annotation.EMPTY_ANNOTATION;
        }
        AbstractAnnotation annotation = elements < 15 ? new SmallAnnotation() : new SimpleAnnotation();
        Set keySet = m.keySet();
        try {
            Iterator ksi = keySet.iterator();
            while (ksi.hasNext()) {
                Object key = ksi.next();
                annotation.setProperty(key, m.get(key));
            }
        }
        catch (ChangeVetoException cve) {
            throw new BioError(cve, "Assert failed: couldn't modify newly created Annotation");
        }
        return annotation;
    }
}

