/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.proteomics;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolPropertyTable;

public class MassCalc {
    public static final double Cmono = 12.0;
    public static final double Hmono = 1.007825;
    public static final double Nmono = 14.003074;
    public static final double Omono = 15.9949146;
    public static final double Cavg = 12.011;
    public static final double Havg = 1.00794;
    public static final double Navg = 14.00674;
    public static final double Oavg = 15.9994;
    private HashMap mSymbolPropertyHash;
    private HashMap mVariableModPropertyHash;
    private double termMass;

    public MassCalc(String isotopicType, boolean MH_PLUS) {
        this.termMass = MassCalc.calcTermMass(isotopicType, MH_PLUS);
        this.mSymbolPropertyHash = new HashMap();
        SymbolPropertyTable symbolPropertyTable = ProteinTools.getSymbolPropertyTable(isotopicType);
        this.mVariableModPropertyHash = new HashMap();
        Iterator symbolList = ProteinTools.getAlphabet().iterator();
        while (symbolList.hasNext()) {
            Symbol sym = (Symbol)symbolList.next();
            try {
                try {
                    Double value = new Double(symbolPropertyTable.getDoubleValue(sym));
                    this.mSymbolPropertyHash.put(sym, value);
                }
                catch (NullPointerException npe) {}
            }
            catch (IllegalSymbolException ise) {
                throw new BioError(ise, "Error setting properties for Symbol " + sym);
            }
        }
    }

    public void setSymbolModification(char symbolToken, double mass) throws IllegalSymbolException {
        SymbolTokenization toke;
        Iterator list = ProteinTools.getAlphabet().iterator();
        try {
            toke = ProteinTools.getAlphabet().getTokenization("token");
        }
        catch (BioException ex) {
            throw new BioError(ex, "Expected a tokenization");
        }
        Symbol sym = toke.parseToken("" + symbolToken);
        this.mSymbolPropertyHash.put(sym, new Double(mass));
    }

    public void addVariableModification(char residue, double[] masses) throws IllegalSymbolException {
        Symbol sym = this.getSymbolForChar(residue);
        this.addVariableModification(sym, masses);
    }

    public void addVariableModification(Symbol residue, double[] masses) throws IllegalSymbolException {
        LinkedList<Double> massList = new LinkedList<Double>();
        int i = 0;
        while (i < masses.length) {
            massList.add(new Double(masses[i]));
            ++i;
        }
        this.getVariableModMap().put(residue, massList);
    }

    public boolean removeVariableModifications(char residue) throws IllegalSymbolException {
        Symbol sym = this.getSymbolForChar(residue);
        return this.removeVariableModifications(sym);
    }

    public boolean removeVariableModifications(Symbol residue) {
        return this.getVariableModMap().remove(residue) != null;
    }

    public static final double getMass(SymbolList proteinSeq, String isotopicType, boolean MH_PLUS) throws IllegalSymbolException {
        if (!proteinSeq.getAlphabet().getName().equals("PROTEIN")) {
            throw new IllegalSymbolException("The SymbolList was not using the protein alphabet");
        }
        double pepMass = 0.0;
        SymbolPropertyTable sPT = ProteinTools.getSymbolPropertyTable(isotopicType);
        Iterator it = proteinSeq.iterator();
        while (it.hasNext()) {
            pepMass += sPT.getDoubleValue((Symbol)it.next());
        }
        double termMass = MassCalc.calcTermMass(isotopicType, MH_PLUS);
        if (pepMass != 0.0) {
            pepMass += termMass;
        }
        return pepMass;
    }

    public double getMass(SymbolList proteinSeq) throws IllegalSymbolException {
        if (!proteinSeq.getAlphabet().getName().equals("PROTEIN")) {
            throw new IllegalSymbolException("The SymbolList was not using the protein alphabet");
        }
        double pepMass = 0.0;
        HashMap symbolPropertyMap = this.getSymbolPropertyMap();
        Iterator it = proteinSeq.iterator();
        while (it.hasNext()) {
            Double mass = (Double)symbolPropertyMap.get((Symbol)it.next());
            pepMass += mass.doubleValue();
        }
        return pepMass += this.getTermMass();
    }

    public double[] getVariableMasses(SymbolList peptide) throws IllegalSymbolException {
        double[] vMasses = this.getVMasses(peptide);
        int i = 0;
        while (i < vMasses.length) {
            int n = i++;
            vMasses[n] = vMasses[n] + this.getTermMass();
        }
        return vMasses;
    }

    private HashMap getVariableModMap() {
        return this.mVariableModPropertyHash;
    }

    private HashMap getSymbolPropertyMap() {
        return this.mSymbolPropertyHash;
    }

    public double getTermMass() {
        return this.termMass;
    }

    private double[] getVMasses(SymbolList peptide) throws IllegalSymbolException {
        HashSet<Double> allMassList = new HashSet<Double>();
        Symbol sym = peptide.symbolAt(1);
        if (!this.getSymbolPropertyMap().containsKey(sym)) {
            String msg = "No mass Set for Symbol " + sym.getName();
            throw new IllegalSymbolException(msg);
        }
        LinkedList<Object> curResMasses = null;
        curResMasses = this.getVariableModMap().containsKey(sym) ? new LinkedList((List)this.getVariableModMap().get(sym)) : new LinkedList();
        curResMasses.add(this.getSymbolPropertyMap().get(sym));
        Iterator it = curResMasses.iterator();
        while (it.hasNext()) {
            double resMass = (Double)it.next();
            if (peptide.length() == 1) {
                allMassList.add(new Double(resMass));
                continue;
            }
            double[] subMasses = this.getVMasses(peptide.subList(2, peptide.length()));
            int i = 0;
            while (i < subMasses.length) {
                double pepMass = resMass + subMasses[i];
                allMassList.add(new Double(pepMass));
                ++i;
            }
        }
        double[] masses = new double[allMassList.size()];
        int i = 0;
        Iterator mit = allMassList.iterator();
        while (mit.hasNext()) {
            masses[i] = (Double)mit.next();
            ++i;
        }
        return masses;
    }

    private static double calcTermMass(String isotopicType, boolean MH_PLUS) {
        double termMass = 0.0;
        if (isotopicType.equals("avgMass")) {
            termMass += 18.01528;
            if (MH_PLUS) {
                termMass += 1.00794;
            }
        } else if (isotopicType.equals("monoMass")) {
            termMass += 18.0105646;
            if (MH_PLUS) {
                termMass += 1.007825;
            }
        }
        return termMass;
    }

    private Symbol getSymbolForChar(char symbolToken) throws IllegalSymbolException {
        SymbolTokenization toke;
        Iterator list = ProteinTools.getAlphabet().iterator();
        try {
            toke = ProteinTools.getAlphabet().getTokenization("token");
        }
        catch (BioException ex) {
            throw new BioError(ex, "Expected a tokenization");
        }
        Symbol sym = toke.parseToken("" + symbolToken);
        return sym;
    }
}

