/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.AbstractFeatureHolder;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.impl.LazyFilterFeatureHolder;
import org.biojava.bio.seq.projection.ProjectionContext;
import org.biojava.bio.seq.projection.ProjectionEngine;
import org.biojava.bio.seq.projection.ProjectionUtils;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class ProjectedFeatureHolder
extends AbstractFeatureHolder
implements FeatureHolder,
ProjectionContext {
    private final FeatureHolder wrapped;
    private final FeatureHolder parent;
    private final int translate;
    private final boolean oppositeStrand;
    private ChangeListener underlyingFeaturesChange;
    private Map forwardersByFeature = new HashMap();
    private FeatureHolder topLevelFeatures;

    public ProjectedFeatureHolder(FeatureHolder fh, FeatureFilter filter, FeatureHolder parent, int translation, boolean oppositeStrand) {
        this(new LazyFilterFeatureHolder(fh, filter), parent, translation, oppositeStrand);
    }

    public ProjectedFeatureHolder(FeatureHolder fh, FeatureHolder parent, int translation, boolean oppositeStrand) {
        this.wrapped = fh;
        this.parent = parent;
        this.translate = translation;
        this.oppositeStrand = oppositeStrand;
        this.underlyingFeaturesChange = new ChangeListener(){

            public void preChange(ChangeEvent e) throws ChangeVetoException {
                ChangeEvent cev2;
                if (ProjectedFeatureHolder.this.hasListeners() && (cev2 = ProjectedFeatureHolder.this.forwardChangeEvent(e)) != null) {
                    ProjectedFeatureHolder.this.getChangeSupport(FeatureHolder.FEATURES).firePreChangeEvent(cev2);
                }
            }

            public void postChange(ChangeEvent e) {
                ChangeEvent cev2;
                if (ProjectedFeatureHolder.this.hasListeners() && (cev2 = ProjectedFeatureHolder.this.forwardChangeEvent(e)) != null) {
                    ProjectedFeatureHolder.this.getChangeSupport(FeatureHolder.FEATURES).firePostChangeEvent(cev2);
                }
            }
        };
        this.getWrapped().addChangeListener(this.underlyingFeaturesChange);
    }

    private FeatureHolder getTopLevelFeatures() {
        if (this.topLevelFeatures == null) {
            this.topLevelFeatures = this.makeProjectionSet(this.getWrapped());
        }
        return this.topLevelFeatures;
    }

    protected FeatureHolder getWrapped() {
        return this.wrapped;
    }

    public Iterator features() {
        return this.getTopLevelFeatures().features();
    }

    public int countFeatures() {
        return this.getTopLevelFeatures().countFeatures();
    }

    public boolean containsFeature(Feature f) {
        return this.getTopLevelFeatures().containsFeature(f);
    }

    public FeatureHolder filter(FeatureFilter ff) {
        return this.getTopLevelFeatures().filter(ff);
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        return this.getTopLevelFeatures().filter(ff, recurse);
    }

    public Feature createFeature(Feature.Template templ) throws ChangeVetoException, BioException {
        throw new ChangeVetoException("Can't create features in this projection");
    }

    public void removeFeature(Feature f) throws ChangeVetoException {
        throw new ChangeVetoException("Can't create features in this projection");
    }

    public FeatureFilter getSchema() {
        return this.getTopLevelFeatures().getSchema();
    }

    protected FeatureFilter untransformFilter(FeatureFilter ff) {
        return FilterUtils.transformFilter(ff, new FilterUtils.FilterTransformer(){

            public FeatureFilter transform(FeatureFilter ff) {
                if (ff instanceof FeatureFilter.OverlapsLocation) {
                    return new FeatureFilter.OverlapsLocation(ProjectedFeatureHolder.this.untransformLocation(((FeatureFilter.OverlapsLocation)ff).getLocation()));
                }
                if (ff instanceof FeatureFilter.ContainedByLocation) {
                    return new FeatureFilter.ContainedByLocation(ProjectedFeatureHolder.this.untransformLocation(((FeatureFilter.ContainedByLocation)ff).getLocation()));
                }
                if (ff instanceof FeatureFilter.StrandFilter) {
                    return new FeatureFilter.StrandFilter(ProjectedFeatureHolder.this.transformStrand(((FeatureFilter.StrandFilter)ff).getStrand()));
                }
                return ff;
            }
        });
    }

    protected FeatureFilter transformFilter(FeatureFilter ff) {
        return FilterUtils.transformFilter(ff, new FilterUtils.FilterTransformer(){

            public FeatureFilter transform(FeatureFilter ff) {
                if (ff instanceof FeatureFilter.OverlapsLocation) {
                    return new FeatureFilter.OverlapsLocation(ProjectedFeatureHolder.this.transformLocation(((FeatureFilter.OverlapsLocation)ff).getLocation()));
                }
                if (ff instanceof FeatureFilter.ContainedByLocation) {
                    return new FeatureFilter.ContainedByLocation(ProjectedFeatureHolder.this.transformLocation(((FeatureFilter.ContainedByLocation)ff).getLocation()));
                }
                if (ff instanceof FeatureFilter.StrandFilter) {
                    return new FeatureFilter.StrandFilter(ProjectedFeatureHolder.this.transformStrand(((FeatureFilter.StrandFilter)ff).getStrand()));
                }
                return ff;
            }
        });
    }

    protected StrandedFeature.Strand transformStrand(StrandedFeature.Strand strand) {
        if (this.oppositeStrand) {
            return strand.flip();
        }
        return strand;
    }

    protected Location transformLocation(Location oldLoc) {
        return ProjectionUtils.transformLocation(oldLoc, this.translate, this.oppositeStrand);
    }

    protected Location untransformLocation(Location oldLoc) {
        if (this.oppositeStrand) {
            if (oldLoc.isContiguous()) {
                if (oldLoc instanceof PointLocation) {
                    return new PointLocation(this.translate - oldLoc.getMin());
                }
                return new RangeLocation(this.translate - oldLoc.getMax(), this.translate - oldLoc.getMin());
            }
            Location compound = Location.empty;
            ArrayList<RangeLocation> locList = new ArrayList<RangeLocation>();
            Iterator i = oldLoc.blockIterator();
            while (i.hasNext()) {
                Location oldBlock = (Location)i.next();
                locList.add(new RangeLocation(this.translate - oldBlock.getMax(), this.translate - oldBlock.getMin()));
            }
            compound = LocationTools.union(locList);
            return compound;
        }
        return oldLoc.translate(-this.translate);
    }

    public Feature projectFeature(Feature f) {
        return ProjectionEngine.DEFAULT.projectFeature(f, this);
    }

    public int getTranslation() {
        return this.translate;
    }

    public boolean isOppositeStrand() {
        return this.oppositeStrand;
    }

    public FeatureHolder getParent() {
        return this.parent;
    }

    protected FeatureHolder makeProjectionSet(FeatureHolder fh) {
        return new ProjectionSet(fh);
    }

    public FeatureHolder getParent(Feature f) {
        FeatureHolder oldP = f.getParent();
        if (oldP instanceof Feature) {
            if (this.wrapped.containsFeature(f)) {
                return this.parent;
            }
            return this.projectFeature((Feature)oldP);
        }
        return this.parent;
    }

    public Sequence getSequence(Feature f) {
        FeatureHolder fh = this.parent;
        while (fh instanceof Feature) {
            fh = ((Feature)fh).getParent();
        }
        return (Sequence)fh;
    }

    public Location getLocation(Feature f) {
        Location oldLoc = f.getLocation();
        return this.transformLocation(oldLoc);
    }

    public StrandedFeature.Strand getStrand(StrandedFeature sf) {
        StrandedFeature.Strand s = sf.getStrand();
        return this.transformStrand(s);
    }

    public Annotation getAnnotation(Feature f) {
        return f.getAnnotation();
    }

    public FeatureHolder projectChildFeatures(Feature f, FeatureHolder parent) {
        return this.makeProjectionSet(f);
    }

    public Feature createFeature(Feature f, Feature.Template templ) throws BioException, ChangeVetoException {
        throw new ChangeVetoException("Can't create features in this projection");
    }

    public void removeFeature(Feature f, Feature f2) throws ChangeVetoException {
        throw new ChangeVetoException("Can't create features in this projection");
    }

    public FeatureFilter getSchema(Feature f) {
        return this.transformFilter(f.getSchema());
    }

    public void addChangeListener(Feature f, ChangeListener cl, ChangeType ct) {
        if (!f.isUnchanging(ct)) {
            PFChangeForwarder forwarder = (PFChangeForwarder)this.forwardersByFeature.get(f);
            if (forwarder == null) {
                forwarder = new PFChangeForwarder(f);
                this.forwardersByFeature.put(f, forwarder);
                f.addChangeListener(forwarder, ChangeType.UNKNOWN);
            }
            forwarder.addChangeListener(cl, ct);
        }
    }

    public void removeChangeListener(Feature f, ChangeListener cl, ChangeType ct) {
        PFChangeForwarder forwarder = (PFChangeForwarder)this.forwardersByFeature.get(f);
        if (forwarder != null) {
            forwarder.removeChangeListener(cl, ct);
            if (!forwarder.hasListeners()) {
                this.forwardersByFeature.remove(f);
                f.removeChangeListener(forwarder, ChangeType.UNKNOWN);
            }
        }
    }

    protected ChangeEvent forwardFeatureChangeEvent(Feature f, ChangeEvent cev) {
        return new ChangeEvent(this.projectFeature(f), cev.getType(), cev.getChange(), cev.getPrevious(), cev);
    }

    protected ChangeEvent forwardChangeEvent(ChangeEvent cev) {
        return new ChangeEvent(this, cev.getType(), cev.getChange(), cev.getPrevious(), cev);
    }

    private class PFChangeForwarder
    extends ChangeSupport
    implements ChangeListener {
        private Feature master;

        public PFChangeForwarder(Feature master) {
            super(1);
            this.master = master;
        }

        public void preChange(ChangeEvent cev) throws ChangeVetoException {
            ChangeEvent cev2 = ProjectedFeatureHolder.this.forwardFeatureChangeEvent(this.master, cev);
            if (cev2 != null) {
                this.firePreChangeEvent(cev2);
            }
        }

        public void postChange(ChangeEvent cev) {
            ChangeEvent cev2 = ProjectedFeatureHolder.this.forwardFeatureChangeEvent(this.master, cev);
            if (cev2 != null) {
                this.firePostChangeEvent(cev2);
            }
        }
    }

    private class ProjectionSet
    implements FeatureHolder {
        private final FeatureHolder baseSet;

        ProjectionSet(FeatureHolder baseSet) {
            this.baseSet = baseSet;
        }

        public int countFeatures() {
            return this.baseSet.countFeatures();
        }

        public Iterator features() {
            Iterator wrappedIterator = this.baseSet.features();
            return new Iterator(this, wrappedIterator){
                private final /* synthetic */ Iterator val$wrappedIterator;
                private final /* synthetic */ ProjectionSet this$1;
                {
                    this.this$1 = this$1;
                    this.val$wrappedIterator = val$wrappedIterator;
                }

                public boolean hasNext() {
                    return this.val$wrappedIterator.hasNext();
                }

                public Object next() {
                    return ProjectionSet.access$400(this.this$1).projectFeature((Feature)this.val$wrappedIterator.next());
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean containsFeature(Feature f) {
            Iterator fi = this.features();
            while (fi.hasNext()) {
                if (!f.equals(fi.next())) continue;
                return true;
            }
            return false;
        }

        public FeatureHolder filter(FeatureFilter ff) {
            return this.filter(ff, true);
        }

        public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
            ff = ProjectedFeatureHolder.this.untransformFilter(ff);
            FeatureHolder toProject = this.baseSet.filter(ff, recurse);
            return ProjectedFeatureHolder.this.makeProjectionSet(toProject);
        }

        public Feature createFeature(Feature.Template templ) throws ChangeVetoException {
            throw new ChangeVetoException("Can't create features in this projection");
        }

        public void removeFeature(Feature f) throws ChangeVetoException {
            throw new ChangeVetoException("Can't create features in this projection");
        }

        public FeatureFilter getSchema() {
            return ProjectedFeatureHolder.this.transformFilter(this.baseSet.getSchema());
        }

        public void addChangeListener(ChangeListener cl) {
        }

        public void removeChangeListener(ChangeListener cl) {
        }

        public void addChangeListener(ChangeListener cl, ChangeType ct) {
        }

        public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        }

        public boolean isUnchanging(ChangeType ct) {
            return true;
        }

        static /* synthetic */ ProjectedFeatureHolder access$400(ProjectionSet x0) {
            return x0.ProjectedFeatureHolder.this;
        }
    }
}

