/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleSequenceFactory;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ReversibleTranslationTable;
import org.biojava.bio.symbol.SimpleReversibleTranslationTable;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SimpleTranslationTable;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListViews;
import org.biojava.bio.symbol.TranslationTable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class RNATools {
    private static final ReversibleTranslationTable complementTable;
    private static final SimpleReversibleTranslationTable transcriptionTable;
    private static final FiniteAlphabet rna;
    private static final Map geneticCodes;
    private static final AtomicSymbol a;
    private static final AtomicSymbol g;
    private static final AtomicSymbol c;
    private static final AtomicSymbol u;
    private static final Symbol n;
    private static Map symbolToComplement;
    static /* synthetic */ Class class$org$biojava$bio$seq$RNATools;

    public static AtomicSymbol a() {
        return a;
    }

    public static AtomicSymbol g() {
        return g;
    }

    public static AtomicSymbol c() {
        return c;
    }

    public static AtomicSymbol u() {
        return u;
    }

    public static Symbol n() {
        return n;
    }

    public static FiniteAlphabet getRNA() {
        return rna;
    }

    public static FiniteAlphabet getCodonAlphabet() {
        return (FiniteAlphabet)AlphabetManager.generateCrossProductAlphaFromName("(RNA x RNA x RNA)");
    }

    public static SymbolList createRNA(String rna) throws IllegalSymbolException {
        try {
            SymbolTokenization p = RNATools.getRNA().getTokenization("token");
            return new SimpleSymbolList(p, rna);
        }
        catch (BioException se) {
            throw new BioError(se, "Something has gone badly wrong with RNA");
        }
    }

    public static Sequence createRNASequence(String rna, String name) throws IllegalSymbolException {
        try {
            return new SimpleSequenceFactory().createSequence(RNATools.createRNA(rna), "", name, new SimpleAnnotation());
        }
        catch (BioException se) {
            throw new BioError(se, "Something has gone badly wrong with RNA");
        }
    }

    public static int index(Symbol sym) throws IllegalSymbolException {
        if (sym == a) {
            return 0;
        }
        if (sym == g) {
            return 1;
        }
        if (sym == c) {
            return 2;
        }
        if (sym == u) {
            return 3;
        }
        RNATools.getRNA().validate(sym);
        throw new IllegalSymbolException("Really confused. Can't find index for " + sym.getName());
    }

    public static Symbol forIndex(int index) throws IndexOutOfBoundsException {
        if (index == 0) {
            return a;
        }
        if (index == 1) {
            return g;
        }
        if (index == 2) {
            return c;
        }
        if (index == 3) {
            return u;
        }
        throw new IndexOutOfBoundsException("No symbol for index " + index);
    }

    public static Symbol complement(Symbol sym) throws IllegalSymbolException {
        if (sym == a) {
            return u;
        }
        if (sym == g) {
            return c;
        }
        if (sym == c) {
            return g;
        }
        if (sym == u) {
            return a;
        }
        Symbol s = (Symbol)symbolToComplement.get(sym);
        if (s != null) {
            return s;
        }
        RNATools.getRNA().validate(sym);
        throw new BioError("Really confused. Can't find symbol " + sym.getName());
    }

    public static Symbol forSymbol(char token) throws IllegalSymbolException {
        SymbolTokenization toke;
        String t = String.valueOf(token);
        try {
            toke = RNATools.getRNA().getTokenization("token");
        }
        catch (BioException e) {
            throw new BioError(e, "Cannot find the 'token' Tokenization for RNA!?");
        }
        return toke.parseToken(t);
    }

    public static SymbolList complement(SymbolList list) throws IllegalAlphabetException {
        return SymbolListViews.translate(list, RNATools.complementTable());
    }

    public static SymbolList reverseComplement(SymbolList list) throws IllegalAlphabetException {
        return SymbolListViews.translate(SymbolListViews.reverse(list), RNATools.complementTable());
    }

    public static SymbolList transcribe(SymbolList list) throws IllegalAlphabetException {
        return SymbolListViews.translate(list, RNATools.transcriptionTable());
    }

    public static ReversibleTranslationTable complementTable() {
        return complementTable;
    }

    public static ReversibleTranslationTable transcriptionTable() {
        return transcriptionTable;
    }

    public static TranslationTable getGeneticCode(String name) {
        return (TranslationTable)geneticCodes.get(name);
    }

    public static Set getGeneticCodeNames() {
        return geneticCodes.keySet();
    }

    public static SymbolList translate(SymbolList syms) throws IllegalAlphabetException {
        if (syms.getAlphabet() == RNATools.getRNA()) {
            syms = SymbolListViews.windowedSymbolList(syms, 3);
        }
        return SymbolListViews.translate(syms, RNATools.getGeneticCode("UNIVERSAL"));
    }

    private static void loadGeneticCodes() {
        try {
            InputStream tablesStream = (class$org$biojava$bio$seq$RNATools == null ? (class$org$biojava$bio$seq$RNATools = RNATools.class$("org.biojava.bio.seq.RNATools")) : class$org$biojava$bio$seq$RNATools).getClassLoader().getResourceAsStream("org/biojava/bio/seq/TranslationTables.xml");
            if (tablesStream == null) {
                throw new BioError("Couldn't locate TranslationTables.xml.");
            }
            InputSource is = new InputSource(tablesStream);
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = parser.parse(is);
            NodeList children = doc.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Element child;
                String name;
                Node cnode = children.item(i);
                if (cnode instanceof Element && (name = (child = (Element)cnode).getNodeName()).equals("table")) {
                    String tableName = child.getAttribute("name");
                    String source = child.getAttribute("source");
                    String target = child.getAttribute("target");
                    FiniteAlphabet sourceA = (FiniteAlphabet)AlphabetManager.alphabetForName(source);
                    FiniteAlphabet targetA = (FiniteAlphabet)AlphabetManager.alphabetForName(target);
                    SymbolTokenization sourceP = sourceA.getTokenization("name");
                    SymbolTokenization targetP = targetA.getTokenization("name");
                    SimpleTranslationTable table = new SimpleTranslationTable(sourceA, targetA);
                    NodeList translates = child.getChildNodes();
                    int j = 0;
                    while (j < translates.getLength()) {
                        Node tn = translates.item(j);
                        if (tn instanceof Element) {
                            Element te = (Element)tn;
                            String from = te.getAttribute("from");
                            String to = te.getAttribute("to");
                            SymbolList fromSymbols = RNATools.createRNA(from);
                            if (fromSymbols.length() != 3) {
                                throw new BioError("`" + from + "' is not a valid codon");
                            }
                            AtomicSymbol fromS = (AtomicSymbol)sourceA.getSymbol(fromSymbols.toList());
                            AtomicSymbol toS = (AtomicSymbol)targetP.parseToken(to);
                            table.setTranslation(fromS, toS);
                        }
                        ++j;
                    }
                    geneticCodes.put(tableName, table);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new BioError(e, "Couldn't parse TranslationTables.xml");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            rna = (FiniteAlphabet)AlphabetManager.alphabetForName("RNA");
            SimpleSymbolList syms = new SimpleSymbolList(rna.getTokenization("token"), "agcun");
            a = (AtomicSymbol)syms.symbolAt(1);
            g = (AtomicSymbol)syms.symbolAt(2);
            c = (AtomicSymbol)syms.symbolAt(3);
            u = (AtomicSymbol)syms.symbolAt(4);
            n = syms.symbolAt(5);
            symbolToComplement = new HashMap();
            Symbol gap = rna.getGapSymbol();
            symbolToComplement.put(gap, gap);
            Iterator i = AlphabetManager.getAllSymbols(rna).iterator();
            while (i.hasNext()) {
                Symbol as = (Symbol)i.next();
                FiniteAlphabet matches = (FiniteAlphabet)as.getMatches();
                if (matches.size() <= 1) continue;
                HashSet<Symbol> l = new HashSet<Symbol>();
                Iterator j = matches.iterator();
                while (j.hasNext()) {
                    l.add(RNATools.complement((Symbol)j.next()));
                }
                symbolToComplement.put(as, rna.getAmbiguity(l));
            }
            complementTable = new RNAComplementTranslationTable();
            transcriptionTable = new SimpleReversibleTranslationTable(DNATools.getDNA(), rna);
            transcriptionTable.setTranslation(DNATools.a(), a);
            transcriptionTable.setTranslation(DNATools.c(), c);
            transcriptionTable.setTranslation(DNATools.g(), g);
            transcriptionTable.setTranslation(DNATools.t(), u);
            geneticCodes = new HashMap();
            RNATools.loadGeneticCodes();
        }
        catch (Throwable t) {
            throw new BioError(t, "Unable to initialize RNATools");
        }
    }

    private static class RNAComplementTranslationTable
    extends AbstractTT {
        private RNAComplementTranslationTable() {
        }

        public AtomicSymbol doTranslate(AtomicSymbol s) throws IllegalSymbolException {
            return (AtomicSymbol)RNATools.complement(s);
        }

        public AtomicSymbol doUntranslate(AtomicSymbol s) throws IllegalSymbolException {
            return (AtomicSymbol)RNATools.complement(s);
        }

        public Alphabet getSourceAlphabet() {
            return RNATools.getRNA();
        }

        public Alphabet getTargetAlphabet() {
            return RNATools.getRNA();
        }
    }

    private static abstract class AbstractTT
    implements ReversibleTranslationTable {
        private AbstractTT() {
        }

        protected abstract AtomicSymbol doTranslate(AtomicSymbol var1) throws IllegalSymbolException;

        protected abstract AtomicSymbol doUntranslate(AtomicSymbol var1) throws IllegalSymbolException;

        public Symbol translate(Symbol s) throws IllegalSymbolException {
            if (s instanceof AtomicSymbol) {
                return this.doTranslate((AtomicSymbol)s);
            }
            HashSet<AtomicSymbol> syms = new HashSet<AtomicSymbol>();
            Iterator i = ((FiniteAlphabet)s.getMatches()).iterator();
            while (i.hasNext()) {
                AtomicSymbol is = (AtomicSymbol)i.next();
                syms.add(this.doTranslate(is));
            }
            return this.getTargetAlphabet().getAmbiguity(syms);
        }

        public Symbol untranslate(Symbol s) throws IllegalSymbolException {
            if (s instanceof AtomicSymbol) {
                return this.doUntranslate((AtomicSymbol)s);
            }
            HashSet<AtomicSymbol> syms = new HashSet<AtomicSymbol>();
            Iterator i = ((FiniteAlphabet)s.getMatches()).iterator();
            while (i.hasNext()) {
                AtomicSymbol is = (AtomicSymbol)i.next();
                syms.add(this.doUntranslate(is));
            }
            return this.getSourceAlphabet().getAmbiguity(syms);
        }
    }
}

