/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import com.kizna.html.HTMLNode;
import com.kizna.html.HTMLParser;
import com.kizna.html.HTMLRemarkNode;
import com.kizna.html.HTMLStringNode;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.biojava.bio.seq.db.FetchURL;

public class LocusLinkParser {
    private String nucleotideIDs = "";
    private String proteinIDs = "";
    private String omimIDs = "";
    private String unigeneIDs = "";
    private boolean formatChange = false;
    private String formatChangeHappened = "The file format has changed or exception has been thrown.";
    private String[] formatChangeHapp = new String[1];

    public LocusLinkParser(String locusLinkID) {
        this.parse(locusLinkID);
    }

    public String getProteinIDs() {
        if (this.formatChange) {
            return this.formatChangeHappened;
        }
        return this.proteinIDs;
    }

    public String getNucleotideIDs() {
        if (this.formatChange) {
            return this.formatChangeHappened;
        }
        return this.nucleotideIDs;
    }

    public String getOmimIDs() {
        if (this.formatChange) {
            return this.formatChangeHappened;
        }
        return this.omimIDs;
    }

    public String getUniGeneIDs() {
        if (this.formatChange) {
            return this.formatChangeHappened;
        }
        return this.unigeneIDs;
    }

    public String[] getProteinIDs_array() {
        StringTokenizer st = new StringTokenizer(this.proteinIDs, "\t");
        int numTokens = st.countTokens();
        if (numTokens == 0) {
            this.formatChangeHapp[0] = "The file format has changed or exception has been thrown.";
            return this.formatChangeHapp;
        }
        String[] proteinIDs_array = new String[numTokens];
        int i = 0;
        while (i < numTokens) {
            proteinIDs_array[i] = st.nextToken();
            ++i;
        }
        return proteinIDs_array;
    }

    public String[] getNucleotideIDs_array() {
        StringTokenizer st = new StringTokenizer(this.nucleotideIDs, "\t");
        int numTokens = st.countTokens();
        if (numTokens == 0) {
            this.formatChangeHapp[0] = "The file format has changed or exception has been thrown.";
            return this.formatChangeHapp;
        }
        String[] nucleotideIDs_array = new String[numTokens];
        int i = 0;
        while (i < numTokens) {
            nucleotideIDs_array[i] = st.nextToken();
            ++i;
        }
        return nucleotideIDs_array;
    }

    public String[] getOmimIDs_array() {
        StringTokenizer st = new StringTokenizer(this.omimIDs, "\t");
        int numTokens = st.countTokens();
        if (numTokens == 0) {
            this.formatChangeHapp[0] = "The file format has changed or exception has been thrown.";
            return this.formatChangeHapp;
        }
        String[] omimIDs_array = new String[numTokens];
        int i = 0;
        while (i < numTokens) {
            omimIDs_array[i] = st.nextToken();
            ++i;
        }
        return omimIDs_array;
    }

    private void parse(String locusLinkID) {
        String next;
        String tokenDeli;
        FetchURL llURL = new FetchURL("LocusLink", "");
        String baseurl = llURL.getbaseURL();
        if (!baseurl.equalsIgnoreCase("")) {
            baseurl = llURL.getbaseURL();
        }
        String url = baseurl + "l=" + locusLinkID;
        System.out.println(url);
        HTMLParser parser = null;
        parser = new HTMLParser(url);
        String allStringNodes = "";
        String allRemarkNodes = "";
        Enumeration e = parser.elements();
        while (e.hasMoreElements()) {
            HTMLNode node = (HTMLNode)e.nextElement();
            if (node instanceof HTMLStringNode) {
                HTMLStringNode stringNode = (HTMLStringNode)node;
                allStringNodes = allStringNodes + stringNode.getText().trim() + "\t";
            }
            if (!(node instanceof HTMLRemarkNode)) continue;
            HTMLRemarkNode remarkNode = (HTMLRemarkNode)node;
            allRemarkNodes = allRemarkNodes + remarkNode.getText().trim() + "\t";
        }
        StringTokenizer st = new StringTokenizer(allStringNodes, "\t");
        StringTokenizer refSeq = new StringTokenizer(allStringNodes, "\t");
        StringTokenizer addLinks = new StringTokenizer(allStringNodes, "\t");
        StringTokenizer formatCheck = new StringTokenizer(allRemarkNodes, "\t");
        int numTokens = st.countTokens();
        int numRemarkNodes = formatCheck.countTokens();
        int flag = 0;
        int i = 0;
        while (i < numRemarkNodes) {
            if (formatCheck.nextToken().trim().equalsIgnoreCase("RefSeq Block")) {
                ++flag;
                String tokenDeli2 = formatCheck.nextToken();
                while (!tokenDeli2.trim().equalsIgnoreCase("GenBank Block")) {
                    tokenDeli2 = formatCheck.nextToken();
                    if (tokenDeli2.trim().equalsIgnoreCase("To Top")) break;
                }
                if (tokenDeli2.trim().equalsIgnoreCase("GenBank Block")) {
                    ++flag;
                }
                String tokenDeli_2 = formatCheck.nextToken();
                while (!tokenDeli_2.trim().equalsIgnoreCase("Additional Links Block")) {
                    tokenDeli_2 = formatCheck.nextToken();
                    if (tokenDeli_2.trim().equalsIgnoreCase("To Top")) break;
                }
                if (!tokenDeli_2.trim().equalsIgnoreCase("Additional Links Block")) break;
                ++flag;
                break;
            }
            ++i;
        }
        this.formatChange = flag != 3;
        int i2 = 0;
        while (i2 < numTokens) {
            if (st.nextToken().trim().equalsIgnoreCase("GenBank Sequences")) {
                int j = 0;
                while (j < 6) {
                    st.nextToken();
                    ++j;
                }
                tokenDeli = st.nextToken();
                while (!tokenDeli.trim().equalsIgnoreCase("Additional Links") && !tokenDeli.trim().equalsIgnoreCase("To Top")) {
                    if (!tokenDeli.trim().equalsIgnoreCase("&nbsp;")) {
                        this.nucleotideIDs = this.nucleotideIDs + "Genbank: " + tokenDeli + "\t";
                    }
                    st.nextToken();
                    next = st.nextToken();
                    if (!next.trim().equalsIgnoreCase("&nbsp;")) {
                        this.proteinIDs = this.proteinIDs + "Genpept: " + next + "\t";
                    }
                    st.nextToken();
                    st.nextToken();
                    tokenDeli = st.nextToken();
                }
                break;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < numTokens) {
            if (refSeq.nextToken().trim().equalsIgnoreCase("NCBI Reference Sequences&nbsp;(RefSeq)")) {
                tokenDeli = refSeq.nextToken();
                while (!(tokenDeli.trim().equalsIgnoreCase("GenBank Sequences") || tokenDeli.trim().equalsIgnoreCase("Additional Links") || tokenDeli.trim().equalsIgnoreCase("To Top"))) {
                    next = refSeq.nextToken();
                    if (next.trim().equalsIgnoreCase("mRNA:")) {
                        this.nucleotideIDs = this.nucleotideIDs + "RefSeq: " + refSeq.nextToken() + "\t";
                    }
                    if (next.trim().equalsIgnoreCase("Protein:")) {
                        this.proteinIDs = this.proteinIDs + "RefSeq: " + refSeq.nextToken() + "\t";
                    }
                    if (next.trim().equalsIgnoreCase("GenBank Source:")) {
                        this.nucleotideIDs = this.nucleotideIDs + "Genbank: " + refSeq.nextToken() + "\t";
                    }
                    if (next.trim().equalsIgnoreCase("Model mRNA:")) {
                        this.nucleotideIDs = this.nucleotideIDs + "RefSeq: " + refSeq.nextToken() + "\t";
                    }
                    if (next.trim().equalsIgnoreCase("Model Protein:")) {
                        this.proteinIDs = this.proteinIDs + "RefSeq: " + refSeq.nextToken() + "\t";
                    }
                    tokenDeli = next;
                }
                break;
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < numTokens) {
            if (addLinks.nextToken().trim().equalsIgnoreCase("Additional Links")) {
                String tokenDeli3 = addLinks.nextToken();
                while (!tokenDeli3.trim().equalsIgnoreCase("To Top")) {
                    String next2 = addLinks.nextToken();
                    if (next2.trim().equalsIgnoreCase("UniGene:")) {
                        this.unigeneIDs = this.unigeneIDs + addLinks.nextToken() + "\t";
                    }
                    if (next2.trim().equalsIgnoreCase("Omim:")) {
                        this.omimIDs = this.omimIDs + addLinks.nextToken() + "\t";
                    }
                    tokenDeli3 = next2;
                }
                break;
            }
            ++i4;
        }
    }
}

