/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.sql.Connection;
import java.sql.SQLException;
import org.biojava.bio.seq.db.biosql.MySQLDBHelper;
import org.biojava.bio.seq.db.biosql.PostgreSQLDBHelper;
import org.biojava.bio.seq.db.biosql.UnknownDBHelper;

public abstract class DBHelper {
    public static final DeleteStyle DELETE_POSTGRESQL = new DeleteStyle("Postgresql");
    public static final DeleteStyle DELETE_MYSQL4 = new DeleteStyle("Mysql 4.02 or later");
    public static final DeleteStyle DELETE_GENERIC = new DeleteStyle("Portable SQL");

    public static DBHelper getDBHelperForURL(String ourURL) {
        int colon;
        if (ourURL.startsWith("jdbc:")) {
            ourURL = ourURL.substring(5);
        }
        if ((colon = ourURL.indexOf(58)) > 0) {
            String protocol = ourURL.substring(0, colon);
            if (protocol.indexOf("mysql") >= 0) {
                return new MySQLDBHelper();
            }
            if (protocol.equals("postgresql")) {
                return new PostgreSQLDBHelper();
            }
        }
        return new UnknownDBHelper();
    }

    public abstract int getInsertID(Connection var1, String var2, String var3) throws SQLException;

    public abstract DeleteStyle getDeleteStyle();

    public static final class DeleteStyle {
        private final String name;

        private DeleteStyle(String name) {
            this.name = name;
        }

        public String toString() {
            return "DBHelper.DeleteStyle: " + this.name;
        }
    }
}

