/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.flat;

import java.io.IOException;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.db.SequenceDBLite;
import org.biojava.bio.seq.db.flat.FlatSequenceDB;
import org.biojava.directory.RegistryException;
import org.biojava.directory.SequenceDBProvider;

public class FlatSequenceDBProvider
implements SequenceDBProvider {
    public String getName() {
        return "flat";
    }

    public SequenceDBLite getSequenceDB(Map config) throws RegistryException, BioException {
        String location = (String)config.get("location");
        if (location == null) {
            throw new RegistryException("Flat provider requires a location parameter");
        }
        String dbName = (String)config.get("dbname");
        if (dbName == null) {
            throw new RegistryException("Flat provider requires a dbname parameter");
        }
        try {
            return new FlatSequenceDB(location, dbName);
        }
        catch (IOException ioe) {
            throw new BioException(ioe, "Flat provider failed to open index");
        }
    }
}

