/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.seq.io.ChunkedSymbolList;
import org.biojava.bio.seq.io.SubArraySymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class ChunkedSymbolListBuilder {
    private static final int CHUNK_SIZE = 4096;
    private List chunkL = new ArrayList();
    private Symbol[] headChunk = null;
    private int headChunkPos = 0;
    private Alphabet alpha = null;

    public void addSymbols(Alphabet alpha, Symbol[] syms, int pos, int len) throws IllegalAlphabetException {
        if (this.alpha == null) {
            this.alpha = alpha;
        } else if (this.alpha != alpha) {
            throw new IllegalAlphabetException("Alphabet changed!");
        }
        if (this.headChunk == null) {
            this.headChunk = new Symbol[4096];
            this.headChunkPos = 0;
        }
        int ipos = 0;
        while (ipos < len) {
            if (this.headChunkPos == 4096) {
                this.chunkL.add(this.headChunk);
                this.headChunk = new Symbol[4096];
                this.headChunkPos = 0;
            }
            int read = Math.min(len - ipos, 4096 - this.headChunkPos);
            System.arraycopy(syms, pos + ipos, this.headChunk, this.headChunkPos, read);
            ipos += read;
            this.headChunkPos += read;
        }
    }

    public SymbolList makeSymbolList() {
        if (this.headChunkPos > 0) {
            if (this.headChunkPos < 4096) {
                Symbol[] oldChunk = this.headChunk;
                this.headChunk = new Symbol[this.headChunkPos];
                System.arraycopy(oldChunk, 0, this.headChunk, 0, this.headChunkPos);
            }
            this.chunkL.add(this.headChunk);
        }
        if (this.chunkL.size() == 0) {
            return SymbolList.EMPTY_LIST;
        }
        if (this.chunkL.size() == 1) {
            return new SubArraySymbolList((Symbol[])this.chunkL.get(0), this.headChunkPos, 0, this.alpha);
        }
        Symbol[][] chunks = new Symbol[this.chunkL.size()][];
        int cnum = 0;
        while (cnum < this.chunkL.size()) {
            chunks[cnum] = (Symbol[])this.chunkL.get(cnum);
            ++cnum;
        }
        int length = (this.chunkL.size() - 1) * 4096 + this.headChunkPos;
        return new ChunkedSymbolList(chunks, 4096, length, this.alpha);
    }
}

