/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.game;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.game.ElementRecognizer;
import org.biojava.bio.seq.io.game.StAXFeatureHandler;
import org.biojava.bio.seq.io.game.StAXHandlerFactory;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StAXContentHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StAXPropertyHandler
extends StAXContentHandlerBase {
    private String myLocalName;
    private boolean hasCallback = false;
    private boolean inElement = false;
    private boolean setOnceFired = false;
    protected SeqIOListener featureListener;
    private List handlers = new ArrayList();
    protected StAXFeatureHandler staxenv;
    private int baseLevel = 0;

    StAXPropertyHandler(StAXFeatureHandler staxenv) {
        this.staxenv = staxenv;
    }

    public void setHandlerCharacteristics(String localName, boolean hasCallback) {
        if (!this.setOnceFired) {
            this.myLocalName = localName;
            this.hasCallback = hasCallback;
            this.setOnceFired = true;
        } else {
            System.err.println("setHandlerChracteristics called twice on same handler");
        }
    }

    protected ListIterator getHandlerStackIterator() throws ParseException {
        if (this.baseLevel >= 1) {
            return this.staxenv.getHandlerStackIterator(this.baseLevel - 1);
        }
        throw new ParseException("getHandlerStackIterator while at bottom of stack.");
    }

    protected void addHandler(ElementRecognizer rec, StAXHandlerFactory handler) {
        this.handlers.add(new Binding(rec, handler));
    }

    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
    }

    public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
        int i = this.handlers.size() - 1;
        while (i >= 0) {
            Binding b = (Binding)this.handlers.get(i);
            if (b.recognizer.filterStartElement(nsURI, localName, qName, attrs)) {
                dm.delegate(b.handlerFactory.getHandler(this.staxenv));
                return;
            }
            --i;
        }
        if (!this.myLocalName.equals(localName)) {
            return;
        }
        if (!this.inElement) {
            this.baseLevel = this.staxenv.getLevel();
            if (this.hasCallback) {
                this.staxenv.push(this);
            }
            this.inElement = true;
        }
        if (this.inElement) {
            this.startElementHandler(nsURI, localName, qName, attrs);
        }
    }

    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
    }

    public void endElement(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
        if (!this.myLocalName.equals(localName)) {
            return;
        }
        if (this.inElement) {
            this.endElementHandler(nsURI, localName, qName, handler);
            if (this.hasCallback && this.setOnceFired) {
                this.staxenv.pop();
                this.setOnceFired = false;
            }
            this.inElement = false;
        }
    }

    class Binding {
        final ElementRecognizer recognizer;
        final StAXHandlerFactory handlerFactory;

        Binding(ElementRecognizer er, StAXHandlerFactory hf) {
            this.recognizer = er;
            this.handlerFactory = hf;
        }
    }
}

