/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.ragbag;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.io.EmblLikeFormat;
import org.biojava.bio.seq.io.EmblProcessor;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.seq.ragbag.RagbagFileParser;
import org.biojava.bio.seq.ragbag.RagbagFileParserFactory;

class RagbagEmblParser
implements RagbagFileParser {
    public static final RagbagFileParserFactory FACTORY = new RagbagFileParserFactory(){

        public RagbagFileParser getParser(File inputFile) {
            return new RagbagEmblParser(inputFile);
        }
    };
    public static final String EXTENSION = "embl";
    private SequenceBuilder builder;
    private File inputFile;

    public RagbagEmblParser(File inputFile) {
        this.inputFile = inputFile;
    }

    public void setListener(SequenceBuilder builder) {
        this.builder = builder;
    }

    public void parse() throws BioException {
        try {
            BufferedReader file = new BufferedReader(new FileReader(this.inputFile));
            EmblLikeFormat parser = new EmblLikeFormat();
            SymbolTokenization dnaParser = DNATools.getDNA().getTokenization("token");
            EmblProcessor chain = new EmblProcessor(this.builder);
            parser.readSequence(file, dnaParser, chain);
        }
        catch (FileNotFoundException fne) {
            throw new BioException(fne);
        }
        catch (IOException ie) {
            throw new BioException(ie);
        }
    }
}

