/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AbstractAlphabet;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ListTools;

class SimpleCrossProductAlphabet
extends AbstractAlphabet
implements Serializable {
    private final Alphabet parent;
    private final List alphas;
    private final HashMap ourSymbols;
    private char tokenSeed = (char)65;

    public SimpleCrossProductAlphabet(List a) throws IllegalAlphabetException {
        this(a, null);
    }

    public SimpleCrossProductAlphabet(List a, Alphabet parent) throws IllegalAlphabetException {
        if (a.size() == 0) {
            throw new IllegalAlphabetException("Can't create alphabet for empty list. Use Alphabet.EMPTY_ALPHABET");
        }
        this.parent = parent;
        Iterator i = a.iterator();
        while (i.hasNext()) {
            Alphabet aa = (Alphabet)i.next();
            if (aa instanceof FiniteAlphabet) continue;
            throw new IllegalAlphabetException("Can't create a SimpleCrossProductAlphabet over non-fininte alphabet " + aa.getName() + " of type " + aa.getClass());
        }
        this.alphas = ListTools.createList(a);
        this.ourSymbols = new HashMap();
        this.populateSymbols(new ArrayList());
    }

    protected ChangeSupport generateChangeSupport() {
        Iterator i = this.alphas.iterator();
        while (i.hasNext()) {
            Alphabet a = (Alphabet)i.next();
            if (a.isUnchanging(Alphabet.SYMBOLS)) continue;
            return new ChangeSupport();
        }
        return new ChangeSupport(Collections.singleton(Alphabet.SYMBOLS));
    }

    public Iterator iterator() {
        return this.ourSymbols.values().iterator();
    }

    private void populateSymbols(List symList) {
        if (symList.size() == this.alphas.size()) {
            this.putSymbol(symList);
        } else {
            int indx = symList.size();
            FiniteAlphabet a = (FiniteAlphabet)this.alphas.get(indx);
            Iterator i = a.iterator();
            if (i.hasNext()) {
                symList.add(i.next());
                this.populateSymbols(symList);
                while (i.hasNext()) {
                    symList.set(indx, i.next());
                    this.populateSymbols(symList);
                }
                symList.remove(indx);
            }
        }
    }

    private AtomicSymbol putSymbol(List s) {
        AtomicSymbol ss;
        if (this.parent != null) {
            try {
                ss = (AtomicSymbol)this.parent.getSymbol(s);
            }
            catch (IllegalSymbolException ise) {
                throw new BioError(ise, "Balls up - couldn't fetch symbol from parent");
            }
        }
        try {
            char c = this.tokenSeed;
            this.tokenSeed = (char)(c + '\u0001');
            ss = (AtomicSymbol)AlphabetManager.createSymbol(c, Annotation.EMPTY_ANNOTATION, s, (Alphabet)this);
        }
        catch (IllegalSymbolException ise) {
            throw new BioError(ise, "Assertion Failure: Should have a legal symbol: " + s);
        }
        this.ourSymbols.put(ss.getSymbols(), ss);
        return ss;
    }

    protected boolean containsImpl(AtomicSymbol s) {
        return this.ourSymbols.values().contains(s);
    }

    public String getName() {
        StringBuffer name = new StringBuffer("(");
        int i = 0;
        while (i < this.alphas.size()) {
            Alphabet a = (Alphabet)this.alphas.get(i);
            name.append(a.getName());
            if (i < this.alphas.size() - 1) {
                name.append(" x ");
            }
            ++i;
        }
        name.append(")");
        return name.substring(0);
    }

    public int size() {
        return this.ourSymbols.size();
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    public List getAlphabets() {
        return this.alphas;
    }

    public AtomicSymbol getSymbolImpl(List l) throws IllegalSymbolException {
        AtomicSymbol cps = (AtomicSymbol)this.ourSymbols.get(l);
        if (cps == null) {
            throw new IllegalSymbolException("Can't find symbol for " + l + " in alphabet " + this.getName());
        }
        return cps;
    }

    protected void addSymbolImpl(AtomicSymbol sym) throws IllegalSymbolException {
        throw new IllegalSymbolException("Can't add symbols to alphabet: " + sym.getName() + " in " + this.getName());
    }

    public void removeSymbol(Symbol sym) throws IllegalSymbolException {
        throw new IllegalSymbolException("Can't remove symbols from alphabet: " + sym.getName() + " in " + this.getName());
    }
}

