/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class UkkonenSuffixTree {
    public static final char DEFAULT_TERM_CHAR = '$';
    private char terminationChar = (char)36;
    SuffixNode root = new SuffixNode();
    public static final int TO_A_LEAF = -1;
    private int e = 0;
    private String sequences = "";
    private FiniteAlphabet alpha = null;
    private HashMap symbolToChar = null;
    private HashMap charToSymbol = null;
    private short nextChar = (short)37;
    private int rule;

    public UkkonenSuffixTree() {
    }

    public UkkonenSuffixTree(String seqs) {
        this();
        this.addSequence(seqs, "unnamed", false);
    }

    public UkkonenSuffixTree(FiniteAlphabet alpha) {
        this();
        this.alpha = alpha;
        this.charToSymbol = new HashMap(alpha.size());
        this.symbolToChar = new HashMap(alpha.size());
        this.mapAplhaToChars(alpha);
    }

    private void mapAplhaToChars(FiniteAlphabet alpha) {
        Iterator iterator = alpha.iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            if (this.symbolToChar.containsKey(this.symbolToChar)) continue;
            short s = this.nextChar;
            this.nextChar = (short)(s + 1);
            Character letter = new Character((char)s);
            this.symbolToChar.put(symbol, letter);
            this.charToSymbol.put(letter, symbol);
        }
    }

    public String symbolListToString(SymbolList list) throws IllegalSymbolException {
        FiniteAlphabet checkAlpha = (FiniteAlphabet)list.getAlphabet();
        Iterator iterator = checkAlpha.iterator();
        while (iterator.hasNext()) {
            this.alpha.validate((Symbol)iterator.next());
        }
        char[] string = new char[list.length()];
        this.mapAplhaToChars(checkAlpha);
        int i = 0;
        while (i < string.length) {
            string[i] = ((Character)this.symbolToChar.get(list.symbolAt(i + 1))).charValue();
            ++i;
        }
        return new String(string);
    }

    public SymbolList stringToSymbolList(String string) {
        ArrayList symbols = new ArrayList(string.length());
        int i = 0;
        while (i < string.length()) {
            symbols.add(i, this.charToSymbol.get(new Character(string.charAt(i))));
            ++i;
        }
        try {
            return new SimpleSymbolList(this.alpha, symbols);
        }
        catch (IllegalSymbolException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void addSymbolList(SymbolList list, String name, boolean doNotTerminate) throws IllegalSymbolException {
        String seq = this.symbolListToString(list);
        if (!doNotTerminate) {
            seq = seq + this.terminationChar;
        }
        this.addPreppedSequence(seq);
    }

    public void addSequence(String seq, String name, boolean doNotTerminate) {
        ArrayList<String> toBeAdded = new ArrayList<String>();
        if (seq == null || seq.length() == 0) {
            return;
        }
        if (!doNotTerminate && seq.charAt(seq.length() - 1) != this.terminationChar) {
            seq = seq + this.terminationChar;
        }
        int start = 0;
        int i = 0;
        while (seq.indexOf(this.terminationChar, i) != -1) {
            int end = seq.indexOf(this.terminationChar, i);
            toBeAdded.add(seq.substring(start, end + 1));
            i = seq.indexOf(this.terminationChar, i) + 1;
        }
        Iterator iterator = toBeAdded.iterator();
        i = 0;
        while (iterator.hasNext()) {
            String subseq = (String)iterator.next();
            this.addPreppedSequence(subseq);
            ++i;
        }
    }

    private void addPreppedSequence(String seq) {
        int i;
        int j = 0;
        SuffixNode oldNode = null;
        boolean canLinkJump = false;
        j = i = this.sequences.length();
        this.sequences = this.sequences.toString() + seq.toString();
        SuffixNode currentNode = this.root;
        while (i < this.sequences.length()) {
            ++this.e;
            while (j <= i) {
                SuffixNode newNode = null;
                while (currentNode != this.root && currentNode.suffixLink == null && canLinkJump) {
                    currentNode = currentNode.parent;
                }
                if (this.root == currentNode) {
                    currentNode = this.jumpTo(this.root, this.sequences, j, i + 1);
                } else {
                    if (canLinkJump) {
                        currentNode = currentNode.suffixLink;
                    }
                    int gammaStart = j + this.getPathLength(currentNode);
                    currentNode = this.jumpTo(currentNode, this.sequences, gammaStart, i + 1);
                }
                if (this.rule == 1) {
                    this.addPositionToLeaf(j, currentNode);
                }
                if (this.rule == 2) {
                    this.doRule2(currentNode, i, j);
                }
                if (this.rule == 3) {
                    currentNode = newNode = this.doRule3(currentNode, i, j);
                }
                if (this.rule == 1 || this.rule == 4 || this.rule == 5) {
                    currentNode = currentNode.parent;
                }
                if (oldNode != null) {
                    if (currentNode.isTerminal()) {
                        currentNode = currentNode.parent;
                    }
                    oldNode.suffixLink = currentNode;
                }
                oldNode = newNode;
                newNode = null;
                if (this.rule == 1 || this.rule == 4 || this.rule == 5) {
                    oldNode = null;
                    canLinkJump = false;
                    break;
                }
                canLinkJump = true;
                ++j;
            }
            ++i;
        }
        this.finishAddition();
    }

    public SuffixNode walkTo(SuffixNode starting, String source, int from, int to) {
        SuffixNode currentNode = starting;
        SuffixNode arrivedAt = starting;
        while (from < to) {
            arrivedAt = (SuffixNode)currentNode.children.get(new Character(source.charAt(from)));
            if (arrivedAt == null) {
                from = to;
                arrivedAt = currentNode;
                this.rule = 2;
                break;
            }
            String edgeLabel = this.getEdgeLabel(arrivedAt);
            if (edgeLabel.length() >= to - from) {
                if (edgeLabel.equals(source.substring(from, to))) {
                    this.rule = arrivedAt.isTerminal() ? 1 : 5;
                }
                this.rule = edgeLabel.substring(0, to - from).equals(source.substring(from, to)) ? 4 : 3;
                from = to;
                continue;
            }
            if (source.substring(from, from + edgeLabel.length()).equals(edgeLabel)) {
                from += edgeLabel.length();
                currentNode = arrivedAt;
                continue;
            }
            this.rule = 3;
            from = to;
        }
        return arrivedAt;
    }

    /*
     * Unable to fully structure code
     */
    public SuffixNode jumpTo(SuffixNode starting, String source, int from, int to) {
        canGoDown = true;
        original = from;
        originalNode = starting;
        i = false;
        currentNode = starting;
        arrivedAt = starting;
        this.rule = 0;
        if (from != to) ** GOTO lbl27
        this.rule = 5;
        return starting;
lbl-1000:
        // 1 sources

        {
            if (currentNode.isTerminal()) {
                System.out.println("ARRGH! at " + source.substring(original, to) + "(" + from + "," + original + "," + to + ") from " + this.getLabel(originalNode));
            }
            if ((arrivedAt = (SuffixNode)currentNode.children.get(new Character(source.charAt(from)))) == null) {
                canGoDown = false;
                arrivedAt = currentNode;
                this.rule = 2;
                break;
            }
            edgeLength = this.getEdgeLength(arrivedAt);
            if (edgeLength >= to - from) {
                before = currentNode.labelEnd + to - from + 1;
                after = this.getPathEnd(arrivedAt) - this.getEdgeLength(arrivedAt) + to - from - 1;
                this.rule = this.sequences.charAt(after) == source.charAt(to - 1) ? (this.getEdgeLength(arrivedAt) == to - from ? (arrivedAt.isTerminal() ? 1 : 5) : 4) : 3;
                canGoDown = false;
                break;
            }
            from += edgeLength;
            currentNode = arrivedAt;
lbl27:
            // 2 sources

            ** while (canGoDown)
        }
lbl28:
        // 3 sources

        return arrivedAt;
    }

    protected int getEdgeLength(SuffixNode child) {
        if (child == this.root) {
            return 0;
        }
        SuffixNode parent = child.parent;
        int parentLength = this.getPathLength(parent);
        int childLength = this.getPathLength(child);
        if (childLength - parentLength <= 0) {
            System.out.println("negative length " + (childLength - parentLength));
            System.out.println(this.getLabel(child) + "," + this.getLabel(parent));
        }
        return childLength - parentLength;
    }

    protected String getEdgeLabel(SuffixNode child) {
        return this.sequences.substring(child.labelStart + (this.getPathLength(child) - this.getEdgeLength(child)), child.labelEnd == -1 ? this.e : child.labelEnd);
    }

    protected int getPathLength(SuffixNode node) {
        return this.getPathEnd(node) - node.labelStart;
    }

    protected int getPathEnd(SuffixNode node) {
        return node.labelEnd == -1 ? this.e : node.labelEnd;
    }

    protected String getLabel(SuffixNode node) {
        if (node == this.root) {
            return "root";
        }
        return this.sequences.substring(node.labelStart, node.labelEnd == -1 ? this.e : node.labelEnd).toString();
    }

    protected ArrayList getAllNodes(SuffixNode root, ArrayList list, boolean leavesOnly) {
        if (list == null) {
            list = new ArrayList();
        }
        if (!leavesOnly || leavesOnly && root.isTerminal()) {
            list.add(root);
        }
        if (!root.isTerminal()) {
            Iterator iterator = root.children.values().iterator();
            while (iterator.hasNext()) {
                list = this.getAllNodes((SuffixNode)iterator.next(), list, leavesOnly);
            }
        }
        return list;
    }

    public void printTree() {
        ArrayList allNodes = this.getAllNodes(this.root, null, false);
        int i = 0;
        while (i < allNodes.size()) {
            SuffixNode node = (SuffixNode)allNodes.get(i);
            if (node == this.root) {
                System.out.println("root");
            } else {
                System.out.println("node " + i + " label " + this.getLabel(node) + " attached to " + this.getLabel(node.parent));
            }
            ++i;
        }
    }

    public SuffixNode getRoot() {
        return this.root;
    }

    private void addPositionToLeaf(int pos, SuffixNode leaf) {
        if (leaf.additionalLabels == null) {
            leaf.additionalLabels = new int[]{pos};
        } else {
            int[] moreLabels = new int[leaf.additionalLabels.length + 1];
            System.arraycopy(leaf.additionalLabels, 0, moreLabels, 0, leaf.additionalLabels.length);
            moreLabels[moreLabels.length - 1] = pos;
            leaf.additionalLabels = moreLabels;
        }
    }

    private void doRule2(SuffixNode parent, int splittingPos, int suffixStart) {
        SuffixNode leaf = new SuffixNode(parent, suffixStart);
        parent.children.put(new Character(this.sequences.charAt(splittingPos)), leaf);
    }

    private SuffixNode doRule3(SuffixNode child, int splittingPos, int suffixStart) {
        SuffixNode parent = child.parent;
        SuffixNode middle = new SuffixNode(parent, suffixStart, splittingPos);
        Character x = new Character(this.sequences.charAt(child.labelStart + this.getPathLength(child) - this.getEdgeLength(child)));
        Character y = new Character(this.sequences.charAt(child.labelStart + this.getPathLength(child) - this.getEdgeLength(child) + this.getEdgeLength(middle)));
        parent.children.remove(x);
        parent.children.put(x, middle);
        middle.children.put(y, child);
        child.parent = middle;
        this.doRule2(middle, splittingPos, suffixStart);
        return middle;
    }

    private void finishAddition() {
        ArrayList leaves = this.getAllNodes(this.root, null, true);
        int i = 0;
        while (i < leaves.size()) {
            SuffixNode leaf = (SuffixNode)leaves.get(i);
            if (leaf.labelEnd == -1) {
                leaf.labelEnd = this.e;
            }
            ++i;
        }
    }

    private void checkParent(SuffixNode child) {
        SuffixNode parent = child.parent;
        String parentLabel = this.getLabel(parent);
        String label = this.getLabel(child);
        if (parentLabel.equals("root")) {
            parentLabel = "";
        }
        if (parentLabel.length() >= label.length() || !parentLabel.equals(label.substring(0, parentLabel.length()))) {
            System.err.println("bad addition on rule " + this.rule);
            System.err.println(parentLabel + " against " + label);
            System.err.println("child (" + child.labelStart + "," + (child.labelEnd == -1 ? this.e : child.labelEnd) + ")");
            System.err.println("parent (" + parent.labelStart + "," + parent.labelEnd + ")");
        }
    }

    public boolean subStringExists(String str) {
        this.walkTo(this.root, str, 0, str.length());
        return this.rule == 1 || this.rule == 4 || this.rule == 5;
    }

    class SuffixNode {
        static final int A_LEAF = -1;
        SuffixNode parent = null;
        SuffixNode suffixLink = null;
        int labelStart = 0;
        int labelEnd = 0;
        HashMap children = new HashMap();
        int[] additionalLabels = null;

        public SuffixNode() {
        }

        public SuffixNode(SuffixNode parent, int position) {
            this();
            this.parent = parent;
            this.labelStart = position;
            this.labelEnd = -1;
            this.children = null;
        }

        public SuffixNode(SuffixNode parent, int labelStart, int labelStop) {
            this();
            this.parent = parent;
            this.labelStart = labelStart;
            this.labelEnd = labelStop;
        }

        public boolean isTerminal() {
            return this.children == null;
        }
    }
}

