/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.xml;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.biojava.utils.xml.XMLPeerFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.helpers.AttributeListImpl;

public class XMLPeerBuilder
implements DocumentHandler {
    private static AttributeList emptyAttributes = new AttributeListImpl();
    private XMLPeerFactory peerFactory;
    private boolean isComplete = true;
    private List stack;
    private StackEntry stackTop = null;
    private Object topLevel = null;

    public XMLPeerBuilder(XMLPeerFactory f) {
        this.peerFactory = f;
        this.stack = new LinkedList();
    }

    public Object getTopLevelObject() {
        if (this.isComplete) {
            return this.topLevel;
        }
        return null;
    }

    public void characters(char[] ch, int start, int len) {
        String child = new String(ch, start, len);
        this.stackTop.objs.add(child);
    }

    public void ignorableWhitespace(char[] ch, int start, int len) {
    }

    public void startDocument() {
        this.isComplete = false;
        this.topLevel = new LinkedList();
    }

    public void setDocumentLocator(Locator l) {
    }

    public void endDocument() {
        this.isComplete = true;
    }

    public void processingInstruction(String target, String data) {
    }

    public void startElement(String name, AttributeList al) {
        this.stack.add(0, this.stackTop);
        this.stackTop = new StackEntry();
        this.stackTop.al = al.getLength() == 0 ? emptyAttributes : new AttributeListImpl(al);
        this.stackTop.objs = null;
    }

    public void endElement(String name) {
        Object o = this.peerFactory.getXMLPeer(name, this.stackTop.objs != null ? this.stackTop.objs : Collections.EMPTY_LIST, this.stackTop.al);
        this.stackTop = (StackEntry)this.stack.remove(0);
        if (o != null) {
            if (this.stackTop == null) {
                this.topLevel = o;
            } else {
                if (this.stackTop.objs == null) {
                    this.stackTop.objs = new LinkedList();
                }
                this.stackTop.objs.add(o);
            }
        }
    }

    class StackEntry {
        List objs;
        AttributeList al;

        StackEntry() {
        }
    }
}

