/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.emboss.jemboss.editor.Matrix;
import org.emboss.jemboss.editor.Sequence;

public class Consensus {
    private int[][] matrix;
    private String cons = "";

    public Consensus(File file, Vector vector, float f, float f2, int n) {
        Matrix matrix = new Matrix(file);
        this.matrix = matrix.getMatrix();
        this.calculateCons(matrix, vector, f, f2, n);
    }

    public Consensus(String string, String string2, Vector vector, float f, float f2, int n) {
        this(new Matrix(string, string2), vector, f, f2, n);
    }

    public Consensus(Matrix matrix, Vector vector, float f, float f2, int n) {
        this.matrix = matrix.getMatrix();
        this.calculateCons(matrix, vector, f, f2, n);
    }

    private void calculateCons(Matrix matrix, Vector vector, float f, float f2, int n) {
        int n2 = vector.size();
        int n3 = this.getMaxSequenceLength(vector);
        String string = "-";
        if (((Sequence)vector.get(0)).isProtein()) {
            string = "x";
        }
        String string2 = "";
        int n4 = matrix.getIDimension();
        float[] fArray = new float[n4];
        float[] fArray2 = new float[n4];
        float[] fArray3 = new float[n2];
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (int i = 0; i < n3; ++i) {
            int n5;
            String string3;
            int n6;
            int n7;
            String string4;
            int n8;
            string2 = string;
            for (n8 = 0; n8 < n4; ++n8) {
                fArray[n8] = 0.0f;
                fArray2[n8] = 0.0f;
            }
            for (n8 = 0; n8 < n2; ++n8) {
                fArray3[n8] = 0.0f;
            }
            for (n8 = 0; n8 < n2; ++n8) {
                string4 = this.getResidue(vector, n8, i);
                n7 = matrix.getMatrixIndex(string4);
                if (n7 >= 0) {
                    int n9 = n7;
                    fArray[n9] = fArray[n9] + this.getSequenceWeight(vector, n8);
                }
                for (n6 = n8 + 1; n6 < n2; ++n6) {
                    string3 = this.getResidue(vector, n6, i);
                    n5 = matrix.getMatrixIndex(string3);
                    if (n7 < 0 || n5 < 0) continue;
                    f3 = (float)this.matrix[n7][n5] * this.getSequenceWeight(vector, n6) + fArray3[n8];
                    f4 = (float)this.matrix[n7][n5] * this.getSequenceWeight(vector, n8) + fArray3[n6];
                    fArray3[n8] = f3;
                    fArray3[n6] = f4;
                }
            }
            int n10 = -1;
            float f5 = -2.1474836E9f;
            for (n8 = 0; n8 < n2; ++n8) {
                if (!(fArray3[n8] > f5) && (fArray3[n8] != f5 || !this.getResidue(vector, n10, i).equals("-") && !this.getResidue(vector, n10, i).equals("."))) continue;
                n10 = n8;
                f5 = fArray3[n8];
            }
            for (n8 = 0; n8 < n2; ++n8) {
                string4 = this.getResidue(vector, n8, i);
                n7 = matrix.getMatrixIndex(string4);
                if (fArray2[n7] != 0.0f) continue;
                for (n6 = 0; n6 < n2; ++n6) {
                    if (n8 == n6) continue;
                    string3 = this.getResidue(vector, n6, i);
                    n5 = matrix.getMatrixIndex(string3);
                    if (n7 < 0 || n5 < 0 || this.matrix[n7][n5] <= 0) continue;
                    int n11 = n7;
                    fArray2[n11] = fArray2[n11] + this.getSequenceWeight(vector, n6);
                }
            }
            int n12 = 0;
            int n13 = 0;
            for (n8 = 0; n8 < n2; ++n8) {
                string4 = this.getResidue(vector, n8, i);
                n7 = matrix.getMatrixIndex(string4);
                if (n7 < 0 || !(fArray[n7] > fArray[n13])) continue;
                n13 = n7;
            }
            for (n8 = 0; n8 < n2; ++n8) {
                string4 = this.getResidue(vector, n8, i);
                n7 = matrix.getMatrixIndex(string4);
                if (n7 < 0) continue;
                if (fArray2[n7] > fArray2[n12]) {
                    n12 = n7;
                    continue;
                }
                if (fArray2[n7] != fArray2[n12] || !(fArray[n7] > fArray[n12])) continue;
                n12 = n7;
            }
            string4 = this.getResidue(vector, n10, i);
            n7 = matrix.getMatrixIndex(string4);
            if (n7 >= 0 && fArray2[n7] >= f && !string4.equals("-") && !string4.equals(".")) {
                string2 = string4;
            }
            if (fArray2[n7] <= f2) {
                string2 = string2.toLowerCase();
            }
            if (n > 0) {
                n6 = 0;
                for (n8 = 0; n8 < n2; ++n8) {
                    string4 = this.getResidue(vector, n8, i);
                    n7 = matrix.getMatrixIndex(string4);
                    if (n12 != n7 || string4.equals("-") || string4.equals(".")) continue;
                    ++n6;
                }
                if (n6 < n) {
                    string2 = string;
                }
            }
            this.cons = this.cons.concat(string2);
        }
    }

    public boolean isEqualSequenceLength(Vector vector) {
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Sequence sequence = (Sequence)enumeration.nextElement();
            if (n2 > 0 && n != sequence.getLength()) {
                return false;
            }
            n = sequence.getLength();
            ++n2;
        }
        return true;
    }

    public int getMaxSequenceLength(Vector vector) {
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Sequence sequence = (Sequence)enumeration.nextElement();
            if (n >= sequence.getLength()) continue;
            n = sequence.getLength();
        }
        return n;
    }

    public Sequence getConsensusSequence() {
        return new Sequence("Consensus", this.cons);
    }

    public float getSequenceWeight(Vector vector, int n) {
        return ((Sequence)vector.get(n)).getWeight();
    }

    public String getResidue(Vector vector, int n, int n2) {
        String string = "-";
        try {
            string = ((Sequence)vector.get(n)).getSequence().substring(n2, n2 + 1);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return string;
    }

    public static void main(String[] stringArray) {
        Vector<Sequence> vector = new Vector<Sequence>();
        vector.add(new Sequence("MHQDGISSMNQLGGLFVNGRPQ"));
        vector.add(new Sequence("-MQNSHSGVNQLGGVFVNGRPQ"));
        vector.add(new Sequence("STPLGQGRVNQLGGVFINGRPP"));
        vector.add(new Sequence("STPLGQGRVNQLGGVFINGRPP"));
        vector.add(new Sequence("-MEQTYGEVNQLGGVFVNGRPE"));
        vector.add(new Sequence("-MEQTYGEVNQLGGVFVNGRPE"));
        vector.add(new Sequence("MHQDGISSMNQLGGLFVNGRPH"));
        vector.add(new Sequence("MHQDGISSMNQLGGLFVNGRPR"));
        vector.add(new Sequence("MHQDGISSMNQLLGLFVNGRPR"));
        vector.add(new Sequence("MHQDGISSMNQLLGGGGGGGGR"));
        new Consensus(new File("/packages/emboss_dev/tcarver/emboss/emboss/emboss/data/EBLOSUM62"), vector, 49.75f, 0.0f, 0);
    }
}

