/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import java.io.IOException;
import java.util.StringTokenizer;
import uk.ac.sanger.artemis.AlignMatch;
import uk.ac.sanger.artemis.ComparisonData;
import uk.ac.sanger.artemis.ComparisonDataParseException;
import uk.ac.sanger.artemis.SimpleComparisonData;
import uk.ac.sanger.artemis.util.LinePushBackReader;

public class MegaBlastComparisonData
extends SimpleComparisonData
implements ComparisonData {
    public MegaBlastComparisonData(LinePushBackReader stream) throws IOException {
        super(stream);
    }

    public MegaBlastComparisonData() {
    }

    protected SimpleComparisonData getNewSimpleComparisonData() {
        return new MegaBlastComparisonData();
    }

    private static AlignMatch makeMatchFromStringStatic(String line) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        if (tokenizer.countTokens() != 6) {
            String message = "while reading MegaBlast data: not enough fields in this line: " + line;
            throw new ComparisonDataParseException(message);
        }
        String file_names = tokenizer.nextToken();
        if (!file_names.startsWith("'") || !file_names.endsWith("'") || file_names.indexOf("==") == -1) {
            String message = "while reading MegaBlast data: first field (" + file_names + ") is badly formatted in this line: " + line;
            throw new ComparisonDataParseException(message);
        }
        String s_start_token = tokenizer.nextToken();
        String q_start_token = tokenizer.nextToken();
        String s_end_token = tokenizer.nextToken();
        String q_end_token = tokenizer.nextToken();
        if (!s_start_token.startsWith("(")) {
            String message = "while reading MegaBlast data: second field " + s_start_token + " " + q_start_token + " " + s_end_token + " " + q_end_token + " is badly formatted in this line: " + line;
            throw new ComparisonDataParseException(message);
        }
        s_start_token = s_start_token.substring(1);
        if (!q_end_token.endsWith(")")) {
            String message = "while reading MegaBlast data: second field (" + s_start_token + " " + q_start_token + " " + s_end_token + " " + q_end_token + " is badly formatted in this line: " + line;
            throw new ComparisonDataParseException(message);
        }
        q_end_token = q_end_token.substring(0, q_end_token.length() - 1);
        tokenizer.nextToken();
        try {
            int q_start = Integer.valueOf(q_start_token);
            int q_end = Integer.valueOf(q_end_token);
            int s_start = Integer.valueOf(s_start_token);
            int s_end = Integer.valueOf(s_end_token);
            return SimpleComparisonData.makeAlignMatch(s_start, s_end, q_start, q_end, 100, 100);
        }
        catch (NumberFormatException e) {
            throw new IOException("while reading blast -m 8 data: failed to parse a number from this string: " + e.getMessage());
        }
    }

    protected AlignMatch makeMatchFromString(String line) throws IOException {
        return MegaBlastComparisonData.makeMatchFromStringStatic(line);
    }

    public static boolean formatCorrect(String line) {
        try {
            MegaBlastComparisonData.makeMatchFromStringStatic(line);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

