/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.components.BasePlot;
import uk.ac.sanger.artemis.components.DisplayAdjustmentEvent;
import uk.ac.sanger.artemis.components.DisplayAdjustmentListener;
import uk.ac.sanger.artemis.plot.AGWindowAlgorithm;
import uk.ac.sanger.artemis.plot.ATDeviationAlgorithm;
import uk.ac.sanger.artemis.plot.Algorithm;
import uk.ac.sanger.artemis.plot.BaseAlgorithm;
import uk.ac.sanger.artemis.plot.Codon12CorrelationAlgorithm;
import uk.ac.sanger.artemis.plot.CodonUsageAlgorithm;
import uk.ac.sanger.artemis.plot.GCDeviationAlgorithm;
import uk.ac.sanger.artemis.plot.GCFrameAlgorithm;
import uk.ac.sanger.artemis.plot.GCSDWindowAlgorithm;
import uk.ac.sanger.artemis.plot.GCWindowAlgorithm;
import uk.ac.sanger.artemis.plot.KarlinSigAlgorithm;
import uk.ac.sanger.artemis.sequence.Strand;

public class BasePlotGroup
extends JPanel
implements DisplayAdjustmentListener {
    private final EntryGroup entry_group;
    private final Vector plot_value_producers = new Vector();
    private final GridBagLayout gridbag = new GridBagLayout();
    private final GridBagConstraints c = new GridBagConstraints();
    private Selection selection;
    private GotoEventSource goto_event_source;
    private Component owning_component;

    public BasePlotGroup(EntryGroup entry_group, Component owning_component, Selection selection, GotoEventSource goto_event_source) {
        this.owning_component = owning_component;
        this.entry_group = entry_group;
        this.selection = selection;
        this.goto_event_source = goto_event_source;
        Strand forward_strand = entry_group.getBases().getForwardStrand();
        Strand reverse_strand = entry_group.getBases().getReverseStrand();
        float[][] test_weights = new float[][]{{1.0f, 0.0f, 39.0f, 99.0f, 11.0f}, {76.0f, 8.0f, 15.0f, 1.0f, 45.0f}, {2.0f, 0.0f, 42.0f, 0.0f, 6.0f}, {21.0f, 91.0f, 4.0f, 0.0f, 38.0f}};
        float[][] test_weights2 = new float[][]{{11.0f, 11.0f, 10.0f, 8.0f, 11.0f, 10.0f, 11.0f, 11.0f, 7.0f, 8.0f, 25.0f, 3.0f, 100.0f, 0.0f, 27.0f}, {29.0f, 33.0f, 30.0f, 30.0f, 32.0f, 34.0f, 37.0f, 38.0f, 39.0f, 36.0f, 26.0f, 75.0f, 0.0f, 0.0f, 14.0f}, {14.0f, 12.0f, 10.0f, 10.0f, 9.0f, 11.0f, 10.0f, 9.0f, 7.0f, 6.0f, 26.0f, 1.0f, 0.0f, 100.0f, 49.0f}, {46.0f, 44.0f, 50.0f, 52.0f, 48.0f, 45.0f, 42.0f, 43.0f, 47.0f, 51.0f, 23.0f, 21.0f, 0.0f, 0.0f, 10.0f}};
        float[][] test_weights3 = new float[][]{{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f}};
        float[] cai_test = new float[]{0.113f, 1.0f, 0.117f, 1.0f, 1.0f, 0.693f, 0.036f, 0.005f, 0.071f, 1.0f, 0.0f, 0.0f, 1.0f, 0.077f, 0.0f, 1.0f, 0.006f, 0.003f, 0.039f, 0.003f, 0.047f, 0.009f, 1.0f, 0.002f, 0.245f, 1.0f, 1.0f, 0.007f, 0.137f, 0.002f, 0.002f, 0.002f, 0.823f, 1.0f, 0.003f, 1.0f, 0.921f, 1.0f, 0.012f, 0.006f, 0.053f, 1.0f, 0.135f, 1.0f, 0.021f, 0.031f, 1.0f, 0.003f, 1.0f, 0.831f, 0.002f, 0.018f, 1.0f, 0.316f, 0.015f, 0.001f, 0.554f, 1.0f, 1.0f, 0.016f, 1.0f, 0.02f, 0.002f, 0.004f};
        this.setLayout(this.gridbag);
        this.c.fill = 2;
        this.c.anchor = 11;
        this.c.gridwidth = 0;
        this.c.gridheight = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.insets = new Insets(0, 0, 5, 0);
        this.addAlgorithm(new GCWindowAlgorithm(forward_strand));
        this.addAlgorithm(new GCSDWindowAlgorithm(forward_strand));
        this.addAlgorithm(new AGWindowAlgorithm(forward_strand));
        this.addAlgorithm(new GCFrameAlgorithm(forward_strand));
        this.addAlgorithm(new GCFrameAlgorithm(reverse_strand));
        this.addAlgorithm(new Codon12CorrelationAlgorithm(forward_strand));
        this.addAlgorithm(new Codon12CorrelationAlgorithm(reverse_strand));
        this.addAlgorithm(new GCDeviationAlgorithm(forward_strand));
        this.addAlgorithm(new ATDeviationAlgorithm(forward_strand));
        this.addAlgorithm(new KarlinSigAlgorithm(forward_strand));
    }

    public void displayAdjustmentValueChanged(DisplayAdjustmentEvent event) {
        Component[] children = this.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof BasePlot)) continue;
            ((BasePlot)children[i]).displayAdjustmentValueChanged(event);
        }
    }

    public BasePlot addAlgorithm(BaseAlgorithm algorithm) {
        this.plot_value_producers.addElement(algorithm);
        return this.makePlot(algorithm, this.gridbag, this.c);
    }

    public CodonUsageAlgorithm getCodonUsageAlgorithm() {
        for (int i = 0; i < this.plot_value_producers.size(); ++i) {
            BaseAlgorithm this_algorithm = (BaseAlgorithm)this.plot_value_producers.elementAt(i);
            if (!(this_algorithm instanceof CodonUsageAlgorithm)) continue;
            return (CodonUsageAlgorithm)this_algorithm;
        }
        return null;
    }

    public BaseAlgorithm[] getPlotAlgorithms() {
        BaseAlgorithm[] return_array = new BaseAlgorithm[this.plot_value_producers.size()];
        for (int i = 0; i < this.plot_value_producers.size(); ++i) {
            BaseAlgorithm this_algorithm;
            return_array[i] = this_algorithm = (BaseAlgorithm)this.plot_value_producers.elementAt(i);
        }
        return return_array;
    }

    public boolean basePlotIsVisible(Algorithm algorithm) {
        JComponent base_plot = this.findPlotByAlgorithm(algorithm);
        return base_plot.isVisible();
    }

    public void setVisibleByAlgorithm(Algorithm algorithm, boolean visible) {
        JComponent base_plot = this.findPlotByAlgorithm(algorithm);
        base_plot.setVisible(visible);
        if (this.getParent() != null) {
            this.getParent().validate();
        }
    }

    private JComponent findPlotByAlgorithm(Algorithm algorithm) {
        Component[] children = this.getComponents();
        for (int i = 0; i < children.length; ++i) {
            Algorithm component_algorithm;
            if (!(children[i] instanceof BasePlot) || (component_algorithm = ((BasePlot)children[i]).getAlgorithm()) != algorithm) continue;
            return (JComponent)children[i];
        }
        return null;
    }

    private BasePlot makePlot(BaseAlgorithm algorithm, GridBagLayout gridbag, GridBagConstraints constraints) {
        BasePlot new_base_plot = new BasePlot(algorithm, this.getSelection(), this.getGotoEventSource());
        gridbag.setConstraints(new_base_plot, constraints);
        this.add(new_base_plot);
        new_base_plot.setVisible(false);
        this.getSelection().addSelectionChangeListener(new_base_plot);
        if (this.getParent() != null) {
            this.getParent().validate();
        }
        return new_base_plot;
    }

    private Selection getSelection() {
        return this.selection;
    }

    private EntryGroup getEntryGroup() {
        return this.entry_group;
    }

    private GotoEventSource getGotoEventSource() {
        return this.goto_event_source;
    }
}

