/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.io.IOException;
import javax.swing.JFrame;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntrySource;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.components.LogReadListener;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.ProgressThread;
import uk.ac.sanger.artemis.components.Splash;
import uk.ac.sanger.artemis.components.TextDialog;
import uk.ac.sanger.artemis.components.YesNoDialog;
import uk.ac.sanger.artemis.io.DocumentEntry;
import uk.ac.sanger.artemis.io.DocumentEntryFactory;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.NoSequenceException;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.DocumentFactory;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class DbfetchEntrySource
implements EntrySource {
    private JFrame frame = null;

    public DbfetchEntrySource(JFrame frame) {
    }

    public Entry getEntry(Bases bases, ProgressThread progress_thread, boolean show_progress) throws OutOfRangeException, IOException {
        return this.getEntry(bases, show_progress, progress_thread);
    }

    public Entry getEntry(Bases bases, boolean show_progress) throws OutOfRangeException, IOException {
        return this.getEntry(bases, show_progress, null);
    }

    public Entry getEntry(Bases bases, boolean show_progress, ProgressThread progress_thread) throws OutOfRangeException, IOException {
        TextDialog text_dialog = new TextDialog(this.getFrame(), "Enter an accession number:", 10, "");
        String text = text_dialog.getText();
        if (text == null) {
            return null;
        }
        String embl_id = text.trim();
        if (embl_id.length() > 0) {
            LogReadListener read_event_logger = new LogReadListener(embl_id);
            SimpleEntryInformation entry_information = new SimpleEntryInformation(Options.getArtemisEntryInformation());
            if (progress_thread != null) {
                progress_thread.start();
            }
            String url_string = "http://www.ebi.ac.uk/cgi-bin/dbfetch?db=EMBL&id=" + embl_id;
            Document url_document = DocumentFactory.makeDocument(url_string);
            try {
                Bases real_bases;
                YesNoDialog yes_no_dialog;
                DocumentEntry new_embl_entry = DocumentEntryFactory.makeDocumentEntry(entry_information, url_document, read_event_logger);
                if (read_event_logger.seenMessage() && (yes_no_dialog = new YesNoDialog(this.frame, "there were warnings while reading - view now?")).getResult()) {
                    Splash.showLog();
                }
                if (bases == null) {
                    if (new_embl_entry.getSequence() == null) {
                        String message = "the entry contains no sequence: " + embl_id;
                        new MessageDialog(this.getFrame(), message);
                        return null;
                    }
                    real_bases = new Bases(new_embl_entry.getSequence());
                } else {
                    real_bases = bases;
                }
                return new Entry(real_bases, new_embl_entry);
            }
            catch (EntryInformationException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
        }
        return null;
    }

    public Entry getEntry(boolean show_progress) throws OutOfRangeException, NoSequenceException, IOException {
        return this.getEntry(null, show_progress);
    }

    public Entry getEntry(boolean show_progress, ProgressThread progress_thread) throws OutOfRangeException, NoSequenceException, IOException {
        return this.getEntry(null, show_progress, progress_thread);
    }

    public String getSourceName() {
        return "EBI - Dbfetch";
    }

    public boolean isFullEntrySource() {
        return true;
    }

    public JFrame getFrame() {
        return this.frame;
    }
}

