/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JFrame;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryChangeListener;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.EntryGroupChangeEvent;
import uk.ac.sanger.artemis.EntryGroupChangeListener;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeatureChangeListener;
import uk.ac.sanger.artemis.FeatureEnumeration;
import uk.ac.sanger.artemis.FeaturePredicate;
import uk.ac.sanger.artemis.FeatureSegmentVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.components.FileViewer;
import uk.ac.sanger.artemis.components.SelectionViewer;
import uk.ac.sanger.artemis.io.FuzzyRange;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.SequenceChangeEvent;
import uk.ac.sanger.artemis.sequence.SequenceChangeListener;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.StringVector;

public class EntryGroupInfoDisplay
implements FeatureChangeListener,
EntryChangeListener,
EntryGroupChangeListener,
SequenceChangeListener {
    public static final int FORWARD = 1;
    public static final int REVERSE = 2;
    public static final int BOTH = 3;
    private EntryGroup entry_group;
    private int strand_flag;
    private FileViewer file_viewer;
    private JFrame parent_frame;

    public EntryGroupInfoDisplay(JFrame parent_frame, EntryGroup entry_group) {
        this(parent_frame, entry_group, 3);
    }

    public EntryGroupInfoDisplay(JFrame parent_frame, EntryGroup entry_group, int strand_flag) {
        this.strand_flag = strand_flag;
        this.parent_frame = parent_frame;
        this.entry_group = entry_group;
        if (strand_flag == 1) {
            FeaturePredicate forward_feature_predicate = new FeaturePredicate(){

                public boolean testPredicate(Feature test_feature) {
                    return test_feature.isForwardFeature();
                }
            };
            FilteredEntryGroup filtered_entry_group = new FilteredEntryGroup(entry_group, forward_feature_predicate, "forward strand features");
            entry_group = filtered_entry_group;
        } else if (strand_flag == 2) {
            FeaturePredicate reverse_feature_predicate = new FeaturePredicate(){

                public boolean testPredicate(Feature test_feature) {
                    return !test_feature.isForwardFeature();
                }
            };
            FilteredEntryGroup filtered_entry_group = new FilteredEntryGroup(entry_group, reverse_feature_predicate, "reverse strand features");
            entry_group = filtered_entry_group;
        } else if (strand_flag != 3) {
            throw new Error("internal error - illegal argument");
        }
        this.file_viewer = new FileViewer(this.getFrameName());
        this.updateView();
        entry_group.addEntryChangeListener(this);
        entry_group.addFeatureChangeListener(this);
        entry_group.addEntryGroupChangeListener(this);
        entry_group.getBases().addSequenceChangeListener(this, 5);
        this.file_viewer.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent event) {
                EntryGroupInfoDisplay.this.stopListening();
            }
        });
    }

    private String getFrameName() {
        if (this.entry_group instanceof FilteredEntryGroup) {
            FilteredEntryGroup filtered_entry_group = (FilteredEntryGroup)this.entry_group;
            String filter_name = filtered_entry_group.getFilterName();
            if (filter_name == null) {
                return "Artemis overview of: " + this.parent_frame.getTitle();
            }
            return "Artemis overview of: " + this.parent_frame.getTitle() + " (" + filter_name + ")";
        }
        StringBuffer buffer = new StringBuffer("Artemis Overview");
        if (this.entry_group.size() > 0) {
            buffer.append(" of:");
            for (int i = 0; i < this.entry_group.size(); ++i) {
                Entry this_entry = this.entry_group.elementAt(i);
                if (this_entry.getName() == null) {
                    buffer.append(" [no name]");
                    continue;
                }
                buffer.append(" " + this_entry.getName());
            }
        }
        return buffer.toString();
    }

    private void stopListening() {
        this.entry_group.removeEntryChangeListener(this);
        this.entry_group.removeEntryGroupChangeListener(this);
        this.entry_group.removeFeatureChangeListener(this);
        this.entry_group.getBases().removeSequenceChangeListener(this);
    }

    public void featureChanged(FeatureChangeEvent event) {
        this.updateView();
    }

    public void entryGroupChanged(EntryGroupChangeEvent event) {
        if (event.getType() == 6) {
            this.stopListening();
            this.file_viewer.dispose();
        } else {
            this.updateView();
        }
    }

    public void entryChanged(EntryChangeEvent event) {
        this.updateView();
    }

    public void sequenceChanged(SequenceChangeEvent event) {
        this.updateView();
    }

    private void updateView() {
        String frame_name = this.getFrameName();
        this.file_viewer.setTitle(frame_name);
        StringBuffer buffer = new StringBuffer();
        buffer.append(frame_name + "\n\n");
        buffer.append("Number of bases: " + this.entry_group.getSequenceLength() + "\n");
        buffer.append("Number of features in the active entries: " + this.entry_group.getAllFeaturesCount() + "\n\n");
        Bases entry_group_bases = this.entry_group.getBases();
        int gene_count = 0;
        int cds_count = 0;
        int spliced_gene_count = 0;
        int spliced_gene_bases_count = 0;
        StringBuffer gene_bases_buffer = new StringBuffer();
        int gene_bases_count_with_introns = 0;
        int cds_bases_count = 0;
        int exon_count = 0;
        int intron_count = 0;
        int partial_count = 0;
        Hashtable<String, Hashtable> table = new Hashtable<String, Hashtable>();
        FeatureEnumeration feature_enumerator = this.entry_group.features();
        while (feature_enumerator.hasMoreFeatures()) {
            Qualifier pseudo_qualifier;
            Feature this_feature = feature_enumerator.nextFeature();
            Key key = this_feature.getKey();
            String key_string = key.toString();
            Location location = this_feature.getLocation();
            RangeVector ranges = location.getRanges();
            for (int i = 0; i < ranges.size(); ++i) {
                if (!(ranges.elementAt(i) instanceof FuzzyRange)) continue;
                ++partial_count;
            }
            try {
                Hashtable colour_table;
                String colour = this_feature.getValueOfQualifier("colour");
                if (colour == null || colour.length() == 0) {
                    colour = "no colour";
                }
                if (table.containsKey(key_string)) {
                    colour_table = (Hashtable)table.get(key_string);
                    Integer colour_value = (Integer)colour_table.get(colour);
                    if (colour_value == null) {
                        colour_table.put(colour, new Integer(1));
                    } else {
                        int old_value = colour_value;
                        colour_table.put(colour, new Integer(old_value + 1));
                    }
                } else {
                    colour_table = new Hashtable();
                    colour_table.put(colour, new Integer(1));
                    table.put(key_string, colour_table);
                }
            }
            catch (InvalidRelationException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
            if (!this_feature.isCDS()) continue;
            ++cds_count;
            cds_bases_count += this_feature.getBaseCount();
            try {
                pseudo_qualifier = this_feature.getQualifierByName("pseudo");
            }
            catch (InvalidRelationException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
            if (pseudo_qualifier != null) continue;
            ++gene_count;
            FeatureSegmentVector segments = this_feature.getSegments();
            if (segments.size() > 1) {
                ++spliced_gene_count;
                spliced_gene_bases_count += this_feature.getBaseCount();
                intron_count += segments.size() - 1;
            }
            exon_count += segments.size();
            gene_bases_buffer.append(this_feature.getBases());
            gene_bases_count_with_introns += this_feature.getRawLastBase() - this_feature.getRawFirstBase() + 1;
        }
        String gene_bases = gene_bases_buffer.toString();
        int gene_bases_count = gene_bases.length();
        int pseudo_gene_count = cds_count - gene_count;
        int pseudo_gene_bases_count = cds_bases_count - gene_bases_count;
        if (cds_count > 0) {
            if (gene_count > 0) {
                buffer.append("Genes (CDS features without a /pseudo qualifier):\n");
                int non_spliced_gene_count = gene_count - spliced_gene_count;
                int non_spliced_gene_bases_count = gene_bases_count - spliced_gene_bases_count;
                if (spliced_gene_count > 0) {
                    buffer.append("   spliced:\n");
                    buffer.append("      count: " + spliced_gene_count + "\n");
                    buffer.append("      bases: " + spliced_gene_bases_count + "\n");
                    buffer.append("      introns: " + intron_count + "\n");
                }
                if (non_spliced_gene_count > 0) {
                    buffer.append("   non-spliced:\n");
                    buffer.append("      count: " + non_spliced_gene_count + "\n");
                    buffer.append("      bases: " + non_spliced_gene_bases_count + "\n");
                }
                buffer.append("   all:\n");
                buffer.append("      count: " + gene_count + "\n");
                buffer.append("      partials: " + partial_count + "\n");
                if (exon_count == gene_count) {
                    buffer.append("      bases: " + gene_bases_count + "\n");
                } else {
                    buffer.append("      bases (excluding introns): " + gene_bases_count + "\n");
                    buffer.append("      bases (including introns): " + gene_bases_count_with_introns + "\n");
                    buffer.append("      exons: " + exon_count + "\n");
                    buffer.append("      average exon length: " + (double)(10L * (long)gene_bases_count / (long)exon_count) / 10.0 + "\n");
                    buffer.append("      average intron length: " + (double)(10L * (long)(gene_bases_count_with_introns - gene_bases_count) / (long)(exon_count - gene_count)) / 10.0 + "\n");
                    buffer.append("      average number of exons per gene: " + (double)(100L * (long)exon_count / (long)gene_count) / 100.0 + "\n");
                }
                buffer.append("      density: " + (double)(1000000L * (long)gene_count / (long)this.entry_group.getSequenceLength()) / 1000.0 + " genes per kb   (" + this.entry_group.getSequenceLength() / gene_count + " bases per gene)\n");
                buffer.append("      average length: " + gene_bases_count / gene_count + "\n");
                buffer.append("      average length (including introns): " + gene_bases_count_with_introns / gene_count + "\n");
                buffer.append("      coding percentage: " + (double)(1000L * (long)gene_bases_count / (long)this.entry_group.getSequenceLength()) / 10.0 + "\n");
                buffer.append("      coding percentage (including introns): " + (double)(1000L * (long)gene_bases_count_with_introns / (long)this.entry_group.getSequenceLength()) / 10.0 + "\n\n");
                buffer.append("      gene sequence composition:\n\n");
                StringVector gene_base_summary = SelectionViewer.getBaseSummary(gene_bases);
                for (int i = 0; i < gene_base_summary.size(); ++i) {
                    buffer.append("         ");
                    buffer.append(gene_base_summary.elementAt(i)).append("\n");
                }
                buffer.append("\n");
            }
            if (pseudo_gene_count > 0) {
                buffer.append("Pseudo genes (CDS features with a /pseudo qualifier):\n");
                buffer.append("   count: " + pseudo_gene_count + "\n");
                buffer.append("   bases: " + pseudo_gene_bases_count + "\n");
                buffer.append("   average length: " + pseudo_gene_bases_count / pseudo_gene_count + "\n\n");
            }
            if (pseudo_gene_count > 0) {
                buffer.append("All CDS features:\n");
                buffer.append("   count: " + cds_count + "\n");
                buffer.append("   bases: " + cds_bases_count + "\n");
                buffer.append("   average length: " + cds_bases_count / cds_count + "\n\n");
            }
        }
        Strand strand = this.strand_flag == 1 || this.strand_flag == 3 ? this.entry_group.getBases().getForwardStrand() : this.entry_group.getBases().getReverseStrand();
        StringVector base_summary = SelectionViewer.getBaseSummary(strand.getStrandBases());
        buffer.append("\nOverall sequence composition:\n\n");
        for (int i = 0; i < base_summary.size(); ++i) {
            buffer.append(base_summary.elementAt(i)).append("\n");
        }
        buffer.append("\nSummary of the active entries:\n");
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            String this_key = (String)e.nextElement();
            Hashtable colour_table = (Hashtable)table.get(this_key);
            buffer.append(this_key + ": ");
            StringBuffer colour_string = new StringBuffer();
            Enumeration colour_enum = colour_table.keys();
            int total = 0;
            while (colour_enum.hasMoreElements()) {
                String this_colour = (String)colour_enum.nextElement();
                int colour_count = (Integer)colour_table.get(this_colour);
                total += colour_count;
                String end_string = this_colour.equals("no colour") ? "no colour" : "colour: " + this_colour;
                if (colour_count == 1) {
                    colour_string.append("  one has " + end_string + "\n");
                    continue;
                }
                colour_string.append("  " + colour_count + " have " + end_string + "\n");
            }
            buffer.append(total + "\n");
            buffer.append(colour_string);
        }
        this.file_viewer.setText(buffer.toString());
    }
}

