/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryChangeListener;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.EntryGroupChangeEvent;
import uk.ac.sanger.artemis.EntryGroupChangeListener;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.TextRequester;
import uk.ac.sanger.artemis.components.TextRequesterEvent;
import uk.ac.sanger.artemis.components.TextRequesterListener;
import uk.ac.sanger.artemis.components.YesNoDialog;

public class EntryGroupMenu
extends JMenu
implements EntryGroupChangeListener,
EntryChangeListener {
    private EntryGroup entry_group;
    private Vector entry_components = new Vector();
    private JFrame frame = null;

    public EntryGroupMenu(JFrame frame, EntryGroup entry_group, String menu_name) {
        super(menu_name);
        this.frame = frame;
        this.entry_group = entry_group;
        entry_group.addEntryGroupChangeListener(this);
        entry_group.addEntryChangeListener(this);
        this.refreshMenu();
    }

    public EntryGroupMenu(JFrame frame, EntryGroup entry_group) {
        this(frame, entry_group, "Entries");
    }

    public void entryGroupChanged(EntryGroupChangeEvent event) {
        switch (event.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.refreshMenu();
            }
        }
    }

    public void entryChanged(EntryChangeEvent event) {
        if (event.getType() == 3) {
            this.refreshMenu();
        }
    }

    private void refreshMenu() {
        this.removeAll();
        if (this.entry_group == null || this.entry_group.size() == 0) {
            this.add(new JMenuItem("(No Entries Currently)"));
            return;
        }
        JMenu set_entry_name_menu = new JMenu("Set Name Of Entry");
        this.add(set_entry_name_menu);
        JMenu set_default_menu = new JMenu("Set Default Entry");
        JMenu delete_entry_menu = new JMenu("Remove An Entry");
        this.addSeparator();
        this.add(set_default_menu);
        this.add(delete_entry_menu);
        JMenuItem delete_active_entries_menu = new JMenuItem("Remove Active Entries");
        delete_active_entries_menu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EntryGroupMenu.this.deleteActiveEntries();
            }
        });
        this.add(delete_active_entries_menu);
        JMenuItem deactivate_all = new JMenuItem("Deactivate All Entries");
        deactivate_all.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                for (int i = 0; i < EntryGroupMenu.this.entry_group.size(); ++i) {
                    Entry this_entry = EntryGroupMenu.this.entry_group.elementAt(i);
                    EntryGroupMenu.this.entry_group.setIsActive(this_entry, false);
                }
            }
        });
        this.add(deactivate_all);
        this.entry_components = new Vector();
        this.addSeparator();
        for (int i = 0; i < this.entry_group.size(); ++i) {
            final Entry this_entry = this.entry_group.elementAt(i);
            String entry_name = this_entry.getName();
            if (entry_name == null) {
                entry_name = "no name";
            }
            JMenuItem set_entry_name_item = new JMenuItem(entry_name);
            set_entry_name_item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    EntryGroupMenu.this.setEntryName(this_entry);
                }
            });
            set_entry_name_menu.add(set_entry_name_item);
            JMenuItem delete_entry_item = new JMenuItem(entry_name);
            delete_entry_item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (this_entry.hasUnsavedChanges()) {
                        String message = this_entry.getName() != null ? "there are unsaved changes in " + this_entry.getName() + " - really remove?" : "there are unsaved changes in entry #" + EntryGroupMenu.this.entry_group.indexOf(this_entry) + " - really remove?";
                        YesNoDialog yes_no_dialog = new YesNoDialog(EntryGroupMenu.this.frame, message);
                        if (!yes_no_dialog.getResult()) {
                            return;
                        }
                    }
                    EntryGroupMenu.this.entry_group.remove(this_entry);
                }
            });
            delete_entry_menu.add(delete_entry_item);
            JMenuItem set_default_entry_item = new JMenuItem(entry_name);
            set_default_entry_item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    EntryGroupMenu.this.entry_group.setDefaultEntry(this_entry);
                }
            });
            set_default_menu.add(set_default_entry_item);
            this.add(this.entry_group.elementAt(i));
        }
    }

    private void add(Entry entry) {
        String entry_name = entry.getName();
        if (entry_name == null) {
            entry_name = "no name";
        }
        if (this.entry_group.getDefaultEntry() == entry) {
            entry_name = entry_name + "  (default entry)";
        }
        JCheckBoxMenuItem new_component = new JCheckBoxMenuItem(entry_name, this.entry_group.isActive(entry));
        new_component.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                int button_index = EntryGroupMenu.this.entry_components.indexOf(event.getSource());
                if (event.getStateChange() == 1) {
                    EntryGroupMenu.this.entry_group.setIsActive(button_index, true);
                } else {
                    EntryGroupMenu.this.entry_group.setIsActive(button_index, false);
                }
            }
        });
        this.entry_components.addElement(new_component);
        this.add(new_component);
    }

    private void setEntryName(final Entry entry) {
        TextRequester text_requester = new TextRequester("New name for the entry?", 18, "");
        text_requester.addTextRequesterListener(new TextRequesterListener(){

            public void actionPerformed(TextRequesterEvent event) {
                if (event.getType() == 2) {
                    return;
                }
                String requester_text = event.getRequesterText().trim();
                if (requester_text.length() > 0 && !entry.setName(requester_text)) {
                    new MessageDialog(EntryGroupMenu.this.frame, "could not set the name of the default entry");
                }
            }
        });
        text_requester.show();
    }

    private void deleteActiveEntries() {
        YesNoDialog dialog;
        Options.getOptions();
        if (Options.isNoddyMode() && !(dialog = new YesNoDialog(this.frame, "Are you sure you want to remove the active entries?")).getResult()) {
            return;
        }
        for (int i = this.entry_group.size() - 1; i >= 0; --i) {
            String message;
            YesNoDialog yes_no_dialog;
            Entry this_entry = this.entry_group.elementAt(i);
            if (this_entry.hasUnsavedChanges() && !(yes_no_dialog = new YesNoDialog(this.frame, message = this_entry.getName() != null ? "there are unsaved changes in " + this_entry.getName() + " - really remove?" : "there are unsaved changes in entry #" + (i + 1) + " - really remove?")).getResult() || !this.entry_group.isActive(this_entry)) continue;
            this.entry_group.remove(this_entry);
        }
    }
}

