/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryChangeListener;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeatureChangeListener;
import uk.ac.sanger.artemis.components.SequenceViewer;

public class FeatureAminoAcidViewer
implements EntryChangeListener,
FeatureChangeListener {
    private Feature feature = null;
    private SequenceViewer sequence_viewer;
    private Entry entry;
    private final boolean include_numbers;

    public FeatureAminoAcidViewer(Feature feature, boolean include_numbers) {
        this.feature = feature;
        this.entry = feature.getEntry();
        this.include_numbers = include_numbers;
        this.sequence_viewer = new SequenceViewer("Feature base viewer for feature:" + this.getFeature().getIDString(), include_numbers);
        this.redisplay();
        this.getFeature().getEntry().addEntryChangeListener(this);
        this.getFeature().addFeatureChangeListener(this);
        this.sequence_viewer.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent event) {
                FeatureAminoAcidViewer.this.stopListening();
            }
        });
    }

    private void stopListening() {
        this.getEntry().removeEntryChangeListener(this);
        this.getFeature().removeFeatureChangeListener(this);
    }

    public void entryChanged(EntryChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                if (event.getFeature() != this.getFeature()) break;
                this.stopListening();
                this.sequence_viewer.dispose();
                break;
            }
        }
    }

    public void featureChanged(FeatureChangeEvent event) {
        this.redisplay();
    }

    private void redisplay() {
        String small_note = this.getFeature().getNote();
        if (small_note == null) {
            small_note = this.getFeature().getIDString();
        } else if (small_note.length() > 50) {
            small_note = small_note.substring(0, 50);
        }
        String comment = ">" + small_note + "   - " + this.getFeature().getFirstBase() + ": " + this.getFeature().getLastBase() + "  MW: " + this.getFeature().getMolecularWeight();
        String sequence = this.getFeature().getTranslation().toString().toUpperCase();
        this.sequence_viewer.setSequence(comment, sequence);
    }

    private Feature getFeature() {
        return this.feature;
    }

    private Entry getEntry() {
        return this.entry;
    }
}

