/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.QualifierChoice;
import uk.ac.sanger.artemis.components.QualifierTextArea;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierInfo;
import uk.ac.sanger.artemis.io.QualifierParseException;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.util.ReadOnlyException;

public class QualifierEditor
extends JFrame {
    private QualifierTextArea qualifier_text_area;
    private JButton add_button = new JButton("Add");
    private JButton replace_button = new JButton("Replace");
    private JButton close_button = new JButton("Close");
    private FlowLayout flow_layout = new FlowLayout(1, 25, 5);
    private JPanel button_panel = new JPanel(this.flow_layout);
    private FeatureVector features = new FeatureVector();
    private EntryGroup entry_group;

    public QualifierEditor(FeatureVector features, EntryGroup entry_group) {
        super(QualifierEditor.getFrameTitle(features));
        this.features = features;
        this.entry_group = entry_group;
        Font font = Options.getOptions().getFont();
        Feature first_feature = features.elementAt(0);
        final EntryInformation entry_information = first_feature.getEntry().getEntryInformation();
        this.setFont(font);
        final QualifierChoice qualifier_choice = new QualifierChoice(entry_information, first_feature.getKey(), null);
        JPanel outer_qualifier_choice_panel = new JPanel();
        JPanel qualifier_choice_panel = new JPanel();
        outer_qualifier_choice_panel.setLayout(new BorderLayout());
        outer_qualifier_choice_panel.add((Component)qualifier_choice_panel, "West");
        JButton qualifier_button = new JButton("Insert qualifier:");
        qualifier_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String qualifier_name = (String)qualifier_choice.getSelectedItem();
                QualifierInfo qualifier_info = entry_information.getQualifierInfo(qualifier_name);
                if (qualifier_info == null) {
                    new MessageDialog(QualifierEditor.this, "internal error: no qualifier info for " + qualifier_name);
                } else {
                    QualifierEditor.this.qualifier_text_area.append("/" + qualifier_name);
                    switch (qualifier_info.getType()) {
                        case 1: {
                            QualifierEditor.this.qualifier_text_area.append("=\"\"");
                            break;
                        }
                        case 3: 
                        case 4: {
                            break;
                        }
                        default: {
                            QualifierEditor.this.qualifier_text_area.append("=");
                        }
                    }
                    QualifierEditor.this.qualifier_text_area.append("\n");
                }
            }
        });
        qualifier_choice_panel.add(qualifier_button);
        qualifier_choice_panel.add(qualifier_choice);
        this.getContentPane().add((Component)outer_qualifier_choice_panel, "North");
        this.qualifier_text_area = new QualifierTextArea();
        this.add_button.setFont(this.getFont());
        this.replace_button.setFont(this.getFont());
        this.close_button.setFont(this.getFont());
        this.add_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QualifierEditor.this.addOrReplace(false);
            }
        });
        this.replace_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QualifierEditor.this.addOrReplace(true);
            }
        });
        this.close_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QualifierEditor.this.dispose();
            }
        });
        this.button_panel.setFont(this.getFont());
        this.button_panel.add(this.replace_button);
        this.button_panel.add(this.add_button);
        this.button_panel.add(this.close_button);
        this.getContentPane().add((Component)this.qualifier_text_area, "Center");
        this.getContentPane().add((Component)this.button_panel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                QualifierEditor.this.dispose();
            }
        });
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(new Point((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrReplace(boolean replace) {
        try {
            Feature this_feature;
            this.entry_group.getActionController().startAction();
            Vector<QualifierVector> qualifier_vector_vector = new Vector<QualifierVector>();
            for (int i = 0; i < this.features.size(); ++i) {
                this_feature = this.features.elementAt(i);
                Entry this_feature_entry = this_feature.getEntry();
                if (this_feature_entry == null) {
                    qualifier_vector_vector.addElement(null);
                    continue;
                }
                EntryInformation entry_information = this_feature_entry.getEntryInformation();
                try {
                    QualifierVector qualifiers = this.qualifier_text_area.getParsedQualifiers(entry_information);
                    qualifier_vector_vector.addElement(qualifiers);
                    continue;
                }
                catch (QualifierParseException e) {
                    new MessageDialog(this, "error while parsing: " + e.getMessage());
                    this.entry_group.getActionController().endAction();
                    return;
                }
            }
            if (qualifier_vector_vector.size() != this.features.size()) {
                throw new Error("Internal error in QualifierEditor.add() - mismatched array sizes");
            }
            for (int feature_index = 0; feature_index < this.features.size(); ++feature_index) {
                this_feature = this.features.elementAt(feature_index);
                if (qualifier_vector_vector.elementAt(feature_index) == null) continue;
                QualifierVector qualifier_vector = (QualifierVector)qualifier_vector_vector.elementAt(feature_index);
                for (int qualifier_index = 0; qualifier_index < qualifier_vector.size(); ++qualifier_index) {
                    Qualifier this_qualifier = qualifier_vector.elementAt(qualifier_index);
                    if (replace) {
                        try {
                            this_feature.setQualifier(this_qualifier);
                        }
                        catch (EntryInformationException e) {
                            new MessageDialog(this, "failed to add qualifiers to: " + this_feature.getIDString() + ": " + e.getMessage());
                        }
                        catch (ReadOnlyException e) {
                            new MessageDialog(this, "failed to add qualifiers to read-only feature: " + this_feature.getIDString() + ": " + e.getMessage());
                        }
                        continue;
                    }
                    try {
                        this_feature.addQualifierValues(this_qualifier);
                        continue;
                    }
                    catch (EntryInformationException e) {
                        new MessageDialog(this, "failed to add qualifiers to: " + this_feature.getIDString() + ": " + e.getMessage());
                        continue;
                    }
                    catch (ReadOnlyException e) {
                        new MessageDialog(this, "failed to add qualifiers to read-only feature: " + this_feature.getIDString() + ": " + e.getMessage());
                    }
                }
            }
        }
        finally {
            this.entry_group.getActionController().endAction();
        }
    }

    private static String getFrameTitle(FeatureVector features) {
        boolean etc_flag = false;
        StringBuffer buffer = new StringBuffer();
        int MAX_LENGTH = 80;
        for (int i = 0; i < features.size(); ++i) {
            Feature this_feature = features.elementAt(i);
            String feature_name = this_feature.getIDString();
            if (feature_name == null) {
                etc_flag = true;
                continue;
            }
            if (buffer.length() + feature_name.length() < 80) {
                if (buffer.length() == 0) {
                    buffer.append("Add or replace qualifiers of: ");
                    buffer.append(feature_name);
                    continue;
                }
                buffer.append(", ").append(feature_name);
                continue;
            }
            etc_flag = true;
            break;
        }
        if (buffer.length() == 0) {
            buffer.append("Add or replace qualifiers");
        } else if (etc_flag) {
            buffer.append(", ...");
        }
        return buffer.toString();
    }
}

