/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Color;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JTextArea;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.PublicDBStreamFeature;
import uk.ac.sanger.artemis.io.QualifierParseException;
import uk.ac.sanger.artemis.io.QualifierVector;

public class QualifierTextArea
extends JTextArea {
    public QualifierTextArea() {
        super(Options.getOptions().getPropertyTruthValue("alicat_mode") || Options.getOptions().getPropertyTruthValue("val_mode") ? 40 : 18, 81);
        this.setLineWrap(true);
        this.setBackground(Color.white);
        try {
            this.setDragEnabled(true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public QualifierVector getParsedQualifiers(EntryInformation entry_information) throws QualifierParseException {
        String qualifier_string = this.getText();
        return QualifierTextArea.getQualifiersFromString(qualifier_string, entry_information);
    }

    private static QualifierVector getQualifiersFromString(String qual_string, EntryInformation entry_information) throws QualifierParseException {
        try {
            StringReader string_reader = new StringReader(qual_string);
            QualifierVector embl_qualifiers = PublicDBStreamFeature.readQualifiers(string_reader, entry_information);
            string_reader.close();
            return embl_qualifiers;
        }
        catch (IOException exception) {
            throw new QualifierParseException(exception.getMessage());
        }
    }
}

