/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.EntryGroupChangeEvent;
import uk.ac.sanger.artemis.EntryGroupChangeListener;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureEnumeration;
import uk.ac.sanger.artemis.FeatureFromVectorPredicate;
import uk.ac.sanger.artemis.FeatureKeyPredicate;
import uk.ac.sanger.artemis.FeatureKeyQualifierPredicate;
import uk.ac.sanger.artemis.FeaturePatternPredicate;
import uk.ac.sanger.artemis.FeaturePredicate;
import uk.ac.sanger.artemis.FeaturePredicateConjunction;
import uk.ac.sanger.artemis.FeaturePredicateVector;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.components.BasePlotGroup;
import uk.ac.sanger.artemis.components.FeatureListFrame;
import uk.ac.sanger.artemis.components.KeyChoice;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.QualifierChoice;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.util.StringVector;

public class Selector
extends JFrame
implements EntryGroupChangeListener {
    private JCheckBox by_key_button;
    private JCheckBox by_qualifier_button;
    private JCheckBox by_motif_button;
    private JCheckBox less_than_bases_button;
    private JCheckBox greater_than_bases_button;
    private JCheckBox less_than_exons_button;
    private JCheckBox greater_than_exons_button;
    private JCheckBox ignore_case_checkbox;
    private JCheckBox match_any_word_checkbox;
    private JCheckBox forward_strand_checkbox;
    private JCheckBox reverse_strand_checkbox;
    private KeyChoice key_selector;
    private QualifierChoice qualifier_selector;
    private JTextField qualifier_text;
    private JTextField motif_text;
    private JTextField less_than_bases_text;
    private JTextField greater_than_bases_text;
    private JTextField less_than_exons_text;
    private JTextField greater_than_exons_text;
    final JCheckBox partial_match_checkbox;
    final EntryGroup entry_group;
    private final Selection selection;

    public Selector(final Selection selection, final GotoEventSource goto_event_source, final EntryGroup entry_group, final BasePlotGroup base_plot_group) {
        super("Artemis Feature Selector");
        this.selection = selection;
        this.entry_group = entry_group;
        Font default_font = Options.getOptions().getFont();
        this.setFont(default_font);
        GridBagLayout gridbag = new GridBagLayout();
        this.getContentPane().setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.weighty = 0.0;
        c.gridwidth = 0;
        JLabel top_label = new JLabel("Select by:");
        gridbag.setConstraints(top_label, c);
        this.getContentPane().add(top_label);
        this.by_key_button = new JCheckBox("Key: ", false);
        JPanel by_key_panel = new JPanel();
        by_key_panel.setLayout(new FlowLayout(0));
        by_key_panel.add(this.by_key_button);
        c.gridwidth = 2;
        gridbag.setConstraints(by_key_panel, c);
        this.getContentPane().add(by_key_panel);
        EntryInformation default_entry_information = Options.getArtemisEntryInformation();
        this.key_selector = new KeyChoice(default_entry_information);
        c.gridwidth = 0;
        gridbag.setConstraints(this.key_selector, c);
        this.getContentPane().add(this.key_selector);
        this.key_selector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent _) {
                Selector.this.by_key_button.setSelected(true);
            }
        });
        this.by_key_button.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (!Selector.this.by_key_button.isSelected()) {
                    Selector.this.by_qualifier_button.setSelected(false);
                }
            }
        });
        this.by_qualifier_button = new JCheckBox("Qualifier: ", false);
        JPanel by_qualifier_panel = new JPanel();
        by_qualifier_panel.setLayout(new FlowLayout(0));
        by_qualifier_panel.add(this.by_qualifier_button);
        c.gridwidth = 2;
        gridbag.setConstraints(by_qualifier_panel, c);
        this.getContentPane().add(by_qualifier_panel);
        this.qualifier_selector = new QualifierChoice(default_entry_information, this.key_selector.getSelectedItem(), null);
        c.gridwidth = 0;
        gridbag.setConstraints(this.qualifier_selector, c);
        this.getContentPane().add(this.qualifier_selector);
        this.qualifier_selector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent _) {
                Selector.this.by_qualifier_button.setSelected(true);
                Selector.this.by_key_button.setSelected(true);
            }
        });
        this.key_selector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent _) {
                Selector.this.qualifier_selector.setKey(Selector.this.key_selector.getSelectedItem());
            }
        });
        this.by_qualifier_button.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (Selector.this.by_qualifier_button.isSelected() && !Selector.this.by_key_button.isSelected()) {
                    Selector.this.by_key_button.setSelected(true);
                }
            }
        });
        JLabel qualifier_text_label = new JLabel("   Containing this text: ");
        c.gridwidth = 2;
        gridbag.setConstraints(qualifier_text_label, c);
        this.getContentPane().add(qualifier_text_label);
        this.qualifier_text = new JTextField("", 18);
        c.gridwidth = 0;
        gridbag.setConstraints(this.qualifier_text, c);
        this.getContentPane().add(this.qualifier_text);
        this.ignore_case_checkbox = new JCheckBox("Ignore Case", true);
        JPanel ignore_case_panel = new JPanel();
        ignore_case_panel.setLayout(new FlowLayout(0));
        ignore_case_panel.add(this.ignore_case_checkbox);
        c.gridwidth = 2;
        gridbag.setConstraints(ignore_case_panel, c);
        this.getContentPane().add(ignore_case_panel);
        this.partial_match_checkbox = new JCheckBox("Allow Partial Match", true);
        JPanel partial_match_panel = new JPanel();
        partial_match_panel.setLayout(new FlowLayout(0));
        partial_match_panel.add(this.partial_match_checkbox);
        c.gridwidth = 0;
        gridbag.setConstraints(partial_match_panel, c);
        this.getContentPane().add(partial_match_panel);
        this.match_any_word_checkbox = new JCheckBox("Match Any Word", false);
        JPanel match_any_word_panel = new JPanel();
        match_any_word_panel.setLayout(new FlowLayout(0));
        match_any_word_panel.add(this.match_any_word_checkbox);
        c.gridwidth = 0;
        gridbag.setConstraints(match_any_word_panel, c);
        this.getContentPane().add(match_any_word_panel);
        JLabel blank_label = new JLabel("");
        gridbag.setConstraints(blank_label, c);
        this.getContentPane().add(blank_label);
        JLabel and_label = new JLabel("And:");
        gridbag.setConstraints(and_label, c);
        this.getContentPane().add(and_label);
        this.less_than_bases_button = new JCheckBox("Up to: ", false);
        JPanel less_than_bases_panel = new JPanel();
        less_than_bases_panel.setLayout(new FlowLayout(0));
        less_than_bases_panel.add(this.less_than_bases_button);
        c.gridwidth = 3;
        gridbag.setConstraints(less_than_bases_panel, c);
        this.getContentPane().add(less_than_bases_panel);
        this.less_than_bases_text = new JTextField("", 18);
        gridbag.setConstraints(this.less_than_bases_text, c);
        this.getContentPane().add(this.less_than_bases_text);
        JLabel less_than_bases_label = new JLabel(" bases long");
        c.gridwidth = 0;
        gridbag.setConstraints(less_than_bases_label, c);
        this.getContentPane().add(less_than_bases_label);
        JLabel blank_label2 = new JLabel("");
        gridbag.setConstraints(blank_label2, c);
        this.getContentPane().add(blank_label2);
        JLabel and_label2 = new JLabel("And:");
        gridbag.setConstraints(and_label2, c);
        this.getContentPane().add(and_label2);
        this.greater_than_bases_button = new JCheckBox("At least: ", false);
        JPanel greater_than_bases_panel = new JPanel();
        greater_than_bases_panel.setLayout(new FlowLayout(0));
        greater_than_bases_panel.add(this.greater_than_bases_button);
        c.gridwidth = 2;
        gridbag.setConstraints(greater_than_bases_panel, c);
        this.getContentPane().add(greater_than_bases_panel);
        this.greater_than_bases_text = new JTextField("", 18);
        gridbag.setConstraints(this.greater_than_bases_text, c);
        this.getContentPane().add(this.greater_than_bases_text);
        JLabel greater_than_bases_label = new JLabel(" bases long");
        c.gridwidth = 0;
        gridbag.setConstraints(greater_than_bases_label, c);
        this.getContentPane().add(greater_than_bases_label);
        JLabel blank_label3 = new JLabel("");
        gridbag.setConstraints(blank_label3, c);
        this.getContentPane().add(blank_label3);
        JLabel and_label3 = new JLabel("And:");
        gridbag.setConstraints(and_label3, c);
        this.getContentPane().add(and_label3);
        this.less_than_exons_button = new JCheckBox("Up to: ", false);
        JPanel less_than_exons_panel = new JPanel();
        less_than_exons_panel.setLayout(new FlowLayout(0));
        less_than_exons_panel.add(this.less_than_exons_button);
        c.gridwidth = 3;
        gridbag.setConstraints(less_than_exons_panel, c);
        this.getContentPane().add(less_than_exons_panel);
        this.less_than_exons_text = new JTextField("", 18);
        gridbag.setConstraints(this.less_than_exons_text, c);
        this.getContentPane().add(this.less_than_exons_text);
        JLabel less_than_exons_label = new JLabel(" exons long");
        c.gridwidth = 0;
        gridbag.setConstraints(less_than_exons_label, c);
        this.getContentPane().add(less_than_exons_label);
        JLabel blank_label4 = new JLabel("");
        gridbag.setConstraints(blank_label4, c);
        this.getContentPane().add(blank_label4);
        JLabel and_label4 = new JLabel("And:");
        gridbag.setConstraints(and_label4, c);
        this.getContentPane().add(and_label4);
        this.greater_than_exons_button = new JCheckBox("At least: ", false);
        JPanel greater_than_exons_panel = new JPanel();
        greater_than_exons_panel.setLayout(new FlowLayout(0));
        greater_than_exons_panel.add(this.greater_than_exons_button);
        c.gridwidth = 2;
        gridbag.setConstraints(greater_than_exons_panel, c);
        this.getContentPane().add(greater_than_exons_panel);
        this.greater_than_exons_text = new JTextField("", 18);
        gridbag.setConstraints(this.greater_than_exons_text, c);
        this.getContentPane().add(this.greater_than_exons_text);
        JLabel greater_than_exons_label = new JLabel(" exons long");
        c.gridwidth = 0;
        gridbag.setConstraints(greater_than_exons_label, c);
        this.getContentPane().add(greater_than_exons_label);
        JLabel blank_label5 = new JLabel("");
        gridbag.setConstraints(blank_label5, c);
        this.getContentPane().add(blank_label5);
        JLabel and_label5 = new JLabel("And by:");
        gridbag.setConstraints(and_label5, c);
        this.getContentPane().add(and_label5);
        this.by_motif_button = new JCheckBox("Amino acid motif: ", false);
        JPanel by_motif_panel = new JPanel();
        by_motif_panel.setLayout(new FlowLayout(0));
        by_motif_panel.add(this.by_motif_button);
        c.gridwidth = 2;
        gridbag.setConstraints(by_motif_panel, c);
        this.getContentPane().add(by_motif_panel);
        this.motif_text = new JTextField("", 18);
        c.gridwidth = 0;
        gridbag.setConstraints(this.motif_text, c);
        this.getContentPane().add(this.motif_text);
        JLabel blank_label6 = new JLabel("");
        gridbag.setConstraints(blank_label6, c);
        this.getContentPane().add(blank_label6);
        JPanel strand_panel = new JPanel();
        strand_panel.setLayout(new FlowLayout(0));
        this.forward_strand_checkbox = new JCheckBox("Forward Strand Features", true);
        strand_panel.add(this.forward_strand_checkbox);
        this.forward_strand_checkbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent _) {
                if (!Selector.this.forward_strand_checkbox.isSelected() && !Selector.this.reverse_strand_checkbox.isSelected()) {
                    Selector.this.reverse_strand_checkbox.setSelected(true);
                }
            }
        });
        this.reverse_strand_checkbox = new JCheckBox("Reverse Strand Features", true);
        strand_panel.add(this.reverse_strand_checkbox);
        this.reverse_strand_checkbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent _) {
                if (!Selector.this.reverse_strand_checkbox.isSelected() && !Selector.this.forward_strand_checkbox.isSelected()) {
                    Selector.this.forward_strand_checkbox.setSelected(true);
                }
            }
        });
        c.gridwidth = 0;
        gridbag.setConstraints(strand_panel, c);
        this.getContentPane().add(strand_panel);
        JButton select_button = new JButton("Select");
        select_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                selection.set(Selector.this.getSelected());
            }
        });
        JButton view_button = new JButton("View");
        view_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeatureFromVectorPredicate predicate = new FeatureFromVectorPredicate(Selector.this.getSelected());
                String title = "All features";
                if (Selector.this.by_key_button.isSelected()) {
                    title = title + " with key \"" + Selector.this.key_selector.getSelectedItem() + "\"";
                }
                if (Selector.this.by_qualifier_button.isSelected()) {
                    title = Selector.this.qualifier_text.getText().trim().length() > 0 ? title + " with qualifier \"" + Selector.this.qualifier_selector.getSelectedItem() + "\" containing text \"" + Selector.this.qualifier_text.getText() + "\"" : title + " with qualifier \"" + Selector.this.qualifier_selector.getSelectedItem() + "\"";
                }
                if (Selector.this.forward_strand_checkbox.isSelected() && !Selector.this.reverse_strand_checkbox.isSelected()) {
                    title = title + " on the forward strand";
                }
                if (!Selector.this.forward_strand_checkbox.isSelected() && Selector.this.reverse_strand_checkbox.isSelected()) {
                    title = title + " on the reverse strand";
                }
                if (Selector.this.by_motif_button.isSelected()) {
                    title = title + " with motif: " + Selector.this.motif_text.getText().trim().toUpperCase();
                }
                if (Selector.this.less_than_bases_button.isSelected()) {
                    title = title + " at most " + Selector.this.less_than_bases_text.getText().trim() + " bases long";
                }
                if (Selector.this.greater_than_bases_button.isSelected()) {
                    title = title + " at least " + Selector.this.greater_than_bases_text.getText().trim() + " bases long";
                }
                if (Selector.this.less_than_exons_button.isSelected()) {
                    title = title + " at most " + Selector.this.less_than_exons_text.getText().trim() + " exons long";
                }
                if (Selector.this.greater_than_exons_button.isSelected()) {
                    title = title + " at least " + Selector.this.greater_than_exons_text.getText().trim() + " exons long";
                }
                FilteredEntryGroup filtered_entry_group = new FilteredEntryGroup(entry_group, predicate, title);
                FeatureListFrame feature_list_frame = new FeatureListFrame(title, Selector.this.getSelection(), goto_event_source, filtered_entry_group, base_plot_group);
                ((Component)feature_list_frame).setVisible(true);
            }
        });
        JButton close_button = new JButton("Close");
        close_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Selector.this.dispose();
            }
        });
        FlowLayout flow_layout = new FlowLayout(1, 15, 5);
        JPanel bottom_button_panel = new JPanel(flow_layout);
        bottom_button_panel.add(select_button);
        bottom_button_panel.add(view_button);
        bottom_button_panel.add(close_button);
        gridbag.setConstraints(bottom_button_panel, c);
        this.getContentPane().add(bottom_button_panel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                Selector.this.getEntryGroup().removeEntryGroupChangeListener(Selector.this);
                Selector.this.dispose();
            }
        });
        this.getEntryGroup().addEntryGroupChangeListener(this);
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(new Point((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2));
        ((Component)this).setVisible(true);
    }

    public void entryGroupChanged(EntryGroupChangeEvent event) {
        switch (event.getType()) {
            case 6: {
                this.getEntryGroup().removeEntryGroupChangeListener(this);
                this.dispose();
            }
        }
    }

    private FeatureVector getSelected() {
        FeaturePatternPredicate motif_predicate;
        FeaturePredicate key_and_qualifier_predicate;
        if (this.by_key_button.isSelected()) {
            String search_text;
            if (this.by_qualifier_button.isSelected()) {
                search_text = this.qualifier_text.getText().trim();
                String qualifier_name = (String)this.qualifier_selector.getSelectedItem();
                if (search_text.length() == 0) {
                    key_and_qualifier_predicate = new FeatureKeyQualifierPredicate(this.key_selector.getSelectedItem(), qualifier_name, true);
                } else if (this.match_any_word_checkbox.isSelected()) {
                    FeaturePredicateVector temp_predicates = new FeaturePredicateVector();
                    StringVector words = StringVector.getStrings(search_text, " \t\n");
                    for (int i = 0; i < words.size(); ++i) {
                        String this_word = words.elementAt(i);
                        FeatureKeyQualifierPredicate new_predicate = new FeatureKeyQualifierPredicate(this.key_selector.getSelectedItem(), qualifier_name, this_word, this.partial_match_checkbox.isSelected(), this.ignore_case_checkbox.isSelected());
                        temp_predicates.add(new_predicate);
                    }
                    key_and_qualifier_predicate = new FeaturePredicateConjunction(temp_predicates, 0);
                } else {
                    key_and_qualifier_predicate = new FeatureKeyQualifierPredicate(this.key_selector.getSelectedItem(), qualifier_name, search_text, this.partial_match_checkbox.isSelected(), this.ignore_case_checkbox.isSelected());
                }
            } else {
                search_text = this.qualifier_text.getText().trim();
                if (search_text.length() == 0) {
                    key_and_qualifier_predicate = new FeatureKeyPredicate(this.key_selector.getSelectedItem());
                } else if (this.match_any_word_checkbox.isSelected()) {
                    FeaturePredicateVector temp_predicates = new FeaturePredicateVector();
                    StringVector words = StringVector.getStrings(search_text, " \t\n");
                    for (int i = 0; i < words.size(); ++i) {
                        String this_word = words.elementAt(i);
                        FeatureKeyQualifierPredicate new_predicate = new FeatureKeyQualifierPredicate(this.key_selector.getSelectedItem(), null, this_word, this.partial_match_checkbox.isSelected(), this.ignore_case_checkbox.isSelected());
                        temp_predicates.add(new_predicate);
                    }
                    key_and_qualifier_predicate = new FeaturePredicateConjunction(temp_predicates, 0);
                } else {
                    key_and_qualifier_predicate = new FeatureKeyQualifierPredicate(this.key_selector.getSelectedItem(), null, search_text, this.partial_match_checkbox.isSelected(), this.ignore_case_checkbox.isSelected());
                }
            }
        } else {
            key_and_qualifier_predicate = null;
        }
        if (this.by_motif_button.isSelected()) {
            AminoAcidSequence amino_acid_sequence = new AminoAcidSequence(this.motif_text.getText().trim());
            motif_predicate = new FeaturePatternPredicate(amino_acid_sequence);
        } else {
            motif_predicate = null;
        }
        FeaturePredicate less_than_bases_predicate = null;
        if (this.less_than_bases_button.isSelected() && this.less_than_bases_text.getText().trim().length() > 0) {
            try {
                final int less_than_bases_int = Integer.valueOf(this.less_than_bases_text.getText().trim());
                less_than_bases_predicate = new FeaturePredicate(){

                    public boolean testPredicate(Feature feature) {
                        return feature.getBaseCount() <= less_than_bases_int;
                    }
                };
            }
            catch (NumberFormatException e) {
                new MessageDialog(this, "warning this is not a number: " + this.less_than_bases_text.getText());
                less_than_bases_predicate = null;
            }
        } else {
            less_than_bases_predicate = null;
        }
        FeaturePredicate greater_than_bases_predicate = null;
        if (this.greater_than_bases_button.isSelected() && this.greater_than_bases_text.getText().trim().length() > 0) {
            try {
                final int greater_than_bases_int = Integer.valueOf(this.greater_than_bases_text.getText().trim());
                greater_than_bases_predicate = new FeaturePredicate(){

                    public boolean testPredicate(Feature feature) {
                        return feature.getBaseCount() >= greater_than_bases_int;
                    }
                };
            }
            catch (NumberFormatException e) {
                new MessageDialog(this, "warning this is not a number: " + this.greater_than_bases_text.getText());
                greater_than_bases_predicate = null;
            }
        } else {
            greater_than_bases_predicate = null;
        }
        FeaturePredicate less_than_exons_predicate = null;
        if (this.less_than_exons_button.isSelected() && this.less_than_exons_text.getText().trim().length() > 0) {
            try {
                final int less_than_exons_int = Integer.valueOf(this.less_than_exons_text.getText().trim());
                less_than_exons_predicate = new FeaturePredicate(){

                    public boolean testPredicate(Feature feature) {
                        return feature.getSegments().size() <= less_than_exons_int;
                    }
                };
            }
            catch (NumberFormatException e) {
                new MessageDialog(this, "warning this is not a number: " + this.less_than_exons_text.getText());
                less_than_exons_predicate = null;
            }
        } else {
            less_than_exons_predicate = null;
        }
        FeaturePredicate greater_than_exons_predicate = null;
        if (this.greater_than_exons_button.isSelected() && this.greater_than_exons_text.getText().trim().length() > 0) {
            try {
                final int greater_than_exons_int = Integer.valueOf(this.greater_than_exons_text.getText().trim());
                greater_than_exons_predicate = new FeaturePredicate(){

                    public boolean testPredicate(Feature feature) {
                        return feature.getSegments().size() >= greater_than_exons_int;
                    }
                };
            }
            catch (NumberFormatException e) {
                new MessageDialog(this, "warning this is not a number: " + this.greater_than_exons_text.getText());
                greater_than_exons_predicate = null;
            }
        } else {
            greater_than_exons_predicate = null;
        }
        FeaturePredicate predicate = null;
        predicate = !this.by_key_button.isSelected() && !this.by_motif_button.isSelected() ? new FeaturePredicate(){

            public boolean testPredicate(Feature feature) {
                return true;
            }
        } : (motif_predicate != null && key_and_qualifier_predicate != null ? new FeaturePredicateConjunction(key_and_qualifier_predicate, motif_predicate, 1) : (motif_predicate != null ? motif_predicate : key_and_qualifier_predicate));
        if (less_than_bases_predicate != null) {
            predicate = new FeaturePredicateConjunction(predicate, less_than_bases_predicate, 1);
        }
        if (greater_than_bases_predicate != null) {
            predicate = new FeaturePredicateConjunction(predicate, greater_than_bases_predicate, 1);
        }
        if (less_than_exons_predicate != null) {
            predicate = new FeaturePredicateConjunction(predicate, less_than_exons_predicate, 1);
        }
        if (greater_than_exons_predicate != null) {
            predicate = new FeaturePredicateConjunction(predicate, greater_than_exons_predicate, 1);
        }
        FeatureEnumeration test_enumerator = this.entry_group.features();
        FeatureVector return_features = new FeatureVector();
        while (test_enumerator.hasMoreFeatures()) {
            Feature this_feature = test_enumerator.nextFeature();
            if (!predicate.testPredicate(this_feature)) continue;
            if (this_feature.isForwardFeature()) {
                if (!this.forward_strand_checkbox.isSelected()) continue;
                return_features.add(this_feature);
                continue;
            }
            if (!this.reverse_strand_checkbox.isSelected()) continue;
            return_features.add(this_feature);
        }
        return return_features;
    }

    private Selection getSelection() {
        return this.selection;
    }

    private EntryGroup getEntryGroup() {
        return this.entry_group;
    }
}

