/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import nsdb.EmblSeq;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.util.ReadOnlyException;

public class CorbaSequence
implements Sequence {
    private String sequence;
    private EmblSeq corba_handle;

    public CorbaSequence(EmblSeq corba_handle) {
        this.corba_handle = corba_handle;
        this.sequence = corba_handle.getSeq();
    }

    public String toString() {
        return this.sequence;
    }

    public String getSubSequence(int start, int end) {
        if (start == 1 && end == this.length()) {
            return this.sequence;
        }
        if (end < start) {
            return "";
        }
        return this.sequence.substring(start - 1, end);
    }

    public void setFromString(String new_sequence) throws ReadOnlyException {
        throw new ReadOnlyException();
    }

    public int length() {
        return this.sequence.length();
    }

    public int getCCount() {
        return this.corba_handle.getCountC();
    }

    public int getGCount() {
        return this.corba_handle.getCountG();
    }

    public int getACount() {
        return this.corba_handle.getCountA();
    }

    public int getTCount() {
        return this.corba_handle.getCountT();
    }

    public int getOtherCount() {
        return this.length() - (this.getCCount() + this.getACount() + this.getTCount() + this.getGCount());
    }
}

