/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import uk.ac.sanger.artemis.io.ComparableFeature;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.FeatureEnumeration;
import uk.ac.sanger.artemis.io.FeatureVector;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;

public class FeatureTree
extends TreeSet {
    private final int BUCKET_COUNT = 10;
    private final int BUCKET_MULTIPLIER = 4;
    private final Vector rbtree_buckets = new Vector(10);
    private Comparator comparator;

    public FeatureTree(Comparator comparator) {
        super(comparator);
        this.comparator = comparator;
    }

    public synchronized boolean add(Object element) {
        Feature this_feature = (Feature)element;
        this.getBucket(this_feature).add(this_feature);
        return super.add(element);
    }

    public synchronized boolean remove(Object element) {
        Feature this_feature = (Feature)element;
        this.getBucket(this_feature).remove(this_feature);
        return super.remove(element);
    }

    private static SortedSet findByBase(TreeSet tree, final int base) {
        ComparableFeature test_feature = new ComparableFeature(){
            private final Key dummy_key = new Key("_dummy_key_");

            public void set(Key k, Location l, QualifierVector qv) {
            }

            public void setKey(Key _) {
            }

            public void setLocation(Location _) {
            }

            public void setQualifiers(QualifierVector _) {
            }

            public void setQualifier(Qualifier _) {
            }

            public void removeQualifierByName(String _) {
            }

            public Key getKey() {
                return this.dummy_key;
            }

            public Location getLocation() {
                return null;
            }

            public QualifierVector getQualifiers() {
                return null;
            }

            public Qualifier getQualifierByName(String _) {
                return null;
            }

            public int getFirstBase() {
                return base;
            }

            public int getLastBase() {
                return base;
            }

            public long getNumericID() {
                return -1L;
            }

            public Entry getEntry() {
                return null;
            }

            public Feature copy() {
                return null;
            }

            public void setUserData(Object _) {
            }

            public Object getUserData() {
                return null;
            }

            public boolean isReadOnly() {
                return false;
            }
        };
        return tree.tailSet(test_feature);
    }

    private void getFeaturesInRange(TreeSet tree, FeatureVector features_in_range, Range range, int max_feature_length) {
        SortedSet tail_set = FeatureTree.findByBase(tree, range.getStart() - max_feature_length);
        Iterator tail_set_iterator = tail_set.iterator();
        while (tail_set_iterator.hasNext()) {
            Feature this_feature = (Feature)tail_set_iterator.next();
            if (this_feature.getFirstBase() > range.getEnd()) {
                return;
            }
            if (!this_feature.getLocation().getTotalRange().overlaps(range)) continue;
            features_in_range.add(this_feature);
        }
    }

    public synchronized FeatureVector getFeaturesInRange(Range range) {
        FeatureVector return_features = new FeatureVector(100);
        for (int i = 0; i < this.rbtree_buckets.size() && this.rbtree_buckets.elementAt(i) != null; ++i) {
            this.getFeaturesInRange((TreeSet)this.rbtree_buckets.elementAt(i), return_features, range, (int)Math.pow(4.0, i + 1));
        }
        return return_features;
    }

    public FeatureEnumeration features() {
        return new FeatureEnumerator();
    }

    public Feature getNextFeature(Feature this_feature) {
        SortedSet<Feature> tail_set = this.tailSet(this_feature);
        Iterator tail_set_iterator = tail_set.iterator();
        tail_set_iterator.next();
        if (tail_set_iterator.hasNext()) {
            return (Feature)tail_set_iterator.next();
        }
        return null;
    }

    private TreeSet getBucket(Feature feature) {
        int feature_length = feature.getLocation().getTotalRange().getCount();
        int feature_bucket = feature_length <= 4 ? 0 : (int)(Math.log((double)feature_length + 0.5) / Math.log(4.0));
        while (this.rbtree_buckets.size() <= feature_bucket) {
            this.rbtree_buckets.addElement(new TreeSet(this.comparator));
        }
        return (TreeSet)this.rbtree_buckets.elementAt(feature_bucket);
    }

    public class FeatureEnumerator
    implements FeatureEnumeration {
        private Iterator iterator;

        public FeatureEnumerator() {
            this.iterator = FeatureTree.this.iterator();
        }

        public boolean hasMoreFeatures() {
            return this.iterator.hasNext();
        }

        public Feature nextFeature() throws NoSuchElementException {
            return (Feature)this.iterator.next();
        }
    }
}

