/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import uk.ac.sanger.artemis.io.ComparableFeature;
import uk.ac.sanger.artemis.io.DocumentEntry;
import uk.ac.sanger.artemis.io.DocumentFeature;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.io.ReadFormatException;
import uk.ac.sanger.artemis.io.SimpleDocumentFeature;
import uk.ac.sanger.artemis.io.StreamFeature;
import uk.ac.sanger.artemis.util.LinePushBackReader;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;
import uk.ac.sanger.artemis.util.StringVector;

public class GFFStreamFeature
extends SimpleDocumentFeature
implements DocumentFeature,
StreamFeature,
ComparableFeature {
    private DocumentEntry entry;
    StringVector gff_lines = null;

    public GFFStreamFeature(Key key, Location location, QualifierVector qualifiers) {
        super(null);
        try {
            this.setKey(key);
            this.setLocation(location);
            this.setQualifiers(qualifiers);
            if (this.getQualifierByName("score") == null) {
                this.setQualifier(new Qualifier("score", "."));
            }
            if (this.getQualifierByName("gff_source") == null) {
                this.setQualifier(new Qualifier("gff_source", "artemis"));
            }
            if (this.getQualifierByName("gff_seqname") == null) {
                this.setQualifier(new Qualifier("gff_seqname", "."));
            }
        }
        catch (EntryInformationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (ReadOnlyException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public GFFStreamFeature(Feature feature) {
        this(feature.getKey(), feature.getLocation(), feature.getQualifiers());
        if (feature instanceof GFFStreamFeature) {
            this.gff_lines = new StringVector(((GFFStreamFeature)feature).gff_lines);
        }
    }

    public Feature copy() {
        GFFStreamFeature return_value = new GFFStreamFeature(this);
        return return_value;
    }

    private GFFStreamFeature(String line) throws ReadFormatException {
        super(null);
        int end_base;
        int start_base;
        StringVector line_bits = StringVector.getStrings(line, "\t", true);
        if (line_bits.size() < 8) {
            throw new ReadFormatException("invalid GFF line: 8 fields needed (got " + line_bits.size() + " fields) from: " + line);
        }
        String start_base_string = line_bits.elementAt(3).trim();
        String end_base_string = line_bits.elementAt(4).trim();
        try {
            start_base = Integer.parseInt(start_base_string);
        }
        catch (NumberFormatException e) {
            throw new ReadFormatException("Could not understand the start base of a GFF feature: " + start_base_string);
        }
        try {
            end_base = Integer.parseInt(end_base_string);
        }
        catch (NumberFormatException e) {
            throw new ReadFormatException("Could not understand the end base of a GFF feature: " + end_base_string);
        }
        try {
            boolean complement_flag;
            if (line_bits.elementAt(6).equals("+")) {
                complement_flag = false;
            } else if (line_bits.elementAt(6).equals("-")) {
                complement_flag = true;
            } else {
                complement_flag = false;
                String note_string = "this feature is unstranded";
                this.setQualifier(new Qualifier("note", "this feature is unstranded"));
            }
            if (line_bits.size() == 9) {
                String rest_of_line = line_bits.elementAt(8);
                Hashtable attributes = this.parseAttributes(rest_of_line);
                Enumeration attribute_enum = attributes.keys();
                while (attribute_enum.hasMoreElements()) {
                    String name = (String)attribute_enum.nextElement();
                    StringVector values = (StringVector)attributes.get(name);
                    if (values.size() == 0) {
                        this.setQualifier(new Qualifier(name));
                        continue;
                    }
                    this.setQualifier(new Qualifier(name, values));
                }
            }
            Qualifier gff_seqname = new Qualifier("gff_seqname", line_bits.elementAt(0));
            this.setQualifier(gff_seqname);
            Key key = new Key(line_bits.elementAt(2));
            this.setKey(key);
            Qualifier source_qualifier = new Qualifier("gff_source", line_bits.elementAt(1));
            this.setQualifier(source_qualifier);
            Qualifier score_qualifier = new Qualifier("score", line_bits.elementAt(5));
            this.setQualifier(score_qualifier);
            String frame = line_bits.elementAt(7);
            frame = frame.equals("0") ? "1" : (frame.equals("1") ? "2" : (frame.equals("2") ? "3" : "."));
            if (!frame.equals("1") && !frame.equals(".")) {
                Qualifier codon_start_qualifier = new Qualifier("codon_start", frame);
                this.setQualifier(codon_start_qualifier);
            }
            if (start_base > end_base) {
                throw new ReadFormatException("start position is greater than end position: " + start_base + " > " + end_base);
            }
            if (start_base < 0) {
                throw new ReadFormatException("start position must be positive: " + start_base);
            }
            Range location_range = new Range(start_base, end_base);
            RangeVector location_ranges = new RangeVector(location_range);
            this.setLocation(new Location(location_ranges, complement_flag));
        }
        catch (ReadOnlyException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (EntryInformationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        this.gff_lines = new StringVector(line);
    }

    private String joinStringVector(StringVector string_vector) {
        StringBuffer return_buffer = new StringBuffer();
        for (int i = 0; i < string_vector.size(); ++i) {
            if (i != 0) {
                return_buffer.append("    ");
            }
            return_buffer.append(string_vector.elementAt(i));
        }
        return return_buffer.toString();
    }

    protected static GFFStreamFeature readFromStream(LinePushBackReader stream) throws IOException, InvalidRelationException {
        String line = stream.readLine();
        if (line == null) {
            return null;
        }
        try {
            GFFStreamFeature new_feature = new GFFStreamFeature(line);
            return new_feature;
        }
        catch (ReadFormatException exception) {
            String new_error_string = exception.getMessage();
            throw new ReadFormatException(new_error_string, stream.getLineNumber());
        }
    }

    public void setFromStream(EntryInformation entry_information, LinePushBackReader in_stream) throws IOException, InvalidRelationException, ReadOnlyException {
        throw new ReadOnlyException();
    }

    public void writeToStream(Writer writer) throws IOException {
        if (this.gff_lines == null) {
            RangeVector ranges = this.getLocation().getRanges();
            for (int i = 0; i < ranges.size(); ++i) {
                Range this_range = ranges.elementAt(i);
                Qualifier seqname = this.getQualifierByName("gff_seqname");
                Qualifier source = this.getQualifierByName("gff_source");
                Qualifier score = this.getQualifierByName("score");
                Qualifier group = this.getQualifierByName("group");
                if (seqname == null) {
                    seqname = new Qualifier("gff_seqname", "");
                }
                if (source == null) {
                    source = new Qualifier("source", "");
                }
                if (score == null) {
                    score = new Qualifier("score", "");
                }
                if (group == null || group.getValues() == null || group.getValues().elementAt(0).equals("")) {
                    Qualifier gene = this.getQualifierByName("gene");
                    group = gene == null ? new Qualifier("group", "") : gene;
                }
                String frame = ".";
                Qualifier codon_start = this.getQualifierByName("codon_start");
                if (codon_start != null && i == 0) {
                    frame = codon_start.getValues().elementAt(0);
                    frame = frame.equals("1") ? "0" : (frame.equals("2") ? "1" : (frame.equals("3") ? "2" : "."));
                }
                String attribute_string = this.unParseAttributes();
                writer.write(seqname.getValues().elementAt(0) + "\t" + source.getValues().elementAt(0) + "\t" + this.getKey() + "\t" + this_range.getStart() + "\t" + this_range.getEnd() + "\t" + score.getValues().elementAt(0) + "\t" + (this.getLocation().isComplement() ? "-\t" : "+\t") + frame + "\t" + attribute_string + "\n");
            }
        } else {
            for (int i = 0; i < this.gff_lines.size(); ++i) {
                writer.write(this.gff_lines.elementAt(i) + "\n");
            }
        }
    }

    private String unParseAttributes() {
        StringBuffer buffer = new StringBuffer();
        QualifierVector qualifiers = this.getQualifiers();
        QualifierVector qualifiers_to_write = new QualifierVector();
        for (int i = 0; i < qualifiers.size(); ++i) {
            Qualifier this_qualifier = qualifiers.elementAt(i);
            String name = this_qualifier.getName();
            if (name.equals("codon_start") || name.equals("gff_source") || name.equals("gff_seqname") || name.equals("score")) continue;
            if (i != 0) {
                buffer.append(" ; ");
            }
            StringVector values = this_qualifier.getValues();
            buffer.append(name);
            if (values == null) continue;
            for (int value_index = 0; value_index < values.size(); ++value_index) {
                String this_value = values.elementAt(value_index);
                buffer.append(' ');
                try {
                    buffer.append(Integer.valueOf(this_value));
                    continue;
                }
                catch (NumberFormatException _) {
                    try {
                        buffer.append(Double.valueOf(this_value));
                        continue;
                    }
                    catch (NumberFormatException __) {
                        buffer.append('\"' + this_value + '\"');
                    }
                }
            }
        }
        return buffer.toString();
    }

    private Hashtable parseAttributes(String att_val_list) {
        Hashtable<String, StringVector> attributes = new Hashtable<String, StringVector>();
        StringTokenizer tokeniser = new StringTokenizer(att_val_list, ";", false);
        while (tokeniser.hasMoreTokens()) {
            String att_name;
            String this_token = tokeniser.nextToken().trim();
            int index_of_first_space = this_token.indexOf(" ");
            StringVector att_values = new StringVector();
            if (index_of_first_space == -1) {
                att_name = this_token;
            } else {
                att_name = this_token.substring(0, index_of_first_space);
                String rest_of_token = this_token.substring(index_of_first_space).trim();
                while (rest_of_token.length() > 0) {
                    String next_bit;
                    if (rest_of_token.startsWith("\"")) {
                        int quote_index = 0;
                        do {
                            ++quote_index;
                        } while ((quote_index = rest_of_token.indexOf("\"", quote_index)) > -1 && rest_of_token.charAt(quote_index - 1) == '\\');
                        if (quote_index < 0) {
                            Hashtable<String, StringVector> panic_attributes = new Hashtable<String, StringVector>();
                            StringVector notes = new StringVector();
                            notes.add(att_val_list);
                            panic_attributes.put("note", notes);
                            return panic_attributes;
                        }
                        next_bit = rest_of_token.substring(1, quote_index);
                        att_values.add(next_bit);
                        rest_of_token = rest_of_token.substring(quote_index + 1).trim();
                        continue;
                    }
                    int index_of_next_space = rest_of_token.indexOf(" ");
                    if (index_of_next_space == -1) {
                        att_values.add(rest_of_token);
                        rest_of_token = "";
                        continue;
                    }
                    next_bit = rest_of_token.substring(0, index_of_next_space);
                    att_values.add(next_bit);
                    rest_of_token = rest_of_token.substring(index_of_next_space).trim();
                }
            }
            if (attributes.get(att_name) != null) {
                ((StringVector)attributes.get(att_name)).add(att_values);
                continue;
            }
            attributes.put(att_name, att_values);
        }
        return attributes;
    }
}

