/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.io.IOException;
import java.io.Writer;
import uk.ac.sanger.artemis.io.ComparableFeature;
import uk.ac.sanger.artemis.io.DocumentEntry;
import uk.ac.sanger.artemis.io.DocumentFeature;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.LocationParseException;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.io.ReadFormatException;
import uk.ac.sanger.artemis.io.SimpleDocumentFeature;
import uk.ac.sanger.artemis.io.StreamFeature;
import uk.ac.sanger.artemis.util.LinePushBackReader;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;
import uk.ac.sanger.artemis.util.StringVector;

public class MSPcrunchStreamFeature
extends SimpleDocumentFeature
implements DocumentFeature,
StreamFeature,
ComparableFeature {
    private DocumentEntry entry;
    private String mspcrunch_line = null;

    public MSPcrunchStreamFeature(Key key, Location location, QualifierVector qualifiers) {
        super(null);
        try {
            this.setKey(key);
            this.setLocation(location);
            this.setQualifiers(qualifiers);
        }
        catch (EntryInformationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (ReadOnlyException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public MSPcrunchStreamFeature(Feature feature) {
        super(null);
        if (feature instanceof MSPcrunchStreamFeature) {
            this.mspcrunch_line = ((MSPcrunchStreamFeature)feature).mspcrunch_line;
        }
        try {
            this.setKey(feature.getKey());
            this.setLocation(feature.getLocation());
            this.setQualifiers(feature.getQualifiers());
        }
        catch (EntryInformationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (ReadOnlyException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public Feature copy() {
        MSPcrunchStreamFeature return_value = new MSPcrunchStreamFeature(this);
        return return_value;
    }

    /*
     * WARNING - void declaration
     */
    private MSPcrunchStreamFeature(String line) throws ReadFormatException {
        super(null);
        StringVector line_bits = StringVector.getStrings(line, " \t");
        if (line_bits.size() < 7) {
            throw new ReadFormatException("invalid MSPcrunch line (not enough fields): " + line);
        }
        try {
            void var6_10;
            String description;
            int i;
            StringBuffer desc_buffer;
            String subject_id;
            String subject_end;
            String subject_start;
            String query_id;
            void var5_9;
            boolean complement_flag;
            boolean crunch_x;
            int query_start = Integer.valueOf(line_bits.elementAt(2));
            int query_end = Integer.valueOf(line_bits.elementAt(3));
            if (line_bits.elementAt(1).equals("(+1)")) {
                crunch_x = true;
                complement_flag = false;
            } else if (line_bits.elementAt(1).equals("(-1)")) {
                crunch_x = true;
                complement_flag = true;
            } else if (line_bits.elementAt(1).charAt(0) == '.' || Character.isDigit(line_bits.elementAt(1).charAt(0))) {
                crunch_x = false;
                complement_flag = query_start > query_end;
            } else {
                String message = "invalid MSPcrunch line - column 3 should be a number, (-1) or (+1): " + line;
                throw new ReadFormatException(message);
            }
            if (query_start > query_end) {
                int tmp = query_end;
                query_end = query_start;
                query_start = tmp;
            }
            String score = line_bits.elementAt(0);
            String percent_id = var5_9 != false ? null : line_bits.elementAt(1);
            if (var5_9 != false) {
                query_id = "unknown";
                subject_start = line_bits.elementAt(4);
                subject_end = line_bits.elementAt(5);
                subject_id = line_bits.elementAt(6);
                desc_buffer = new StringBuffer();
                for (i = 7; i < line_bits.size(); ++i) {
                    desc_buffer.append(line_bits.elementAt(i));
                    if (i >= line_bits.size() - 1) continue;
                    desc_buffer.append(" ");
                }
                description = desc_buffer.toString();
            } else {
                query_id = line_bits.elementAt(4);
                subject_start = line_bits.elementAt(5);
                subject_end = line_bits.elementAt(6);
                subject_id = line_bits.elementAt(7);
                desc_buffer = new StringBuffer();
                for (i = 8; i < line_bits.size(); ++i) {
                    desc_buffer.append(line_bits.elementAt(i));
                    if (i >= line_bits.size() - 1) continue;
                    desc_buffer.append(" ");
                }
                description = desc_buffer.toString();
            }
            Qualifier blast_score_qualifier = new Qualifier("blast_score", score);
            Qualifier query_id_qualifier = new Qualifier("query_id", query_id);
            Qualifier subject_start_qualifier = new Qualifier("subject_start", subject_start);
            Qualifier subject_end_qualifier = new Qualifier("subject_end", subject_end);
            Qualifier subject_id_qualifier = new Qualifier("subject_id", subject_id);
            this.setQualifier(blast_score_qualifier);
            if (percent_id != null) {
                Qualifier score_qualifier = new Qualifier("score", percent_id);
                Qualifier percent_id_qualifier = new Qualifier("percent_id", percent_id);
                this.setQualifier(score_qualifier);
                this.setQualifier(percent_id_qualifier);
            }
            this.setQualifier(query_id_qualifier);
            this.setQualifier(subject_start_qualifier);
            this.setQualifier(subject_end_qualifier);
            this.setQualifier(subject_id_qualifier);
            Key key = var5_9 != false ? new Key("CRUNCH_X") : new Key("CRUNCH_D");
            this.setKey(key);
            StringVector note_values = new StringVector();
            note_values.add("hit to " + subject_id + " " + subject_start + ".." + subject_end + "  score: " + score + (percent_id == null ? "" : "  percent id: " + percent_id) + "  " + description);
            Qualifier note_qualifier = new Qualifier("note", note_values);
            this.setQualifier(note_qualifier);
            RangeVector ranges = new RangeVector(new Range(query_start, query_end));
            this.setLocation(new Location(ranges, (boolean)var6_10));
        }
        catch (ReadOnlyException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (EntryInformationException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        catch (LocationParseException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        this.mspcrunch_line = line;
    }

    protected static MSPcrunchStreamFeature readFromStream(LinePushBackReader stream) throws IOException, InvalidRelationException {
        String line = stream.readLine();
        if (line == null) {
            return null;
        }
        try {
            MSPcrunchStreamFeature new_feature = new MSPcrunchStreamFeature(line);
            return new_feature;
        }
        catch (ReadFormatException exception) {
            String new_error_string = exception.getMessage();
            throw new ReadFormatException(new_error_string, stream.getLineNumber());
        }
    }

    public void setFromStream(EntryInformation entry_information, LinePushBackReader in_stream) throws IOException, InvalidRelationException, ReadOnlyException {
        throw new ReadOnlyException();
    }

    public void writeToStream(Writer writer) throws IOException {
        writer.write(this.mspcrunch_line + "\n");
    }
}

