/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.io.BufferedReader;
import java.io.IOException;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierInfo;
import uk.ac.sanger.artemis.io.QualifierInfoException;
import uk.ac.sanger.artemis.io.QualifierParseException;
import uk.ac.sanger.artemis.util.StringVector;

public class StreamQualifier {
    private static final StringBuffer read_name_string_buffer = new StringBuffer(20);
    private static char[] read_value_buffer = new char[5000];
    private static int buffer_index = 0;

    public static Qualifier makeStreamQualifier(String name, String value, EntryInformation entry_information) throws QualifierParseException {
        if (!entry_information.isValidQualifier(name)) {
            QualifierInfo new_qualifier_info = value.startsWith("\"") ? new QualifierInfo(name, 1, null, null, false) : new QualifierInfo(name, 2, null, null, false);
            try {
                entry_information.addQualifierInfo(new_qualifier_info);
            }
            catch (QualifierInfoException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
        }
        return new Qualifier(name, StreamQualifier.unquote(value));
    }

    public static String toString(QualifierInfo qualifier_info, Qualifier qualifier) {
        StringVector values = qualifier.getValues();
        if (values == null) {
            return '/' + qualifier.getName();
        }
        StringBuffer buffer = new StringBuffer(50);
        for (int i = 0; i < values.size(); ++i) {
            buffer.append('/');
            buffer.append(qualifier.getName());
            if (values.elementAt(i) == null) continue;
            buffer.append('=');
            buffer.append(StreamQualifier.quotedValue(qualifier_info, qualifier.getName(), values.elementAt(i)));
        }
        return buffer.toString();
    }

    public static StringVector toStringVector(QualifierInfo qualifier_info, Qualifier qualifier) {
        StringVector values = qualifier.getValues();
        StringVector return_vector = new StringVector();
        if (values == null) {
            return_vector.add('/' + qualifier.getName());
        } else {
            for (int i = 0; i < values.size(); ++i) {
                StringBuffer buffer = new StringBuffer(50);
                buffer.append('/');
                buffer.append(qualifier.getName());
                if (values.elementAt(i) != null) {
                    buffer.append('=');
                    buffer.append(StreamQualifier.quotedValue(qualifier_info, qualifier.getName(), values.elementAt(i)));
                }
                return_vector.add(buffer.toString());
            }
        }
        return return_vector;
    }

    static String readName(BufferedReader buffered_reader) throws QualifierParseException, IOException {
        String return_string;
        int current_char;
        while ((current_char = buffered_reader.read()) != -1 && 0 != current_char) {
            if (32 == current_char || 10 == current_char || 9 == current_char) continue;
            if (47 == current_char) break;
            throw new QualifierParseException("failed to read a qualifier name from this string: " + (char)current_char + buffered_reader.readLine());
        }
        if (-1 == current_char || 0 == current_char) {
            return null;
        }
        buffered_reader.mark(1);
        read_name_string_buffer.setLength(0);
        while ((current_char = buffered_reader.read()) != -1) {
            if (Character.isLetter((char)current_char) || Character.isDigit((char)current_char) || 95 == current_char || 43 == current_char) {
                read_name_string_buffer.append((char)current_char);
                buffered_reader.mark(1);
                continue;
            }
            buffered_reader.reset();
            break;
        }
        if ((return_string = read_name_string_buffer.toString()).length() == 0) {
            throw new QualifierParseException("zero length qualifier name read from this string: " + buffered_reader.readLine());
        }
        return return_string;
    }

    private static void appendToValueBuffer(char new_char) {
        if (buffer_index >= read_value_buffer.length) {
            char[] temp_buffer = new char[read_value_buffer.length * 2];
            System.arraycopy(read_value_buffer, 0, temp_buffer, 0, read_value_buffer.length);
            read_value_buffer = temp_buffer;
        }
        StreamQualifier.read_value_buffer[StreamQualifier.buffer_index++] = new_char;
    }

    static synchronized String readValue(BufferedReader buffered_reader) throws QualifierParseException, IOException {
        char c;
        buffer_index = 0;
        buffered_reader.mark(1);
        int n = buffered_reader.read();
        if (-1 == n) {
            return "";
        }
        char final_char = '\u0000';
        char start_char = '\u0000';
        int bracket_count = 0;
        if (34 == n) {
            final_char = '\"';
        }
        if (91 == n) {
            final_char = ']';
            start_char = '[';
            ++bracket_count;
        }
        if (40 == n) {
            final_char = ')';
            start_char = '(';
            ++bracket_count;
        }
        if ('\u0000' == final_char) {
            buffered_reader.reset();
        } else {
            StreamQualifier.appendToValueBuffer((char)n);
        }
        buffered_reader.mark(1);
        while ((c = buffered_reader.read()) != '\uffffffff') {
            if (Character.isISOControl(c) && c != '\t') {
                c = ' ';
            }
            if (c != '\"') {
                if (c == start_char) {
                    ++bracket_count;
                } else if (c == final_char) {
                    --bracket_count;
                }
            }
            if (c == final_char && bracket_count == 0) {
                if (c == '\"') {
                    buffered_reader.mark(1);
                    int next_char = buffered_reader.read();
                    if (next_char == 34) {
                        StreamQualifier.appendToValueBuffer('\"');
                        StreamQualifier.appendToValueBuffer('\"');
                        continue;
                    }
                    if (next_char != -1) {
                        buffered_reader.reset();
                    }
                    StreamQualifier.appendToValueBuffer('\"');
                    break;
                }
                StreamQualifier.appendToValueBuffer(c);
                break;
            }
            if ('\u0000' == final_char && '/' == c) {
                buffered_reader.reset();
                break;
            }
            StreamQualifier.appendToValueBuffer(c);
            buffered_reader.mark(1);
        }
        if (bracket_count > 0) {
            throw new QualifierParseException("hit the end of line while looking for a \"" + final_char + "\"");
        }
        while (buffer_index > 0 && Character.isWhitespace(read_value_buffer[buffer_index - 1])) {
            --buffer_index;
        }
        return new String(read_value_buffer, 0, buffer_index);
    }

    private static String quotedValue(QualifierInfo qualifier_info, String name, String value) {
        if (qualifier_info != null && (qualifier_info.getType() == 1 || qualifier_info.getType() == 4)) {
            return '\"' + value + '\"';
        }
        if (value.indexOf(47) != -1) {
            return '\"' + value + '\"';
        }
        return value;
    }

    private static String unquote(String value) throws QualifierParseException {
        if (value.length() >= 2) {
            char first_char = value.charAt(0);
            char last_char = value.charAt(value.length() - 1);
            if (first_char == '\"' && last_char == '\"') {
                return value.substring(1, value.length() - 1);
            }
            if (first_char != '\"' && last_char != '\"') {
                return value;
            }
            throw new QualifierParseException("unbalanced quotes: " + value);
        }
        return value;
    }
}

