/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.io.IOException;
import java.io.Writer;
import uk.ac.sanger.artemis.io.LineGroup;
import uk.ac.sanger.artemis.io.Sequence;

public abstract class StreamSequence
extends LineGroup
implements Sequence {
    private String sequence;
    private int a_count = 0;
    private int c_count = 0;
    private int g_count = 0;
    private int t_count = 0;

    protected StreamSequence() {
        this.setFromString("");
    }

    public abstract StreamSequence copy();

    public abstract int getFormatType();

    public int getType() {
        return 2;
    }

    public String toString() {
        return this.sequence;
    }

    public String getSubSequence(int start, int end) {
        if (end < start) {
            return "";
        }
        if (start == 1 && end == this.length()) {
            return this.sequence;
        }
        return this.sequence.substring(start - 1, end);
    }

    public void setFromString(String new_sequence) {
        this.sequence = new_sequence;
        this.setCounts();
    }

    public abstract void writeToStream(Writer var1) throws IOException;

    public int length() {
        return this.sequence.length();
    }

    public int getCCount() {
        return this.c_count;
    }

    public int getGCount() {
        return this.g_count;
    }

    public int getACount() {
        return this.a_count;
    }

    public int getTCount() {
        return this.t_count;
    }

    public int getOtherCount() {
        return this.length() - (this.getCCount() + this.getACount() + this.getTCount() + this.getGCount());
    }

    private void setCounts() {
        this.g_count = 0;
        this.t_count = 0;
        this.c_count = 0;
        this.a_count = 0;
        int sequence_length = this.sequence.length();
        char[] sequence_chars = new char[sequence_length];
        this.sequence.getChars(0, sequence_length, sequence_chars, 0);
        block6: for (int i = 0; i < sequence_length; ++i) {
            switch (sequence_chars[i]) {
                case 'a': {
                    ++this.a_count;
                    continue block6;
                }
                case 'c': {
                    ++this.c_count;
                    continue block6;
                }
                case 'g': {
                    ++this.g_count;
                    continue block6;
                }
                case 't': {
                    ++this.t_count;
                    continue block6;
                }
            }
        }
    }
}

