/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.plot;

import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.plot.BaseAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class Codon12CorrelationAlgorithm
extends BaseAlgorithm {
    public static double[] correlation_score_factors_1 = new double[]{17.7, 21.1, 27.7, 33.6};
    public static double[] correlation_score_factors_2 = new double[]{27.1, 23.8, 31.0, 18.2};

    public Codon12CorrelationAlgorithm(Strand strand) {
        super(strand, Codon12CorrelationAlgorithm.makeName(strand), "correlation_score");
        this.setScalingFlag(true);
    }

    public void getValues(int start, int end, float[] values) {
        String sub_sequence;
        if (this.isRevCompDisplay()) {
            int new_end = this.getStrand().getBases().getComplementPosition(start);
            int new_start = this.getStrand().getBases().getComplementPosition(end);
            end = new_end;
            start = new_start;
        }
        if (this.getStrand().isForwardStrand()) {
            end -= (end - start + 1) % 3;
        } else {
            start += (end - start + 1) % 3;
        }
        try {
            sub_sequence = this.getStrand().getRawSubSequence(new Range(start, end));
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        char[] sub_sequence_raw = sub_sequence.toCharArray();
        float[] gc_counts = new float[3];
        int[][] positional_base_counts = new int[4][3];
        int sub_sequence_length = sub_sequence_raw.length;
        if (this.getStrand().isForwardStrand()) {
            for (int i = 0; i < sub_sequence_length; ++i) {
                int base_index = Bases.getIndexOfBase(sub_sequence_raw[i]);
                if (base_index >= 4) continue;
                int[] nArray = positional_base_counts[base_index];
                int n = i % 3;
                nArray[n] = nArray[n] + 1;
            }
        } else {
            String complement_string = Bases.complement(sub_sequence);
            char[] complement_sub_sequence_raw = complement_string.toCharArray();
            for (int i = 0; i < sub_sequence_length; ++i) {
                int base_index = Bases.getIndexOfBase(complement_sub_sequence_raw[i]);
                if (base_index >= 4) continue;
                int position_index = i % 3;
                int[] nArray = positional_base_counts[base_index];
                int n = position_index;
                nArray[n] = nArray[n] + 1;
            }
        }
        for (int frame = 0; frame < 3; ++frame) {
            double cor1_2_score = 3.0 * (1.0 * (double)positional_base_counts[0][frame] / (double)sub_sequence_length * correlation_score_factors_1[0] + 1.0 * (double)positional_base_counts[1][frame] / (double)sub_sequence_length * correlation_score_factors_1[1] + 1.0 * (double)positional_base_counts[2][frame] / (double)sub_sequence_length * correlation_score_factors_1[2] + 1.0 * (double)positional_base_counts[3][frame] / (double)sub_sequence_length * correlation_score_factors_1[3] + 1.0 * (double)positional_base_counts[0][(frame + 1) % 3] / (double)sub_sequence_length * correlation_score_factors_2[0] + 1.0 * (double)positional_base_counts[1][(frame + 1) % 3] / (double)sub_sequence_length * correlation_score_factors_2[1] + 1.0 * (double)positional_base_counts[2][(frame + 1) % 3] / (double)sub_sequence_length * correlation_score_factors_2[2] + 1.0 * (double)positional_base_counts[3][(frame + 1) % 3] / (double)sub_sequence_length * correlation_score_factors_2[3]) + 0.5;
            values[(start + frame) % 3] = (float)cor1_2_score;
        }
    }

    public int getValueCount() {
        return 3;
    }

    public Integer getDefaultWindowSize() {
        Integer super_window_size = super.getDefaultWindowSize();
        if (super_window_size != null) {
            return super_window_size;
        }
        return new Integer(240);
    }

    public Integer getDefaultMaxWindowSize() {
        Integer super_max_window_size = super.getDefaultMaxWindowSize();
        if (super_max_window_size != null) {
            return super_max_window_size;
        }
        return new Integer(600);
    }

    public Integer getDefaultMinWindowSize() {
        Integer super_min_window_size = super.getDefaultMinWindowSize();
        if (super_min_window_size != null) {
            return super_min_window_size;
        }
        return new Integer(48);
    }

    public Integer getDefaultStepSize(int window_size) {
        if (window_size > 8) {
            return new Integer(window_size / 8);
        }
        return null;
    }

    protected Float getMaximumInternal() {
        return new Float(100.0f);
    }

    protected Float getMinimumInternal() {
        return new Float(0.0f);
    }

    public Float getAverage() {
        return new Float(52.7);
    }

    private static String makeName(Strand strand) {
        if (strand.isForwardStrand()) {
            return "Correlation Scores";
        }
        return "Reverse Correlation Scores";
    }
}

