/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.plot;

import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.plot.BaseAlgorithm;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class GCSDWindowAlgorithm
extends BaseAlgorithm {
    float[] standard_deviations;

    public GCSDWindowAlgorithm(Strand strand) {
        super(strand, "GC Content (%) With A 2.5 SD Cutoff", "sd_gc_content");
        int max_window_size = this.getDefaultMaxWindowSize();
        this.standard_deviations = new float[max_window_size];
        for (int i = 0; i < max_window_size; ++i) {
            this.standard_deviations[i] = -1.0f;
        }
        this.setScalingFlag(false);
    }

    public void getValues(int start, int end, float[] values) {
        float gc_average;
        String sequence;
        float standard_deviation;
        int window_size = end - start + 1;
        if (window_size > this.getDefaultMaxWindowSize()) {
            standard_deviation = this.calculateSD(window_size);
        } else if (this.standard_deviations[window_size - 1] < 0.0f) {
            this.standard_deviations[window_size - 1] = standard_deviation = this.calculateSD(window_size);
        } else {
            standard_deviation = this.standard_deviations[window_size - 1];
        }
        try {
            sequence = this.getStrand().getSubSequence(new Range(start, end));
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        float gc_count = 0.0f;
        for (int i = 0; i < sequence.length(); ++i) {
            char this_char = sequence.charAt(i);
            if (this_char != 'g' && this_char != 'c') continue;
            gc_count += 1.0f;
        }
        float gc_content = gc_count / (float)sequence.length() * 100.0f;
        values[0] = (double)Math.abs(gc_content - (gc_average = this.getStrand().getBases().getAverageGCPercent())) < (double)standard_deviation * 2.5 ? gc_average : gc_content;
    }

    private float calculateSD(int window_size) {
        int sequence_length = this.getStrand().getBases().getLength();
        String bases = this.getStrand().getBases().toString();
        int window_count = sequence_length - window_size;
        double sum_so_far = 0.0;
        double gc_so_far = 0.0;
        double current_gc_count = 0.0;
        for (int i = -window_size; i < window_count; ++i) {
            char new_char;
            char previous_char;
            if (i > 0 && ((previous_char = bases.charAt(i - 1)) == 'g' || previous_char == 'c')) {
                current_gc_count -= 1.0;
            }
            if ((new_char = bases.charAt(i + window_size)) == 'g' || new_char == 'c') {
                current_gc_count += 1.0;
            }
            if (i < 0) continue;
            double this_value = current_gc_count / (double)window_size;
            sum_so_far += this_value * this_value;
            gc_so_far += this_value;
        }
        double gc_average = gc_so_far / (double)window_count;
        return (float)Math.sqrt(sum_so_far / (double)window_count - gc_average * gc_average) * 100.0f;
    }

    public int getValueCount() {
        return 1;
    }

    public Integer getDefaultWindowSize() {
        Integer super_window_size = super.getDefaultWindowSize();
        if (super_window_size != null) {
            return super_window_size;
        }
        return new Integer(1000);
    }

    public Integer getDefaultMaxWindowSize() {
        Integer super_max_window_size = super.getDefaultMaxWindowSize();
        if (super_max_window_size != null) {
            return super_max_window_size;
        }
        return new Integer(5000);
    }

    public Integer getDefaultMinWindowSize() {
        Integer super_min_window_size = super.getDefaultMinWindowSize();
        if (super_min_window_size != null) {
            return super_min_window_size;
        }
        return new Integer(100);
    }

    public Integer getDefaultStepSize(int window_size) {
        return new Integer(1);
    }

    public Float getAverage() {
        return new Float(this.getStrand().getBases().getAverageGCPercent());
    }

    protected Float getMaximumInternal() {
        return new Float(100.0f);
    }

    protected Float getMinimumInternal() {
        return new Float(0.0f);
    }
}

