/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.onehead;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dp.BackPointer;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.DPMatrix;
import org.biojava.bio.dp.DotState;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.MagicalState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.SimpleStatePath;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.StatePath;
import org.biojava.bio.dp.onehead.DPCursor;
import org.biojava.bio.dp.onehead.MatrixCursor;
import org.biojava.bio.dp.onehead.SingleDPMatrix;
import org.biojava.bio.dp.onehead.SmallCursor;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.DoubleAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SimpleGappedSymbolList;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class SingleDP
extends DP
implements Serializable {
    private final HashMap emissionsProb = new HashMap();
    private final HashMap emissionsOdds = new HashMap();
    private final HashMap emissionsNull = new HashMap();

    public SingleDP(MarkovModel model) throws IllegalSymbolException, IllegalTransitionException, BioException {
        super(model);
    }

    public void update() {
        super.update();
        if (this.emissionsProb != null) {
            this.emissionsProb.clear();
        }
        if (this.emissionsOdds != null) {
            this.emissionsOdds.clear();
        }
        if (this.emissionsNull != null) {
            this.emissionsNull.clear();
        }
    }

    public double[] getEmission(Symbol sym, ScoreType scoreType) throws IllegalSymbolException {
        HashMap emissions;
        if (scoreType == ScoreType.PROBABILITY) {
            emissions = this.emissionsProb;
        } else if (scoreType == ScoreType.ODDS) {
            emissions = this.emissionsOdds;
        } else if (scoreType == ScoreType.NULL_MODEL) {
            emissions = this.emissionsNull;
        } else {
            throw new BioError("Unknown ScoreType object: " + scoreType);
        }
        double[] em = (double[])emissions.get(sym);
        if (em == null) {
            int dsi = this.getDotStatesIndex();
            em = new double[dsi];
            State[] states = this.getStates();
            em[0] = sym == AlphabetManager.getGapSymbol() ? 0.0 : Double.NEGATIVE_INFINITY;
            int i = 1;
            while (i < dsi) {
                EmissionState es = (EmissionState)states[i];
                Distribution dis = es.getDistribution();
                em[i] = Math.log(scoreType.calculateScore(dis, sym));
                ++i;
            }
            emissions.put(sym, em);
        }
        return em;
    }

    public double forward(SymbolList[] seq, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        if (seq.length != 1) {
            throw new IllegalArgumentException("seq must be 1 long, not " + seq.length);
        }
        this.lockModel();
        SmallCursor dpCursor = new SmallCursor(this.getStates(), seq[0], seq[0].iterator());
        double score = this.forward(dpCursor, scoreType);
        this.unlockModel();
        return score;
    }

    public double backward(SymbolList[] seq, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        if (seq.length != 1) {
            throw new IllegalArgumentException("seq must be 1 long, not " + seq.length);
        }
        this.lockModel();
        SmallCursor dpCursor = new SmallCursor(this.getStates(), seq[0], new DP.ReverseIterator(seq[0]));
        double score = this.backward(dpCursor, scoreType);
        this.unlockModel();
        return score;
    }

    public DPMatrix forwardMatrix(SymbolList[] seq, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        if (seq.length != 1) {
            throw new IllegalArgumentException("seq must be 1 long, not " + seq.length);
        }
        this.lockModel();
        SingleDPMatrix matrix = new SingleDPMatrix(this, seq[0]);
        MatrixCursor dpCursor = new MatrixCursor(matrix, seq[0].iterator(), 1);
        matrix.setScore(this.forward(dpCursor, scoreType));
        this.unlockModel();
        return matrix;
    }

    public DPMatrix backwardMatrix(SymbolList[] seq, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        if (seq.length != 1) {
            throw new IllegalArgumentException("seq must be 1 long, not " + seq.length);
        }
        this.lockModel();
        SingleDPMatrix matrix = new SingleDPMatrix(this, seq[0]);
        MatrixCursor dpCursor = new MatrixCursor(matrix, new DP.ReverseIterator(seq[0]), -1);
        matrix.setScore(this.backward(dpCursor, scoreType));
        this.unlockModel();
        return matrix;
    }

    public DPMatrix forwardMatrix(SymbolList[] seq, DPMatrix matrix, ScoreType scoreType) throws IllegalArgumentException, IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        if (seq.length != 1) {
            throw new IllegalArgumentException("seq must be 1 long, not " + seq.length);
        }
        this.lockModel();
        SingleDPMatrix sm = (SingleDPMatrix)matrix;
        MatrixCursor dpCursor = new MatrixCursor(sm, seq[0].iterator(), 1);
        sm.setScore(this.forward(dpCursor, scoreType));
        this.unlockModel();
        return sm;
    }

    public DPMatrix backwardMatrix(SymbolList[] seq, DPMatrix matrix, ScoreType scoreType) throws IllegalArgumentException, IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        if (seq.length != 1) {
            throw new IllegalArgumentException("seq must be 1 long, not " + seq.length);
        }
        this.lockModel();
        SingleDPMatrix sm = (SingleDPMatrix)matrix;
        MatrixCursor dpCursor = new MatrixCursor(sm, new DP.ReverseIterator(seq[0]), -1);
        sm.setScore(this.backward(dpCursor, scoreType));
        this.unlockModel();
        return sm;
    }

    private double forward(DPCursor dpCursor, ScoreType scoreType) throws IllegalSymbolException {
        this.forward_initialize(dpCursor, scoreType);
        this.forward_recurse(dpCursor, scoreType);
        return this.forward_termination(dpCursor, scoreType);
    }

    private double backward(DPCursor dpCursor, ScoreType scoreType) throws IllegalSymbolException {
        this.backward_initialize(dpCursor, scoreType);
        this.backward_recurse(dpCursor, scoreType);
        return this.backward_termination(dpCursor, scoreType);
    }

    private void forward_initialize(DPCursor dpCursor, ScoreType scoreType) throws IllegalSymbolException {
        double[] v = dpCursor.currentCol();
        State[] states = this.getStates();
        int l = 0;
        while (l < this.getDotStatesIndex()) {
            v[l] = states[l] == this.getModel().magicalState() ? 0.0 : Double.NEGATIVE_INFINITY;
            ++l;
        }
        int[][] transitions = this.getForwardTransitions();
        double[][] transitionScore = this.getForwardTransitionScores(scoreType);
        double[] currentCol = dpCursor.currentCol();
        int l2 = this.getDotStatesIndex();
        while (l2 < states.length) {
            double score = 0.0;
            int[] tr = transitions[l2];
            double[] trs = transitionScore[l2];
            int ci = 0;
            while (ci < tr.length && (currentCol[tr[ci]] == Double.NEGATIVE_INFINITY || currentCol[tr[ci]] == Double.NaN || currentCol[tr[ci]] == Double.POSITIVE_INFINITY)) {
                ++ci;
            }
            double constant = ci < tr.length ? currentCol[tr[ci]] : 0.0;
            int kc = 0;
            while (kc < tr.length) {
                int k = tr[kc];
                if (currentCol[k] != Double.NEGATIVE_INFINITY && currentCol[k] != Double.NaN && currentCol[k] != Double.POSITIVE_INFINITY) {
                    double t = trs[kc];
                    score += Math.exp(t + (currentCol[k] - constant));
                }
                ++kc;
            }
            currentCol[l2] = Math.log(score) + constant;
            ++l2;
        }
    }

    private void backward_initialize(DPCursor dpCursor, ScoreType scoreType) throws IllegalSymbolException {
        double[] v = dpCursor.currentCol();
        State[] states = this.getStates();
        int l = 0;
        while (l < states.length) {
            v[l] = states[l] == this.getModel().magicalState() ? 0.0 : Double.NEGATIVE_INFINITY;
            ++l;
        }
    }

    private void forward_recurse(DPCursor dpCursor, ScoreType scoreType) throws IllegalSymbolException {
        State[] states = this.getStates();
        int stateCount = states.length;
        int[][] transitions = this.getForwardTransitions();
        double[][] transitionScore = this.getForwardTransitionScores(scoreType);
        while (dpCursor.canAdvance()) {
            dpCursor.advance();
            Symbol sym = dpCursor.currentRes();
            double[] emissions = this.getEmission(sym, scoreType);
            double[] currentCol = dpCursor.currentCol();
            double[] lastCol = dpCursor.lastCol();
            int l = 0;
            while (l < this.getDotStatesIndex()) {
                double weight = emissions[l];
                if (weight == Double.NEGATIVE_INFINITY) {
                    currentCol[l] = Double.NEGATIVE_INFINITY;
                } else {
                    double score = 0.0;
                    int[] tr = transitions[l];
                    double[] trs = transitionScore[l];
                    int ci = 0;
                    while (ci < tr.length && (lastCol[tr[ci]] == Double.NEGATIVE_INFINITY || lastCol[tr[ci]] == Double.NaN || lastCol[tr[ci]] == Double.POSITIVE_INFINITY)) {
                        ++ci;
                    }
                    double constant = ci < tr.length ? lastCol[tr[ci]] : 0.0;
                    int kc = 0;
                    while (kc < tr.length) {
                        int k = tr[kc];
                        if (lastCol[k] != Double.NEGATIVE_INFINITY) {
                            double t = trs[kc];
                            if (states[l] == this.getModel().magicalState()) {
                                // empty if block
                            }
                            score += Math.exp(t + (lastCol[k] - constant));
                        }
                        ++kc;
                    }
                    currentCol[l] = weight + Math.log(score) + constant;
                    if (states[l] == this.getModel().magicalState()) {
                        // empty if block
                    }
                }
                ++l;
            }
            int l2 = this.getDotStatesIndex();
            while (l2 < states.length) {
                double score = 0.0;
                int[] tr = transitions[l2];
                double[] trs = transitionScore[l2];
                int ci = 0;
                while (ci < tr.length && (currentCol[tr[ci]] == Double.NEGATIVE_INFINITY || currentCol[tr[ci]] == Double.NaN || currentCol[tr[ci]] == Double.POSITIVE_INFINITY)) {
                    ++ci;
                }
                double constant = ci < tr.length ? currentCol[tr[ci]] : 0.0;
                int kc = 0;
                while (kc < tr.length) {
                    int k = tr[kc];
                    if (currentCol[k] != Double.NEGATIVE_INFINITY && currentCol[k] != Double.NaN && currentCol[k] != Double.POSITIVE_INFINITY) {
                        double t = trs[kc];
                        score += Math.exp(t + (currentCol[k] - constant));
                    }
                    ++kc;
                }
                currentCol[l2] = Math.log(score) + constant;
                ++l2;
            }
        }
    }

    private void backward_recurse(DPCursor dpCursor, ScoreType scoreType) throws IllegalSymbolException {
        State[] states = this.getStates();
        int stateCount = states.length;
        int[][] transitions = this.getBackwardTransitions();
        double[][] transitionScore = this.getBackwardTransitionScores(scoreType);
        double[] prevScores = new double[this.getDotStatesIndex()];
        while (dpCursor.canAdvance()) {
            dpCursor.advance();
            Symbol sym = dpCursor.lastRes();
            double[] emissions = this.getEmission(sym, scoreType);
            double[] currentCol = dpCursor.currentCol();
            double[] lastCol = dpCursor.lastCol();
            int k = this.getDotStatesIndex() - 1;
            while (k >= 0) {
                prevScores[k] = emissions[k];
                --k;
            }
            int k2 = stateCount - 1;
            while (k2 >= 0) {
                int[] tr = transitions[k2];
                double[] trs = transitionScore[k2];
                double score = 0.0;
                int ci = 0;
                while (ci < tr.length && lastCol[tr[ci]] == Double.NEGATIVE_INFINITY) {
                    ++ci;
                }
                double constant = ci < tr.length ? lastCol[tr[ci]] : 0.0;
                int lc = tr.length - 1;
                while (lc >= 0) {
                    int l = tr[lc];
                    if (l < this.getDotStatesIndex()) {
                        double weight = prevScores[l];
                        if (lastCol[l] != Double.NEGATIVE_INFINITY && weight != Double.NEGATIVE_INFINITY) {
                            double t = trs[lc];
                            score += Math.exp(t + weight + (lastCol[l] - constant));
                        }
                    }
                    --lc;
                }
                int lc2 = tr.length - 1;
                while (lc2 >= 0) {
                    int l = tr[lc2];
                    if (l < this.getDotStatesIndex() || l <= k2) break;
                    if (currentCol[l] != Double.NEGATIVE_INFINITY) {
                        score += Math.exp(trs[lc2] + (currentCol[l] - constant));
                    }
                    --lc2;
                }
                currentCol[k2] = Math.log(score) + constant;
                --k2;
            }
        }
    }

    private double forward_termination(DPCursor dpCursor, ScoreType scoreType) throws IllegalSymbolException {
        double[] scores = dpCursor.currentCol();
        State[] states = this.getStates();
        int l = 0;
        while (states[l] != this.getModel().magicalState()) {
            ++l;
        }
        return scores[l];
    }

    private double backward_termination(DPCursor dpCursor, ScoreType scoreType) throws IllegalSymbolException {
        double[] scores = dpCursor.currentCol();
        State[] states = this.getStates();
        int l = 0;
        while (states[l] != this.getModel().magicalState()) {
            ++l;
        }
        return scores[l];
    }

    public StatePath viterbi(SymbolList[] symList, ScoreType scoreType) throws IllegalSymbolException {
        SymbolList r = symList[0];
        SmallCursor dpCursor = new SmallCursor(this.getStates(), r, r.iterator());
        return this.viterbi(dpCursor, scoreType);
    }

    private StatePath viterbi(DPCursor dpCursor, ScoreType scoreType) throws IllegalSymbolException {
        this.lockModel();
        int seqLength = dpCursor.length();
        State[] states = this.getStates();
        int[][] transitions = this.getForwardTransitions();
        double[][] transitionScore = this.getForwardTransitionScores(scoreType);
        int stateCount = states.length;
        BackPointer[] oldPointers = new BackPointer[stateCount];
        BackPointer[] newPointers = new BackPointer[stateCount];
        double[] vc = dpCursor.currentCol();
        double[] vl = dpCursor.lastCol();
        int l = 0;
        while (l < this.getDotStatesIndex()) {
            if (states[l] == this.getModel().magicalState()) {
                vl[l] = 0.0;
                vc[l] = 0.0;
                oldPointers[l] = newPointers[l] = new BackPointer(states[l]);
            } else {
                vl[l] = Double.NEGATIVE_INFINITY;
                vc[l] = Double.NEGATIVE_INFINITY;
            }
            ++l;
        }
        int l2 = this.getDotStatesIndex();
        while (l2 < stateCount) {
            int[] tr = transitions[l2];
            double[] trs = transitionScore[l2];
            double transProb = Double.NEGATIVE_INFINITY;
            double trans = Double.NEGATIVE_INFINITY;
            int prev = -1;
            int kc = 0;
            while (kc < tr.length) {
                double t = trs[kc];
                int k = tr[kc];
                double s = vc[k];
                double p = t + s;
                if (p > transProb) {
                    transProb = p;
                    prev = k;
                    trans = t;
                }
                ++kc;
            }
            if (prev != -1) {
                vc[l2] = vl[l2] = transProb;
                oldPointers[l2] = newPointers[l2] = new BackPointer(states[l2], newPointers[prev], trans);
            } else {
                vl[l2] = Double.NEGATIVE_INFINITY;
                vc[l2] = Double.NEGATIVE_INFINITY;
                newPointers[l2] = null;
                oldPointers[l2] = null;
            }
            ++l2;
        }
        while (dpCursor.canAdvance()) {
            dpCursor.advance();
            Symbol sym = dpCursor.currentRes();
            double[] emissions = this.getEmission(sym, scoreType);
            double[] currentCol = dpCursor.currentCol();
            double[] lastCol = dpCursor.lastCol();
            int l3 = 0;
            while (l3 < states.length) {
                double emission = l3 < this.getDotStatesIndex() ? emissions[l3] : 0.0;
                int[] tr = transitions[l3];
                double[] trs = transitionScore[l3];
                if (emission == Double.NEGATIVE_INFINITY) {
                    currentCol[l3] = Double.NEGATIVE_INFINITY;
                    newPointers[l3] = null;
                } else {
                    double transProb = Double.NEGATIVE_INFINITY;
                    double trans = Double.NEGATIVE_INFINITY;
                    int prev = -1;
                    int kc = 0;
                    while (kc < tr.length) {
                        int k = tr[kc];
                        double t = trs[kc];
                        double s = l3 < this.getDotStatesIndex() ? lastCol[k] : currentCol[k];
                        double p = t + s;
                        if (p > transProb) {
                            transProb = p;
                            prev = k;
                            trans = t;
                        }
                        ++kc;
                    }
                    if (prev != -1) {
                        currentCol[l3] = transProb + emission;
                        newPointers[l3] = new BackPointer(states[l3], l3 < this.getDotStatesIndex() ? oldPointers[prev] : newPointers[prev], trans + emission);
                    } else {
                        currentCol[l3] = Double.NEGATIVE_INFINITY;
                        newPointers[l3] = null;
                    }
                }
                ++l3;
            }
            BackPointer[] bp = newPointers;
            newPointers = oldPointers;
            oldPointers = bp;
        }
        BackPointer best = null;
        double bestScore = Double.NaN;
        l = 0;
        while (l < stateCount) {
            if (states[l] == this.getModel().magicalState()) {
                best = oldPointers[l].back;
                bestScore = dpCursor.currentCol()[l];
                break;
            }
            ++l;
        }
        int len = 0;
        BackPointer b2 = best;
        int dotC = 0;
        int emC = 0;
        while (b2.back != b2) {
            ++len;
            if (b2.state instanceof EmissionState) {
                ++emC;
            } else {
                ++dotC;
            }
            b2 = b2.back;
        }
        HashMap<SymbolList, SymbolList> aMap = new HashMap<SymbolList, SymbolList>();
        aMap.put(dpCursor.symList(), dpCursor.symList());
        SimpleAlignment ali = new SimpleAlignment(aMap);
        SimpleGappedSymbolList symView = new SimpleGappedSymbolList(ali);
        double[] scores = new double[len];
        ArrayList<State> stateList = new ArrayList<State>(len);
        int j = 0;
        while (j < len) {
            stateList.add(null);
            ++j;
        }
        b2 = best;
        int ri = dpCursor.symList().length() + 1;
        int lc = len;
        int gaps = 0;
        while (b2.back != b2) {
            --lc;
            if (b2.state instanceof MagicalState) {
                b2 = b2.back;
                continue;
            }
            stateList.set(lc, b2.state);
            if (b2.state instanceof DotState) {
                symView.addGapInSource(ri);
                ++gaps;
            } else {
                --ri;
            }
            scores[lc] = b2.score;
            b2 = b2.back;
        }
        this.unlockModel();
        return new SimpleStatePath(bestScore, symView, new SimpleSymbolList(this.getModel().stateAlphabet(), stateList), DoubleAlphabet.fromArray(scores));
    }
}

