/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.biojava.bio.gui.sequence.PairwiseRenderContext;
import org.biojava.bio.gui.sequence.PairwiseSequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.gui.sequence.SequenceViewerListener;
import org.biojava.bio.gui.sequence.SequenceViewerMotionListener;
import org.biojava.bio.gui.sequence.SequenceViewerMotionSupport;
import org.biojava.bio.gui.sequence.SequenceViewerSupport;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeAdapter;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;

public class PairwiseSequencePanel
extends JComponent
implements PairwiseRenderContext,
Changeable,
Serializable {
    public static final ChangeType RENDERER = new ChangeType("The renderer for this PairwiseSequencePanel has changed", "org.biojava.bio.gui.sequence.PairwiseSequencePanel", "RENDERER", SequenceRenderContext.LAYOUT);
    public static final ChangeType TRANSLATION = new ChangeType("The translation for this PairwiseSequencePanel has changed", "org.biojava.bio.gui.sequence.PairwiseSequencePanel", "TRANSLATION", SequenceRenderContext.REPAINT);
    private Sequence sequence;
    private int translation = 0;
    private int direction = 0;
    private Sequence secSequence;
    private int secTranslation = 0;
    private int secDirection;
    private double scale = 10.0;
    private PairwiseSequenceRenderer renderer;
    private RenderingHints hints;
    private SequenceRenderContext.Border leadingBorder;
    private SequenceRenderContext.Border trailingBorder;
    private PropertyChangeListener propertyListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent pce) {
            PairwiseSequencePanel.this.repaint();
        }
    };
    private transient ChangeSupport changeSupport = null;
    private ChangeListener repaintListener = new ChangeAdapter(){

        public void postChange(ChangeEvent ce) {
            PairwiseSequencePanel.this.repaint();
        }
    };
    private ChangeListener layoutListener = new ChangeAdapter(){

        public void postChange(ChangeEvent ce) {
            PairwiseSequencePanel.this.revalidate();
        }
    };
    private SequenceViewerSupport svSupport = new SequenceViewerSupport();
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent me) {
            if (!PairwiseSequencePanel.this.isActive()) {
                return;
            }
            Insets insets = PairwiseSequencePanel.this.getInsets();
            me.translatePoint(-insets.left, -insets.top);
            SequenceViewerEvent sve = PairwiseSequencePanel.this.renderer.processMouseEvent(PairwiseSequencePanel.this, me, new ArrayList());
            me.translatePoint(insets.left, insets.top);
            PairwiseSequencePanel.this.svSupport.fireMouseClicked(sve);
        }

        public void mousePressed(MouseEvent me) {
            if (!PairwiseSequencePanel.this.isActive()) {
                return;
            }
            Insets insets = PairwiseSequencePanel.this.getInsets();
            me.translatePoint(-insets.left, -insets.top);
            SequenceViewerEvent sve = PairwiseSequencePanel.this.renderer.processMouseEvent(PairwiseSequencePanel.this, me, new ArrayList());
            me.translatePoint(insets.left, insets.top);
            PairwiseSequencePanel.this.svSupport.fireMousePressed(sve);
        }

        public void mouseReleased(MouseEvent me) {
            if (!PairwiseSequencePanel.this.isActive()) {
                return;
            }
            Insets insets = PairwiseSequencePanel.this.getInsets();
            me.translatePoint(-insets.left, -insets.top);
            SequenceViewerEvent sve = PairwiseSequencePanel.this.renderer.processMouseEvent(PairwiseSequencePanel.this, me, new ArrayList());
            me.translatePoint(insets.left, insets.top);
            PairwiseSequencePanel.this.svSupport.fireMouseReleased(sve);
        }
    };
    private SequenceViewerMotionSupport svmSupport = new SequenceViewerMotionSupport();
    private MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        public void mouseDragged(MouseEvent me) {
            if (!PairwiseSequencePanel.this.isActive()) {
                return;
            }
            Insets insets = PairwiseSequencePanel.this.getInsets();
            me.translatePoint(-insets.left, -insets.top);
            SequenceViewerEvent sve = PairwiseSequencePanel.this.renderer.processMouseEvent(PairwiseSequencePanel.this, me, new ArrayList());
            me.translatePoint(insets.left, insets.top);
            PairwiseSequencePanel.this.svmSupport.fireMouseDragged(sve);
        }

        public void mouseMoved(MouseEvent me) {
            if (!PairwiseSequencePanel.this.isActive()) {
                return;
            }
            Insets insets = PairwiseSequencePanel.this.getInsets();
            me.translatePoint(-insets.left, -insets.top);
            SequenceViewerEvent sve = PairwiseSequencePanel.this.renderer.processMouseEvent(PairwiseSequencePanel.this, me, new ArrayList());
            me.translatePoint(insets.left, insets.top);
            PairwiseSequencePanel.this.svmSupport.fireMouseMoved(sve);
        }
    };
    static /* synthetic */ Class class$org$biojava$utils$Changeable;

    public PairwiseSequencePanel() {
        this.leadingBorder = new SequenceRenderContext.Border();
        this.trailingBorder = new SequenceRenderContext.Border();
        this.leadingBorder.setSize(0.0);
        this.trailingBorder.setSize(0.0);
        this.hints = new RenderingHints(null);
        this.addPropertyChangeListener(this.propertyListener);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseMotionListener);
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        Sequence prevSequence = sequence;
        if (prevSequence != null) {
            prevSequence.removeChangeListener(this.layoutListener);
        }
        this.sequence = sequence;
        if (sequence != null) {
            sequence.addChangeListener(this.layoutListener);
        }
        this.firePropertyChange("sequence", prevSequence, sequence);
        this.resizeAndValidate();
    }

    public Sequence getSecondarySequence() {
        return this.secSequence;
    }

    public void setSecondarySequence(Sequence sequence) {
        Sequence prevSecSequence = this.secSequence;
        if (prevSecSequence != null) {
            prevSecSequence.removeChangeListener(this.layoutListener);
        }
        this.secSequence = sequence;
        if (sequence != null) {
            sequence.addChangeListener(this.layoutListener);
        }
        this.firePropertyChange("secSequence", prevSecSequence, sequence);
        this.resizeAndValidate();
    }

    public SymbolList getSymbols() {
        return this.sequence;
    }

    public SymbolList getSecondarySymbols() {
        return this.secSequence;
    }

    public FeatureHolder getFeatures() {
        return this.sequence;
    }

    public FeatureHolder getSecondaryFeatures() {
        return this.secSequence;
    }

    public RangeLocation getRange() {
        int visibleSymbols = this.getVisibleSymbolCount();
        if (visibleSymbols == 0) {
            return new RangeLocation(this.translation + 1, this.translation + 2);
        }
        return new RangeLocation(this.translation + 1, visibleSymbols);
    }

    public RangeLocation getSecondaryRange() {
        int visibleSecSymbols = this.getVisibleSecondarySymbolCount();
        if (visibleSecSymbols == 0) {
            return new RangeLocation(this.secTranslation + 1, this.secTranslation + 2);
        }
        return new RangeLocation(this.secTranslation + 1, visibleSecSymbols);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) throws IllegalArgumentException {
        int prevDirection = direction;
        int prevSecDirection = this.secDirection;
        if (direction == 0) {
            this.secDirection = 1;
        } else if (direction == 1) {
            this.secDirection = 0;
        } else {
            throw new IllegalArgumentException("Direction must be either HORIZONTAL or VERTICAL");
        }
        this.direction = direction;
        this.firePropertyChange("direction", prevDirection, direction);
        this.firePropertyChange("secDirection", prevSecDirection, this.secDirection);
        this.resizeAndValidate();
    }

    public int getSecondaryDirection() {
        return this.secDirection;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        double prevScale = this.scale;
        this.scale = scale;
        this.firePropertyChange("scale", prevScale, scale);
        this.resizeAndValidate();
    }

    public int getSymbolTranslation() {
        return this.translation;
    }

    public void setSymbolTranslation(int translation) throws IndexOutOfBoundsException {
        if (translation >= this.sequence.length()) {
            throw new IndexOutOfBoundsException("Tried to set symbol translation offset equal to or greater than SymbolList length");
        }
        int prevTranslation = this.translation;
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport(TRANSLATION);
            ChangeEvent ce = new ChangeEvent(this, TRANSLATION);
            cs.firePostChangeEvent(ce);
            this.translation = translation;
            cs.firePostChangeEvent(ce);
        } else {
            this.translation = translation;
        }
        this.firePropertyChange("translation", prevTranslation, translation);
        this.resizeAndValidate();
    }

    public int getSecondarySymbolTranslation() {
        return this.secTranslation;
    }

    public void setSecondarySymbolTranslation(int translation) throws IndexOutOfBoundsException {
        if (translation >= this.secSequence.length()) {
            throw new IndexOutOfBoundsException("Tried to set secondary symbol translation offset equal to or greater than SymbolList length");
        }
        int prevSecTranslation = this.secTranslation;
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport(TRANSLATION);
            ChangeEvent ce = new ChangeEvent(this, TRANSLATION);
            cs.firePostChangeEvent(ce);
            this.secTranslation = translation;
            cs.firePostChangeEvent(ce);
        } else {
            this.secTranslation = translation;
        }
        this.firePropertyChange("secTranslation", prevSecTranslation, translation);
        this.resizeAndValidate();
    }

    public SequenceRenderContext.Border getLeadingBorder() {
        return this.leadingBorder;
    }

    public SequenceRenderContext.Border getTrailingBorder() {
        return this.trailingBorder;
    }

    public PairwiseSequenceRenderer getRenderer() {
        return this.renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderer(PairwiseSequenceRenderer renderer) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport(RENDERER);
            ChangeEvent ce = new ChangeEvent(this, RENDERER, renderer, this.renderer);
            ChangeSupport changeSupport = cs;
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this._setRenderer(renderer);
                cs.firePostChangeEvent(ce);
            }
        } else {
            this._setRenderer(renderer);
        }
        this.resizeAndValidate();
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public void setRenderingHints(RenderingHints hints) {
        RenderingHints prevHints = this.hints;
        this.hints = hints;
        this.firePropertyChange("hints", prevHints, hints);
    }

    public double sequenceToGraphics(int sequencePos) {
        return (double)(sequencePos - this.translation - 1) * this.scale;
    }

    public double secondarySequenceToGraphics(int sequencePos) {
        return (double)(sequencePos - this.secTranslation - 1) * this.scale;
    }

    public int graphicsToSequence(double graphicsPos) {
        return (int)(graphicsPos / this.scale) + this.translation + 1;
    }

    public int graphicsToSequence(Point point) {
        if (this.direction == 0) {
            return this.graphicsToSequence(point.getX());
        }
        return this.graphicsToSequence(point.getY());
    }

    public int graphicsToSecondarySequence(double graphicsPos) {
        return (int)(graphicsPos / this.scale) + this.secTranslation + 1;
    }

    public int graphicsToSecondarySequence(Point point) {
        if (this.secDirection == 0) {
            return this.graphicsToSecondarySequence(point.getX());
        }
        return this.graphicsToSecondarySequence(point.getY());
    }

    public int getVisibleSymbolCount() {
        Insets insets = this.getInsets();
        int visible = this.direction == 0 ? this.getWidth() - insets.left - insets.right : this.getHeight() - insets.top - insets.bottom;
        return Math.min(this.graphicsToSequence(visible), this.sequence.length());
    }

    public int getVisibleSecondarySymbolCount() {
        Insets insets = this.getInsets();
        int visible = this.secDirection == 0 ? this.getWidth() - insets.left - insets.right : this.getHeight() - insets.top - insets.bottom;
        return Math.min(this.graphicsToSecondarySequence(visible), this.secSequence.length());
    }

    public void paintComponent(Graphics g) {
        if (!this.isActive()) {
            return;
        }
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.addRenderingHints(this.hints);
        if (this.isOpaque()) {
            g2.setPaint(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        AffineTransform prevTransform = g2.getTransform();
        Shape prevClip = g2.getClip();
        Insets insets = this.getInsets();
        Rectangle2D.Double clip = new Rectangle2D.Double();
        clip.x = 0.0;
        clip.y = 0.0;
        if (this.direction == 0) {
            clip.width = this.sequenceToGraphics(this.getVisibleSymbolCount() + 1);
            clip.height = this.secondarySequenceToGraphics(this.getVisibleSecondarySymbolCount() + 1);
            g2.translate(this.leadingBorder.getSize() + (double)insets.left, (double)insets.top);
        } else {
            clip.width = this.secondarySequenceToGraphics(this.getVisibleSecondarySymbolCount() + 1);
            clip.height = this.sequenceToGraphics(this.getVisibleSymbolCount() + 1);
            g2.translate((double)insets.left, this.leadingBorder.getSize() + (double)insets.top);
        }
        g2.clip(clip);
        this.renderer.paint(g2, this);
        g2.setTransform(prevTransform);
        g2.setClip(prevClip);
    }

    public void resizeAndValidate() {
        Dimension d = null;
        if (!this.isActive()) {
            d = new Dimension(0, 0);
        } else {
            double height;
            double width;
            if (this.direction == 0) {
                width = this.sequenceToGraphics(this.getVisibleSymbolCount());
                height = this.secondarySequenceToGraphics(this.getVisibleSecondarySymbolCount());
            } else {
                width = this.secondarySequenceToGraphics(this.getVisibleSecondarySymbolCount());
                height = this.sequenceToGraphics(this.getVisibleSymbolCount());
            }
            d = new Dimension((int)Math.ceil(width), (int)Math.ceil(height));
        }
        this.setMinimumSize(d);
        this.setPreferredSize(d);
        this.setMaximumSize(d);
        this.revalidate();
    }

    public void addChangeListener(ChangeListener cl) {
        this.addChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        ChangeSupport cs = this.getChangeSupport(ct);
        cs.addChangeListener(cl, ct);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.removeChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport(ct);
            cs.removeChangeListener(cl);
        }
    }

    public boolean isUnchanging(ChangeType ct) {
        ChangeSupport cs = this.getChangeSupport(ct);
        return cs.isUnchanging(ct);
    }

    public void addSequenceViewerListener(SequenceViewerListener svl) {
        this.svSupport.addSequenceViewerListener(svl);
    }

    public void removeSequenceViewerListener(SequenceViewerListener svl) {
        this.svSupport.removeSequenceViewerListener(svl);
    }

    public void addSequenceViewerMotionListener(SequenceViewerMotionListener svml) {
        this.svmSupport.addSequenceViewerMotionListener(svml);
    }

    public void removeSequenceViewerMotionListener(SequenceViewerMotionListener svml) {
        this.svmSupport.removeSequenceViewerMotionListener(svml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChangeSupport getChangeSupport(ChangeType ct) {
        if (this.changeSupport != null) {
            return this.changeSupport;
        }
        PairwiseSequencePanel pairwiseSequencePanel = this;
        synchronized (pairwiseSequencePanel) {
            if (this.changeSupport == null) {
                this.changeSupport = new ChangeSupport();
            }
            return this.changeSupport;
        }
    }

    protected boolean hasListeners() {
        return this.changeSupport != null;
    }

    protected boolean isActive() {
        return this.sequence != null && this.secSequence != null && this.renderer != null;
    }

    private void _setRenderer(PairwiseSequenceRenderer renderer) {
        Changeable c;
        if (this.renderer != null && (class$org$biojava$utils$Changeable == null ? (class$org$biojava$utils$Changeable = PairwiseSequencePanel.class$("org.biojava.utils.Changeable")) : class$org$biojava$utils$Changeable).isInstance(this.renderer)) {
            c = (Changeable)((Object)this.renderer);
            c.removeChangeListener(this.layoutListener, SequenceRenderContext.LAYOUT);
            c.removeChangeListener(this.repaintListener, SequenceRenderContext.REPAINT);
        }
        this.renderer = renderer;
        if (renderer != null && (class$org$biojava$utils$Changeable == null ? (class$org$biojava$utils$Changeable = PairwiseSequencePanel.class$("org.biojava.utils.Changeable")) : class$org$biojava$utils$Changeable).isInstance(renderer)) {
            c = (Changeable)((Object)renderer);
            c.addChangeListener(this.layoutListener, SequenceRenderContext.LAYOUT);
            c.addChangeListener(this.repaintListener, SequenceRenderContext.REPAINT);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

