/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.biojava.bio.program.sax.AbstractNativeAppSAXParser;
import org.biojava.bio.program.sax.BlastLikeVersionSupport;
import org.biojava.bio.program.sax.DomainSectionSAXParser;
import org.biojava.bio.program.sax.GCGBlastSummaryLineHelper;
import org.biojava.bio.program.sax.HitSectionSAXParser;
import org.biojava.bio.program.sax.HmmerAlignmentSAXParser;
import org.biojava.bio.program.sax.HmmerSummaryLineHelper;
import org.biojava.bio.program.sax.NcbiBlastSummaryLineHelper;
import org.biojava.bio.program.sax.QName;
import org.biojava.bio.program.sax.SummaryLineHelperIF;
import org.biojava.bio.program.sax.WuBlastSummaryLineHelper;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class BlastSAXParser
extends AbstractNativeAppSAXParser {
    private BufferedReader oContents;
    private AttributesImpl oAtts = new AttributesImpl();
    private QName oAttQName = new QName(this);
    private ArrayList oBuffer = new ArrayList();
    private char[] aoChars;
    private char[] aoLineSeparator;
    private String[] aoKeys;
    private String[] aoArrayType = new String[1];
    private HashMap oMap = new HashMap();
    private int iVer;
    private BlastLikeVersionSupport oVersion;
    private HitSectionSAXParser oHits;
    private SummaryLineHelperIF oSummaryLineHelper;
    private String oQueryId;
    private String oDatabaseId;
    private static final int STARTUP = 0;
    private static final int IN_TRAILER = 1;
    private static final int AT_END = 2;
    private static final int IN_HEADER = 3;
    private static final int IN_SUMMARY = 4;
    private static final int FINISHED_HITS = 5;
    private boolean tDoneSummary = false;

    BlastSAXParser(BlastLikeVersionSupport poVersion, String poNamespacePrefix) throws SAXException {
        this.oVersion = poVersion;
        this.setNamespacePrefix(poNamespacePrefix);
        this.addPrefixMapping("biojava", "http://www.biojava.org");
        this.oHits = new HitSectionSAXParser(this.oVersion, this.getNamespacePrefix());
        this.changeState(0);
        this.aoLineSeparator = System.getProperty("line.separator").toCharArray();
        this.choosePartImplementations();
    }

    public String parse(BufferedReader poContents, String poLine) throws SAXException {
        String oLine = null;
        this.oQueryId = "";
        this.oDatabaseId = "";
        this.oContents = poContents;
        if (!this.oVersion.isStartOfDataSet(poLine)) {
            return poLine;
        }
        this.onNewBlastDataSet(poLine);
        try {
            oLine = this.oContents.readLine();
            while (oLine != null && !this.checkNewBlastLikeDataSet(oLine)) {
                this.interpret(oLine);
                oLine = this.oContents.readLine();
            }
        }
        catch (IOException x) {
            System.out.println(x.getMessage());
            System.out.println("File read interrupted");
        }
        if (this.iState == 1) {
            this.emitRawOutput(this.oBuffer);
            this.endElement(new QName(this, this.prefix("Trailer")));
            this.changeState(2);
        }
        this.endElement(new QName(this, this.prefix("BlastLikeDataSet")));
        return oLine;
    }

    private void interpret(String poLine) throws SAXException {
        if (this.iState == 3) {
            if (poLine.startsWith("Query=")) {
                StringTokenizer st = new StringTokenizer(poLine);
                st.nextToken();
                if (st.hasMoreTokens()) {
                    this.oQueryId = st.nextToken();
                }
            }
            if (poLine.startsWith("Database:")) {
                int i = poLine.indexOf(":");
                this.oDatabaseId = poLine.substring(i + 1).trim();
            }
            if (poLine.startsWith("Sequences producing significant alignments") || poLine.startsWith("Sequences producing High-scoring Segment Pairs") || poLine.startsWith("-------- ")) {
                this.emitRawOutput(this.oBuffer);
                this.oAtts.clear();
                this.oAttQName.setQName("id");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", this.oQueryId);
                this.oAttQName.setQName("metaData");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", "none");
                this.startElement(new QName(this, this.prefix("QueryId")), this.oAtts);
                this.endElement(new QName(this, this.prefix("QueryId")));
                this.oAtts.clear();
                this.oAttQName.setQName("id");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", this.oDatabaseId);
                this.oAttQName.setQName("metaData");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", "none");
                this.startElement(new QName(this, this.prefix("DatabaseId")), this.oAtts);
                this.endElement(new QName(this, this.prefix("DatabaseId")));
                this.oAtts.clear();
                this.endElement(new QName(this, this.prefix("Header")));
                this.changeState(4);
                this.oAtts.clear();
                this.startElement(new QName(this, this.prefix("Summary")), this.oAtts);
                try {
                    poLine = this.oContents.readLine();
                }
                catch (IOException x) {
                    System.err.println(x.getMessage());
                    System.err.println("File read interrupted");
                }
                if (!poLine.trim().equals("")) {
                    this.interpret(poLine);
                }
                return;
            }
            this.oBuffer.add(poLine);
        }
        if (this.iState == 4) {
            int iProgram = this.oVersion.getProgram();
            if (iProgram == 21) {
                if (poLine.trim().equals("")) {
                    return;
                }
                if (poLine.startsWith("Parsed for domains:")) {
                    String oAfterHmmr = this.hmmerDomainSummaryReached(poLine);
                    return;
                }
            } else if (poLine.trim().equals("") || poLine.trim().startsWith("[no more scores") || poLine.trim().startsWith("\\")) {
                if (!this.tDoneSummary) {
                    this.tDoneSummary = true;
                    this.endElement(new QName(this, this.prefix("Summary")));
                }
                return;
            }
            if (poLine.startsWith(">")) {
                this.hitsSectionReached(poLine);
                return;
            }
            if (!this.tDoneSummary) {
                this.parseSummaryLine(poLine);
            }
            return;
        }
        if (this.iState == 5) {
            this.endElement(new QName(this, this.prefix("Detail")));
            this.oAtts.clear();
            this.startElement(new QName(this, this.prefix("Trailer")), this.oAtts);
            this.changeState(1);
            this.oBuffer.clear();
            return;
        }
        if (this.iState == 1) {
            this.oBuffer.add(poLine);
        }
    }

    private void onNewBlastDataSet(String poLine) throws SAXException {
        if (!this.oVersion.isSupported()) {
            throw new SAXException("Program " + this.oVersion.getProgramString() + " Version " + this.oVersion.getVersionString() + " is not supported by the biojava blast-like parsing framework");
        }
        this.oAtts.clear();
        this.oAttQName.setQName("program");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", this.oVersion.getProgramString());
        this.oAttQName.setQName("version");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", this.oVersion.getVersionString());
        this.startElement(new QName(this, this.prefix("BlastLikeDataSet")), this.oAtts);
        this.iState = 3;
        this.oBuffer.clear();
        this.oAtts.clear();
        this.startElement(new QName(this, this.prefix("Header")), this.oAtts);
    }

    private void emitRawOutput(ArrayList poList) throws SAXException {
        this.oAtts.clear();
        this.oAttQName.setQName("xml:space");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "NMTOKEN", "preserve");
        this.startElement(new QName(this, this.prefix("RawOutput")), this.oAtts);
        int iTmpListSize = poList.size();
        int i = 0;
        while (i < iTmpListSize) {
            this.aoChars = ((String)poList.get(i)).toCharArray();
            this.characters(this.aoLineSeparator, 0, 1);
            this.characters(this.aoChars, 0, this.aoChars.length);
            ++i;
        }
        this.endElement(new QName(this, this.prefix("RawOutput")));
    }

    private void parseSummaryLine(String poLine) throws SAXException {
        this.oSummaryLineHelper.parse(poLine, this.oMap, this.oVersion);
        if (this.iVer == 32) {
            try {
                poLine = this.oContents.readLine();
                this.oSummaryLineHelper.parse(poLine, this.oMap, this.oVersion);
            }
            catch (IOException x) {
                System.out.println(x.getMessage());
                System.out.println("GCG File read interrupted");
            }
        }
        if (this.oMap.size() == 0) {
            return;
        }
        this.aoKeys = this.oMap.keySet().toArray(this.aoArrayType);
        this.oAtts.clear();
        int i = 0;
        while (i < this.aoKeys.length) {
            if (!this.aoKeys[i].equals("hitId") && !this.aoKeys[i].equals("hitDescription")) {
                this.oAttQName.setQName(this.aoKeys[i]);
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", (String)this.oMap.get(this.aoKeys[i]));
            }
            ++i;
        }
        this.startElement(new QName(this, this.prefix("HitSummary")), this.oAtts);
        int i2 = 0;
        while (i2 < this.aoKeys.length) {
            if (this.aoKeys[i2].equals("hitId")) {
                this.oAtts.clear();
                this.oAttQName.setQName("id");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", (String)this.oMap.get(this.aoKeys[i2]));
                this.oAttQName.setQName("metaData");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", "none");
                this.startElement(new QName(this, this.prefix("HitId")), this.oAtts);
                this.endElement(new QName(this, this.prefix("HitId")));
            } else if (this.aoKeys[i2].equals("hitDescription")) {
                this.oAtts.clear();
                this.startElement(new QName(this, this.prefix("HitDescription")), this.oAtts);
                this.aoChars = ((String)this.oMap.get(this.aoKeys[i2])).toCharArray();
                this.characters(this.aoChars, 0, this.aoChars.length);
                this.endElement(new QName(this, this.prefix("HitDescription")));
            }
            ++i2;
        }
        this.endElement(new QName(this, this.prefix("HitSummary")));
        this.oMap.clear();
    }

    private void hitsSectionReached(String poLine) throws SAXException {
        this.oHits.setContentHandler(this.oHandler);
        this.oAtts.clear();
        this.startElement(new QName(this, this.prefix("Detail")), this.oAtts);
        int iProgram = this.oVersion.getProgram();
        if (iProgram == 1 || iProgram == 3 || iProgram == 2 || iProgram == 4 || iProgram == 5) {
            this.oHits.parse(this.oContents, poLine, "Database:");
        }
        if (iProgram == 11 || iProgram == 13 || iProgram == 12 || iProgram == 14 || iProgram == 15) {
            this.oHits.parse(this.oContents, poLine, "Parameters:");
        }
        if (iProgram == 32) {
            this.oHits.parse(this.oContents, poLine, "Database:");
        }
        this.changeState(5);
    }

    private String hmmerDomainSummaryReached(String poLine) throws SAXException {
        this.oAtts.clear();
        this.startElement(new QName(this, this.prefix("DomainSummary")), this.oAtts);
        int iProgram = this.oVersion.getProgram();
        if (iProgram == 21) {
            DomainSectionSAXParser oDomains = new DomainSectionSAXParser(this.oVersion, this.getNamespacePrefix());
            oDomains.setContentHandler(this.oHandler);
            oDomains.parse(this.oContents, poLine);
            this.endElement(new QName(this, this.prefix("DomainSummary")));
            this.endElement(new QName(this, this.prefix("Summary")));
            String oLine = null;
            try {
                oLine = this.oContents.readLine();
                while (!(oLine == null || oLine.startsWith("Alignments of top-scoring domains:") || oLine.startsWith("//") || oLine.startsWith("Histogram of all scores:"))) {
                    oLine = this.oContents.readLine();
                }
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.err.println("File read interrupted");
                throw new SAXException("File read interrupted");
            }
            if (oLine != null && oLine.startsWith("Alignments of top-scoring domains:")) {
                this.oAtts.clear();
                this.startElement(new QName(this, this.prefix("Detail")), this.oAtts);
                HmmerAlignmentSAXParser oAlignments = new HmmerAlignmentSAXParser(this.oVersion, this.getNamespacePrefix());
                oAlignments.setContentHandler(this.oHandler);
                String oLastLine = oAlignments.parse(this.oContents, poLine);
                if (oLastLine.trim().equals("//")) {
                    this.endElement(new QName(this, this.prefix("Detail")));
                    try {
                        oLine = this.oContents.readLine();
                        while (oLine != null && !oLine.startsWith("Query:")) {
                            oLine = this.oContents.readLine();
                        }
                    }
                    catch (IOException e) {
                        System.err.println("Read interrupted");
                        System.err.println(e);
                        e.printStackTrace();
                        throw new SAXException("File read interupted");
                    }
                    if (oLine == null) {
                        this.changeState(2);
                        return oLine;
                    }
                    this.endElement(new QName(this, this.prefix("BlastLikeDataSet")));
                    this.oAtts.clear();
                    this.oAttQName.setQName("program");
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", this.oVersion.getProgramString());
                    this.oAttQName.setQName("version");
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", this.oVersion.getVersionString());
                    this.startElement(new QName(this, this.prefix("BlastLikeDataSet")), this.oAtts);
                    this.oAtts.clear();
                    this.startElement(new QName(this, this.prefix("Header")), this.oAtts);
                    this.oBuffer.clear();
                    this.oBuffer.add(oLine);
                    this.emitRawOutput(this.oBuffer);
                    this.endElement(new QName(this, this.prefix("Header")));
                    this.changeState(4);
                    this.oAtts.clear();
                    this.startElement(new QName(this, this.prefix("Summary")), this.oAtts);
                    try {
                        while (!oLine.startsWith("-------- ")) {
                            oLine = this.oContents.readLine();
                        }
                    }
                    catch (IOException x) {
                        System.err.println(x.getMessage());
                        System.err.println("File read interrupted");
                        throw new SAXException("File read interrupted");
                    }
                }
                oLine = oLastLine;
                this.changeState(5);
            } else {
                this.changeState(5);
            }
            return oLine;
        }
        return poLine;
    }

    private boolean checkNewBlastLikeDataSet(String poLine) {
        return poLine.startsWith("BLAST") || poLine.startsWith("TBLAST");
    }

    private void choosePartImplementations() throws SAXException {
        this.iVer = this.oVersion.getProgram();
        if (this.iVer == 1 || this.iVer == 3 || this.iVer == 2 || this.iVer == 4 || this.iVer == 5) {
            this.oSummaryLineHelper = new NcbiBlastSummaryLineHelper();
            return;
        }
        if (this.iVer == 11 || this.iVer == 13 || this.iVer == 12 || this.iVer == 14 || this.iVer == 15) {
            this.oSummaryLineHelper = new WuBlastSummaryLineHelper();
            return;
        }
        if (this.iVer == 21) {
            this.oSummaryLineHelper = new HmmerSummaryLineHelper();
            return;
        }
        if (this.iVer == 32) {
            this.oSummaryLineHelper = new GCGBlastSummaryLineHelper();
            return;
        }
        throw new SAXException("Could not choose a suitable implementation of the ".concat("SummaryLineHelperIF for program ").concat(this.oVersion.getProgramString()).concat(" version ").concat(this.oVersion.getVersionString()));
    }
}

