/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssaha;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.biojava.bio.BioException;
import org.biojava.bio.program.ssaha.DataStore;
import org.biojava.bio.program.ssaha.DataStoreFactory;
import org.biojava.bio.program.ssaha.NIODataStore;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Packing;
import org.biojava.bio.symbol.PackingFactory;
import org.biojava.utils.Constants;
import org.biojava.utils.io.LargeBuffer;

public class NIODataStoreFactory
implements DataStoreFactory {
    public DataStore getDataStore(File storeFile) throws IOException {
        return new NIODataStore(storeFile);
    }

    public DataStore buildDataStore(File storeFile, SequenceDB seqDB, Packing packing, int wordLength, int threshold) throws IllegalAlphabetException, IOException, BioException {
        ByteArrayOutputStream packingStream = new ByteArrayOutputStream();
        ObjectOutputStream packingSerializer = new ObjectOutputStream(packingStream);
        packingSerializer.writeObject(packing);
        packingSerializer.flush();
        int structDataSize = 3 * Constants.BYTES_IN_LONG + 2 * Constants.BYTES_IN_INT + packingStream.toByteArray().length;
        storeFile.createNewFile();
        RandomAccessFile store = new RandomAccessFile(storeFile, "rw");
        FileChannel channel = store.getChannel();
        System.out.println("Word length:\t" + wordLength);
        int words = 1 << packing.wordSize() * wordLength;
        System.out.println("Words:\t" + words);
        long hashTablePos = structDataSize;
        long hashTableSize = Constants.BYTES_IN_LONG + words * Constants.BYTES_IN_LONG;
        System.out.println("Allocated:\t" + hashTableSize);
        MappedByteBuffer hashTable_MB = channel.map(FileChannel.MapMode.READ_WRITE, hashTablePos, hashTableSize);
        LongBuffer hashTable = hashTable_MB.asLongBuffer();
        hashTable.put(0, hashTableSize);
        int i = 0;
        while (i < words) {
            hashTable.put(i + 1, 0L);
            ++i;
        }
        hashTable.position(0);
        System.out.println("Initialized hash table");
        System.out.println("First parse");
        int seqCount = 0;
        int nameChars = 0;
        SequenceIterator i2 = seqDB.sequenceIterator();
        while (i2.hasNext()) {
            Sequence seq = i2.nextSequence();
            System.out.println(seq.getName());
            if (seq.length() <= wordLength) continue;
            ++seqCount;
            nameChars += seq.getName().length();
            int word = PackingFactory.primeWord(seq, wordLength, packing);
            this.addCount(hashTable, word);
            int j = wordLength + 2;
            while (j <= seq.length()) {
                word = PackingFactory.nextWord(seq, word, j, wordLength, packing);
                this.addCount(hashTable, word);
                ++j;
            }
        }
        System.out.println();
        System.out.println("Done");
        long nameTablePos = hashTablePos + hashTableSize;
        int nameTableSize = Constants.BYTES_IN_INT + seqCount * Constants.BYTES_IN_SHORT + nameChars * Constants.BYTES_IN_CHAR;
        System.out.println("nameTableSize:\t" + nameTableSize);
        MappedByteBuffer nameTable = channel.map(FileChannel.MapMode.READ_WRITE, nameTablePos, nameTableSize);
        nameTable.putInt(0, nameTableSize);
        nameTable.position(Constants.BYTES_IN_INT);
        long kmersUsed = 0L;
        long hitCount = 0L;
        int i3 = 0;
        while (i3 < words) {
            long counts = hashTable.get(i3 + 1);
            if (counts > 0L && counts < (long)threshold) {
                hitCount += counts;
                ++kmersUsed;
            }
            ++i3;
        }
        System.out.println("hitCount: " + hitCount);
        System.out.println("kmersUsed: " + kmersUsed);
        long hitTablePos = nameTablePos + (long)nameTableSize;
        long hitTableSize = (long)Constants.BYTES_IN_LONG + hitCount * (long)(Constants.BYTES_IN_INT + Constants.BYTES_IN_INT) + kmersUsed * (long)Constants.BYTES_IN_INT;
        System.out.println("hitTableSize:\t" + hitTableSize);
        System.out.println("hitTablePos:\t" + hitTablePos);
        LargeBuffer hitTable = new LargeBuffer(channel, FileChannel.MapMode.READ_WRITE, hitTablePos, hitTableSize);
        hitTable.position(0L);
        hitTable.putLong(hitTableSize);
        System.out.println("Writing pointers from hash to hits");
        long hitOffset = 0L;
        int i4 = 0;
        while (i4 < words) {
            long counts = hashTable.get(i4 + 1);
            if (counts > 0L && counts < (long)threshold) {
                try {
                    if (hitOffset < 0L) {
                        throw new IndexOutOfBoundsException("Hit offset negative");
                    }
                    hashTable.put(i4 + 1, hitOffset);
                    hitTable.putInt(hitOffset + (long)Constants.BYTES_IN_LONG, 0);
                    hitOffset += (long)Constants.BYTES_IN_INT + counts * (long)(Constants.BYTES_IN_INT + Constants.BYTES_IN_INT);
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println("counts:\t" + counts);
                    System.out.println("word:\t" + i4);
                    System.out.println("hitOffset:\t" + hitOffset);
                    throw e;
                }
            } else {
                hashTable.put(i4 + 1, -1L);
            }
            ++i4;
        }
        System.out.println("2nd parse");
        int seqNumber = 0;
        nameTable.position(Constants.BYTES_IN_INT);
        SequenceIterator i5 = seqDB.sequenceIterator();
        while (i5.hasNext()) {
            Sequence seq = i5.nextSequence();
            System.out.println(seq.getName());
            ++seqNumber;
            if (seq.length() <= wordLength) continue;
            try {
                int namePos = nameTable.position() - Constants.BYTES_IN_INT;
                String name = seq.getName();
                nameTable.putShort((short)name.length());
                int j = 0;
                while (j < name.length()) {
                    nameTable.putChar(name.charAt(j));
                    ++j;
                }
                int word = PackingFactory.primeWord(seq, wordLength, packing);
                this.writeRecord(hashTable, hitTable, 1, namePos, word);
                int j2 = wordLength + 2;
                while (j2 <= seq.length()) {
                    word = PackingFactory.nextWord(seq, word, j2, wordLength, packing);
                    this.writeRecord(hashTable, hitTable, j2 - wordLength, namePos, word);
                    ++j2;
                }
            }
            catch (BufferOverflowException e) {
                System.out.println("name:\t" + seq.getName());
                System.out.println("seqNumber:\t" + seqNumber);
                System.out.println("nt pos:\t" + nameTable.position());
                throw e;
            }
        }
        System.out.println();
        System.out.println("Done");
        MappedByteBuffer rootBuffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, structDataSize);
        rootBuffer.position(0);
        rootBuffer.putLong(hashTablePos);
        rootBuffer.putLong(hitTablePos);
        rootBuffer.putLong(nameTablePos);
        rootBuffer.putInt(wordLength);
        rootBuffer.putInt(packingStream.toByteArray().length);
        rootBuffer.put(packingStream.toByteArray());
        rootBuffer.force();
        hashTable_MB.force();
        hitTable.force();
        nameTable.force();
        System.out.println("Committed");
        return this.getDataStore(storeFile);
    }

    private void addCount(LongBuffer buffer, int word) {
        long count = buffer.get(word + 1);
        buffer.put(word + 1, ++count);
    }

    private void writeRecord(LongBuffer hashTable, LargeBuffer hitTable, int offset, int seqNumber, int word) throws IOException {
        long kmerPointer = hashTable.get(word + 1);
        if (kmerPointer != -1L) {
            int hitCount = hitTable.getInt(kmerPointer += (long)Constants.BYTES_IN_LONG);
            long pos = kmerPointer + (long)(hitCount * (Constants.BYTES_IN_INT + Constants.BYTES_IN_INT)) + (long)Constants.BYTES_IN_INT;
            hitTable.position(pos);
            hitTable.putInt(seqNumber);
            hitTable.putInt(offset);
            hitTable.putInt(kmerPointer, hitCount + 1);
        }
    }
}

