/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.xff;

import org.biojava.bio.Annotation;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.program.xff.LocationHandlerBase;
import org.biojava.bio.program.xff.XFFFeatureSetHandler;
import org.biojava.bio.program.xff.XFFPartHandlerFactory;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StAXContentHandlerBase;
import org.biojava.utils.stax.StringElementHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FeatureHandler
extends StAXContentHandlerBase {
    public static final XFFPartHandlerFactory FEATURE_HANDLER_FACTORY = new XFFPartHandlerFactory(){

        public StAXContentHandler getPartHandler(XFFFeatureSetHandler xffenv) {
            return new FeatureHandler(xffenv);
        }
    };
    private XFFFeatureSetHandler xffenv;
    private Feature.Template template = null;
    private boolean startFired = false;
    private boolean endFired = false;
    private int level = 0;

    public FeatureHandler(XFFFeatureSetHandler xffenv) {
        this.xffenv = xffenv;
    }

    public XFFFeatureSetHandler getXFFEnvironment() {
        return this.xffenv;
    }

    protected Feature.Template getFeatureTemplate() {
        if (this.template == null) {
            this.template = this.createFeatureTemplate();
        }
        return this.template;
    }

    protected Feature.Template createFeatureTemplate() {
        return new Feature.Template();
    }

    protected void fireStartFeature() throws ParseException {
        if (this.startFired) {
            throw new ParseException("startFeature event has already been fired for this feature");
        }
        Feature.Template templ = this.getFeatureTemplate();
        if (templ.annotation == null) {
            templ.annotation = Annotation.EMPTY_ANNOTATION;
        }
        this.getXFFEnvironment().getFeatureListener().startFeature(templ);
        this.startFired = true;
    }

    protected void fireEndFeature() throws ParseException {
        if (!this.startFired) {
            throw new ParseException("startFeature has not yet been fired for this feature.");
        }
        if (this.endFired) {
            throw new ParseException("endFeature event has already been fired for this feature");
        }
        this.getXFFEnvironment().getFeatureListener().endFeature();
        this.endFired = true;
    }

    protected void setFeatureProperty(Object key, Object value) throws ChangeVetoException, ParseException {
        if (this.startFired) {
            this.getXFFEnvironment().getFeatureListener().addFeatureProperty(key, value);
        } else {
            Feature.Template ft = this.getFeatureTemplate();
            if (ft.annotation == null) {
                ft.annotation = new SmallAnnotation();
            }
            ft.annotation.setProperty(key, value);
        }
    }

    public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
        ++this.level;
        if (this.level == 1) {
            String id = attrs.getValue("id");
            if (id != null) {
                try {
                    this.setFeatureProperty("org.biojava.bio.program.xff.id", id);
                }
                catch (Exception ex) {
                    throw new SAXException("Couldn't set property", ex);
                }
            }
        } else if (localName.equals("type")) {
            dm.delegate(this.getTypeHandler());
        } else if (localName.equals("source")) {
            dm.delegate(this.getSourceHandler());
        } else if (localName.equals("location")) {
            dm.delegate(this.getLocationHandler());
        } else if (localName.equals("id")) {
            dm.delegate(this.getOldIDHandler());
        } else if (localName.equals("details")) {
            if (!this.startFired) {
                try {
                    this.fireStartFeature();
                }
                catch (ParseException ex) {
                    throw new SAXException(ex);
                }
            }
            dm.delegate(this.xffenv.getDetailsHandler());
        } else if (localName.equals("featureSet")) {
            if (!this.startFired) {
                try {
                    this.fireStartFeature();
                }
                catch (ParseException ex) {
                    throw new SAXException(ex);
                }
            }
            dm.delegate(this.xffenv);
        }
    }

    public void endElement(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
        --this.level;
        if (this.level == 0) {
            try {
                if (!this.startFired) {
                    this.fireStartFeature();
                }
                if (!this.endFired) {
                    this.fireEndFeature();
                }
            }
            catch (ParseException ex) {
                throw new SAXException(ex);
            }
        }
    }

    protected StAXContentHandler getTypeHandler() {
        return new StringElementHandlerBase(){

            protected void setStringValue(String s) {
                FeatureHandler.this.getFeatureTemplate().type = s.trim();
            }
        };
    }

    protected StAXContentHandler getSourceHandler() {
        return new StringElementHandlerBase(){

            protected void setStringValue(String s) {
                FeatureHandler.this.getFeatureTemplate().source = s.trim();
            }
        };
    }

    protected StAXContentHandler getOldIDHandler() {
        return new StringElementHandlerBase(){

            protected void setStringValue(String s) throws SAXException {
                try {
                    FeatureHandler.this.setFeatureProperty("org.biojava.bio.program.xff.id", s.trim());
                }
                catch (Exception ex) {
                    throw new SAXException("Couldn't set property", ex);
                }
            }
        };
    }

    protected StAXContentHandler getLocationHandler() {
        return new LocationHandlerBase(){

            protected void setLocationValue(Location l) {
                FeatureHandler.this.getFeatureTemplate().location = l;
            }
        };
    }
}

