/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.proteomics;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.proteomics.Protease;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class ProteaseManager {
    private static Map name2Protease = new HashMap();
    static Document doc = null;
    private static ProteaseManager singletonInstance;
    public static final String TRYPSIN = "Trypsin";
    public static final String LYS_C = "Lys-C";
    public static final String ARG_C = "Arg-C";
    public static final String ASP_N = "Asp-N";
    public static final String GLU_C_BICARB = "Glu-C-bicarbonate";
    public static final String GLU_C_PHOS = "Glu-C-phosphate";
    public static final String CHYMOTRYP = "Chymotrypsin";
    public static final String CNBr = "CNBr";
    static /* synthetic */ Class class$org$biojava$bio$proteomics$ProteaseManager;

    public static synchronized Protease createProtease(SymbolList cleaveRes, boolean endoProtease, SymbolList notCleaveRes, String name) throws IllegalSymbolException, BioException {
        Protease p = new Protease(cleaveRes, endoProtease, notCleaveRes, name);
        ProteaseManager.registerProtease(p);
        return p;
    }

    public static synchronized Protease createProtease(SymbolList cleaveRes, boolean endoProtease, String name) throws IllegalSymbolException, BioException {
        Protease p = new Protease(cleaveRes, endoProtease, SymbolList.EMPTY_LIST, name);
        ProteaseManager.registerProtease(p);
        return p;
    }

    public static synchronized Protease createProtease(String cleaveRes, boolean endoProtease, String notCleaveRes, String name) throws BioException, IllegalSymbolException {
        return ProteaseManager.createProtease(ProteaseManager.createSymbolList(cleaveRes), endoProtease, ProteaseManager.createSymbolList(notCleaveRes), name);
    }

    public static synchronized Protease createProtease(String cleaveRes, boolean endoProtease, String name) throws BioException, IllegalSymbolException {
        return ProteaseManager.createProtease(ProteaseManager.createSymbolList(cleaveRes), endoProtease, SymbolList.EMPTY_LIST, name);
    }

    public static synchronized void registerProtease(Protease prot) throws BioException {
        if (ProteaseManager.registered(prot.getName())) {
            throw new BioException("A Protease has already been registered with the name " + prot.getName());
        }
        name2Protease.put(prot.getName(), prot);
    }

    public static Protease getProteaseByName(String proteaseName) throws BioException {
        Protease protease = (Protease)name2Protease.get(proteaseName);
        if (protease == null) {
            throw new BioException("No protease has been registered by that name");
        }
        return protease;
    }

    public static Set getNames() {
        return Collections.unmodifiableSet(name2Protease.keySet());
    }

    public static Set getAllProteases() {
        return Collections.unmodifiableSet(new HashSet(name2Protease.values()));
    }

    public static boolean registered(String proteaseName) {
        return name2Protease.containsKey(proteaseName);
    }

    public static synchronized ProteaseManager getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new ProteaseManager();
        }
        return singletonInstance;
    }

    private static SymbolList createSymbolList(String seq) throws IllegalSymbolException, BioException {
        if (seq == null || seq.trim().equals("")) {
            return SymbolList.EMPTY_LIST;
        }
        FiniteAlphabet prot = (FiniteAlphabet)AlphabetManager.alphabetForName("PROTEIN");
        SymbolTokenization tokenization = prot.getTokenization("token");
        SimpleSymbolList sList = new SimpleSymbolList(tokenization, seq);
        return sList;
    }

    public static Protease getTrypsin() {
        try {
            return ProteaseManager.getProteaseByName(TRYPSIN);
        }
        catch (BioException ex) {
            throw new BioError(ex, "Cannot retreive Trypsin, AlphabetManager.xml may be corrupted");
        }
    }

    public static Protease getLys_C() {
        try {
            return ProteaseManager.getProteaseByName(LYS_C);
        }
        catch (BioException ex) {
            throw new BioError(ex, "Cannot retreive Lys-C, AlphabetManager.xml may be corrupted");
        }
    }

    public static Protease getArg_C() {
        try {
            return ProteaseManager.getProteaseByName(ARG_C);
        }
        catch (BioException ex) {
            throw new BioError(ex, "Cannot retreive Arg-C, AlphabetManager.xml may be corrupted");
        }
    }

    public static Protease getAsp_N() {
        try {
            return ProteaseManager.getProteaseByName(ASP_N);
        }
        catch (BioException ex) {
            throw new BioError(ex, "Cannot retreive Asp-N, AlphabetManager.xml may be corrupted");
        }
    }

    public static Protease getGlu_C_bicarbonate() {
        try {
            return ProteaseManager.getProteaseByName(GLU_C_BICARB);
        }
        catch (BioException ex) {
            throw new BioError(ex, "Cannot retreive Glu_C_bicarbonate, AlphabetManager.xml may be corrupted");
        }
    }

    public static Protease getGlu_C_phosphate() {
        try {
            return ProteaseManager.getProteaseByName(GLU_C_PHOS);
        }
        catch (BioException ex) {
            throw new BioError(ex, "Cannot retreive Glu_C_phosphate, AlphabetManager.xml may be corrupted");
        }
    }

    public static Protease getChymotrypsin() {
        try {
            return ProteaseManager.getProteaseByName(CHYMOTRYP);
        }
        catch (BioException ex) {
            throw new BioError(ex, "Cannot retreive Chymotrypsin, AlphabetManager.xml may be corrupted");
        }
    }

    public static Protease getCNBr() {
        try {
            return ProteaseManager.getProteaseByName(CNBr);
        }
        catch (BioException ex) {
            throw new BioError(ex, "Cannot retreive CNBr, AlphabetManager.xml may be corrupted");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            InputStream tablesStream = (class$org$biojava$bio$proteomics$ProteaseManager == null ? (class$org$biojava$bio$proteomics$ProteaseManager = ProteaseManager.class$("org.biojava.bio.proteomics.ProteaseManager")) : class$org$biojava$bio$proteomics$ProteaseManager).getClassLoader().getResourceAsStream("org/biojava/bio/proteomics/ProteaseManager.xml");
            if (tablesStream == null) {
                throw new BioException("Couldn't locate ProteaseManager.xml.");
            }
            InputSource is = new InputSource(tablesStream);
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = parser.parse(is);
            NodeList children = doc.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Element child;
                Node cnode = children.item(i);
                if (cnode instanceof Element && (child = (Element)cnode).getNodeName().equals("protease")) {
                    SymbolList cleavRes = null;
                    SymbolList exceptRes = null;
                    boolean endo = false;
                    String protName = child.getAttribute("name");
                    Protease protease = null;
                    NodeList proteaseNodes = child.getChildNodes();
                    int j = 0;
                    while (j < proteaseNodes.getLength()) {
                        Node cnode2 = proteaseNodes.item(j);
                        if (cnode2 instanceof Element) {
                            Element el = (Element)cnode2;
                            String name = el.getNodeName();
                            String content = el.getFirstChild().getNodeValue();
                            if (name.equals("cleaveRes")) {
                                cleavRes = ProteaseManager.createSymbolList(content.trim());
                            } else if (name.equals("exceptRes")) {
                                exceptRes = ProteaseManager.createSymbolList(content.trim());
                            } else if (name.equals("endo")) {
                                endo = new Boolean(content);
                            }
                            if (cleavRes == null) {
                                cleavRes = ProteaseManager.createSymbolList("");
                            }
                            if (exceptRes == null) {
                                exceptRes = ProteaseManager.createSymbolList("");
                            }
                            protease = new Protease(cleavRes, endo, exceptRes, protName);
                        }
                        ++j;
                    }
                    ProteaseManager.registerProtease(protease);
                }
                ++i;
            }
        }
        catch (MissingResourceException mre) {
            System.err.println(mre.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

