/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeVetoException;

public abstract class AbstractFeatureHolder
extends AbstractChangeable
implements FeatureHolder {
    public FeatureHolder filter(FeatureFilter filter) {
        boolean recurse = FilterUtils.areProperSubset(filter, FeatureFilter.top_level);
        return this.filter(filter, recurse);
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        SimpleFeatureHolder res = new SimpleFeatureHolder();
        Iterator f = this.features();
        while (f.hasNext()) {
            Feature feat = (Feature)f.next();
            if (ff.accept(feat)) {
                try {
                    res.addFeature(feat);
                }
                catch (ChangeVetoException cve) {
                    throw new BioError("Assertion failed: Couldn't add a feature to my new FeatureHolder");
                }
            }
            if (!recurse) continue;
            FeatureHolder r = feat.filter(ff, recurse);
            Iterator rf = r.features();
            while (rf.hasNext()) {
                try {
                    res.addFeature((Feature)rf.next());
                }
                catch (ChangeVetoException cve) {
                    throw new BioError(cve, "Assertion failure: Should be able to manipulate this FeatureHolder");
                }
            }
        }
        return res;
    }

    public Feature createFeature(Feature.Template temp) throws BioException, ChangeVetoException {
        throw new ChangeVetoException("This FeatureHolder does not support creation of new Features.");
    }

    public void removeFeature(Feature f) throws ChangeVetoException {
        throw new ChangeVetoException("This FeatureHolder does not support removal of Features.");
    }
}

