/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Iterator;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public interface Feature
extends FeatureHolder,
Annotatable {
    public static final String PROPERTY_DATA_KEY = "internal_data";
    public static final ChangeType LOCATION = new ChangeType("Location has altered", 1.class$org$biojava$bio$seq$Feature == null ? (1.class$org$biojava$bio$seq$Feature = 1.class$("org.biojava.bio.seq.Feature")) : 1.class$org$biojava$bio$seq$Feature, "LOCATION");
    public static final ChangeType TYPE = new ChangeType("Type has altered", 1.class$org$biojava$bio$seq$Feature == null ? (1.class$org$biojava$bio$seq$Feature = 1.class$("org.biojava.bio.seq.Feature")) : 1.class$org$biojava$bio$seq$Feature, "TYPE");
    public static final ChangeType SOURCE = new ChangeType("Source has altered", 1.class$org$biojava$bio$seq$Feature == null ? (1.class$org$biojava$bio$seq$Feature = 1.class$("org.biojava.bio.seq.Feature")) : 1.class$org$biojava$bio$seq$Feature, "SOURCE");
    public static final ByLocationComparator byLocationOrder = new ByLocationComparator();

    public Location getLocation();

    public void setLocation(Location var1) throws ChangeVetoException;

    public String getType();

    public void setType(String var1) throws ChangeVetoException;

    public String getSource();

    public void setSource(String var1) throws ChangeVetoException;

    public SymbolList getSymbols();

    public FeatureHolder getParent();

    public Sequence getSequence();

    public Iterator features();

    public Template makeTemplate();

    class 1 {
        static /* synthetic */ Class class$org$biojava$bio$seq$Feature;

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class ByLocationComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Feature f1 = (Feature)o1;
            Feature f2 = (Feature)o2;
            if (f1.getLocation().getMin() > f2.getLocation().getMin()) {
                return 1;
            }
            if (f1.getLocation().getMin() < f2.getLocation().getMin()) {
                return -1;
            }
            return 0;
        }
    }

    public static class Template
    implements Serializable {
        public Location location;
        public String type;
        public String source;
        public Annotation annotation;

        public int hashCode() {
            Class<?> templClazz = this.getClass();
            Field[] fields = templClazz.getFields();
            int hc = 0;
            int i = 0;
            while (i < fields.length) {
                try {
                    Object o = fields[i].get(this);
                    if (o != null) {
                        hc += o.hashCode();
                    }
                }
                catch (Exception ex) {
                    throw new BioError(ex, "Can't access template fields");
                }
                ++i;
            }
            return hc;
        }

        public boolean equals(Object b) {
            Class<?> bClazz;
            Class<?> aClazz = this.getClass();
            if (!aClazz.equals(bClazz = b.getClass())) {
                return false;
            }
            Field[] fields = aClazz.getFields();
            int i = 0;
            while (i < fields.length) {
                try {
                    Object ao = fields[i].get(this);
                    Object bo = fields[i].get(b);
                    if (ao != bo) {
                        if (ao == null) {
                            return false;
                        }
                        if (!ao.equals(bo)) {
                            return false;
                        }
                    }
                }
                catch (Exception ex) {
                    throw new BioError(ex, "Can't access template fields");
                }
                ++i;
            }
            return true;
        }

        public void populate(Feature feat) throws BioException {
            Field[] fields = this.getClass().getFields();
            Method[] methods = feat.getClass().getMethods();
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                String fName = field.getName();
                String methName = "get" + fName.substring(0, 1).toUpperCase() + fName.substring(1);
                Method method = null;
                int j = 0;
                while (j < methods.length) {
                    Method meth = methods[j];
                    if (methods[j].getName().equals(methName)) {
                        method = meth;
                    }
                    ++j;
                }
                if (method == null) {
                    throw new BioException("Expecting to find a method named: " + methName);
                }
                try {
                    field.set(this, method.invoke((Object)feat, new Object[0]));
                }
                catch (Exception e) {
                    throw new BioError(e, "Couldn't access template fields");
                }
                ++i;
            }
        }

        public String toString() {
            StringBuffer sbuf = new StringBuffer();
            Class<?> us = this.getClass();
            sbuf.append(us);
            sbuf.append(":");
            Field[] fields = us.getFields();
            int i = 0;
            while (i < fields.length) {
                try {
                    sbuf.append(" ");
                    sbuf.append(fields[i].getName());
                    sbuf.append("=");
                    sbuf.append(fields[i].get(this));
                }
                catch (Exception e) {
                    throw new BioError(e, "Couldn't access template fields");
                }
                ++i;
            }
            return sbuf.toString();
        }
    }
}

