/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import org.biojava.bio.BioError;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.biosql.BioSQLFeature;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.SymbolList;

class BioSQLStrandedFeature
extends BioSQLFeature
implements StrandedFeature {
    private StrandedFeature.Strand strand;

    public StrandedFeature.Strand getStrand() {
        return this.strand;
    }

    public SymbolList getSymbols() {
        SymbolList symList = super.getSymbols();
        if (this.getStrand() == StrandedFeature.NEGATIVE) {
            try {
                symList = DNATools.reverseComplement(symList);
            }
            catch (IllegalAlphabetException iae) {
                throw new BioError(iae, "Could not retrieve symbols for feature as the alphabet can not be complemented.");
            }
        }
        return symList;
    }

    public Feature.Template makeTemplate() {
        StrandedFeature.Template ft = new StrandedFeature.Template();
        this.fillTemplate(ft);
        return ft;
    }

    protected void fillTemplate(StrandedFeature.Template ft) {
        super.fillTemplate(ft);
        ft.strand = this.getStrand();
    }

    public BioSQLStrandedFeature(Sequence sourceSeq, FeatureHolder parent, StrandedFeature.Template template) throws IllegalArgumentException, IllegalAlphabetException {
        super(sourceSeq, parent, template);
        this.strand = template.strand;
    }

    public BioSQLStrandedFeature(Sequence sourceSeq, StrandedFeature.Template template) throws IllegalArgumentException, IllegalAlphabetException {
        super(sourceSeq, template);
        this.strand = template.strand;
    }

    public String toString() {
        String pm = this.getStrand() == StrandedFeature.POSITIVE ? "+" : "-";
        return super.toString() + " " + pm;
    }
}

