/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SubArraySymbolList;
import org.biojava.bio.seq.io.SymbolReader;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SimpleSymbolListFactory;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListFactory;
import org.biojava.utils.ChangeListener;

public class ChunkedSymbolListFactory {
    private static final int AUTO_SELECT = 1;
    private static final int SUPPLIED_FACTORY = 2;
    private static final int CHUNK_SIZE = 16384;
    private final SymbolListFactory userSymListFactory;
    private SymbolListFactory currSymListFactory = null;
    private Alphabet alfa;
    private Symbol[] headChunk;
    private int headChunkPos = 0;
    private List chunkL = new ArrayList();
    private int symCount = 0;
    private int opMode = 2;
    private int threshold = 0x100000;
    private static int currentMin = Integer.MAX_VALUE;
    private static int currentMax = Integer.MIN_VALUE;
    private static SymbolList currentChunk = null;
    private boolean canDoMake = true;

    public ChunkedSymbolListFactory(SymbolListFactory symListFactory) {
        this.opMode = 2;
        this.userSymListFactory = symListFactory;
        this.currSymListFactory = symListFactory;
    }

    public ChunkedSymbolListFactory(SymbolListFactory userSymListFactory, int threshold) {
        this.opMode = 1;
        if (threshold > 0) {
            this.threshold = threshold;
        }
        this.userSymListFactory = userSymListFactory;
        this.currSymListFactory = new SimpleSymbolListFactory();
    }

    public void addSymbols(Alphabet alfa, Symbol[] syms, int pos, int len) throws IllegalArgumentException, IllegalAlphabetException {
        this.canDoMake = false;
        if (this.alfa == null) {
            this.alfa = alfa;
        } else if (this.alfa != alfa) {
            throw new IllegalAlphabetException("Alphabet changed!");
        }
        this.symCount += len;
        if (this.opMode == 1 && this.currSymListFactory != this.userSymListFactory && this.symCount > this.threshold) {
            this.useSuppliedSymListFactory();
        }
        if (this.headChunk == null) {
            this.headChunk = new Symbol[16384];
            this.headChunkPos = 0;
        }
        int ipos = 0;
        while (ipos < len) {
            if (this.headChunkPos == 16384) {
                int i = 0;
                while (i < 16384) {
                    if (this.headChunk[i] == null) {
                        throw new IllegalArgumentException("symbols supplied are not tiling contiguously.");
                    }
                    ++i;
                }
                this.chunkL.add(this.currSymListFactory.makeSymbolList(this.headChunk, 16384, alfa));
                this.headChunkPos = 0;
                this.headChunk = new Symbol[16384];
            }
            int read = Math.min(len - ipos, 16384 - this.headChunkPos);
            System.arraycopy(syms, pos + ipos, this.headChunk, this.headChunkPos, read);
            ipos += read;
            this.headChunkPos += read;
        }
    }

    private void clearState() {
        this.canDoMake = true;
        this.headChunk = null;
        this.headChunkPos = 0;
        this.symCount = 0;
        this.chunkL = new ArrayList();
        this.alfa = null;
        if (this.opMode == 1) {
            this.currSymListFactory = new SimpleSymbolListFactory();
        }
    }

    public void useSuppliedSymListFactory() {
        this.currSymListFactory = this.userSymListFactory;
        int size = this.chunkL.size();
        ArrayList<SymbolList> temp = new ArrayList<SymbolList>(size);
        int i = 0;
        while (i < size) {
            Symbol[] symArray;
            SymbolList symList = (SymbolList)this.chunkL.get(i);
            int symListLen = symList.length();
            if (symList instanceof SimpleSymbolList) {
                symArray = ((SimpleSymbolList)symList).getSymbolArray();
            } else {
                symArray = new Symbol[symListLen];
                int j = 1;
                while (j <= symList.length()) {
                    symArray[j - 1] = symList.symbolAt(j);
                    ++j;
                }
            }
            try {
                temp.add(this.currSymListFactory.makeSymbolList(symArray, symListLen, this.alfa));
            }
            catch (IllegalAlphabetException iae) {
                // empty catch block
            }
            ++i;
        }
        this.chunkL = temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SymbolList makeSymbolList() throws IllegalAlphabetException {
        block7: {
            Object oldChunk;
            block8: {
                if (this.chunkL.size() != 0) break block7;
                if (this.headChunkPos != 0) break block8;
                SymbolList.EmptySymbolList emptySymbolList = new SymbolList.EmptySymbolList();
                Object var6_4 = null;
                this.clearState();
                return emptySymbolList;
            }
            if (this.headChunkPos < 16384) {
                oldChunk = this.headChunk;
                this.headChunk = new Symbol[this.headChunkPos];
                System.arraycopy(oldChunk, 0, this.headChunk, 0, this.headChunkPos);
            }
            oldChunk = new SubArraySymbolList(this.headChunk, this.headChunkPos, 0, this.alfa);
            Object var6_5 = null;
            this.clearState();
            return oldChunk;
        }
        try {
            if (this.headChunkPos != 0) {
                this.chunkL.add(this.currSymListFactory.makeSymbolList(this.headChunk, this.headChunkPos, this.alfa));
            }
            SymbolList[] symListArray = new SymbolList[this.chunkL.size()];
            int cnum = 0;
            while (cnum < this.chunkL.size()) {
                symListArray[cnum] = (SymbolList)this.chunkL.get(cnum);
                ++cnum;
            }
            int length = (this.chunkL.size() - 1) * 16384 + this.headChunkPos;
            ChunkedSymbolList chunkedSymbolList = new ChunkedSymbolList(symListArray, 16384, length, this.alfa);
            Object var6_6 = null;
            this.clearState();
            return chunkedSymbolList;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.clearState();
            throw throwable;
        }
    }

    public SymbolList make(SymbolReader sr) throws IOException, IllegalSymbolException, IllegalAlphabetException, BioException {
        if (!this.canDoMake) {
            throw new BioException("you can't use make() and addSymbol() simultaneously.");
        }
        this.chunkL = new ArrayList();
        this.headChunk = new Symbol[16384];
        this.headChunkPos = 0;
        this.alfa = sr.getAlphabet();
        while (sr.hasMoreSymbols()) {
            if (this.headChunkPos == 16384) {
                this.chunkL.add(this.currSymListFactory.makeSymbolList(this.headChunk, 16384, sr.getAlphabet()));
                this.headChunkPos = 0;
            }
            int read = sr.readSymbols(this.headChunk, this.headChunkPos, 16384 - this.headChunkPos);
            this.headChunkPos += read;
        }
        this.clearState();
        return this.makeSymbolList();
    }

    private static class ChunkedSymbolList
    extends AbstractSymbolList
    implements Serializable {
        private SymbolList[] chunks;
        private final int chunkSize;
        private Alphabet alpha;
        private int length;

        protected void finalize() throws Throwable {
            super.finalize();
            this.alpha.removeChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
        }

        public ChunkedSymbolList(SymbolList[] chunks, int chunkSize, int length, Alphabet alpha) {
            this.chunks = chunks;
            this.chunkSize = chunkSize;
            this.length = length;
            this.alpha = alpha;
            alpha.addChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
        }

        public Alphabet getAlphabet() {
            return this.alpha;
        }

        public int length() {
            return this.length;
        }

        public Symbol symbolAt(int pos) {
            int offset;
            if (--pos < currentMin || pos > currentMax) {
                int chnk = pos / this.chunkSize;
                offset = pos % this.chunkSize;
                currentMin = pos - offset;
                currentMax = currentMin + this.chunkSize - 1;
                currentChunk = this.chunks[chnk];
            } else {
                offset = pos - currentMin;
            }
            return currentChunk.symbolAt(offset + 1);
        }

        public SymbolList subList(int start, int end) {
            if (start < 1 || end > this.length()) {
                throw new IndexOutOfBoundsException("Sublist index out of bounds " + this.length() + ":" + start + "," + end);
            }
            if (end < start) {
                throw new IllegalArgumentException("end must not be lower than start: start=" + start + ", end=" + end);
            }
            int ato = end - 1;
            int afrom = start - 1;
            int cfrom = afrom / this.chunkSize;
            if (ato / this.chunkSize == cfrom) {
                return this.chunks[cfrom].subList(afrom % this.chunkSize + 1, ato % this.chunkSize + 1);
            }
            return super.subList(start, end);
        }
    }
}

