/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.NucleotideTools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.HashSequenceDB;
import org.biojava.bio.seq.db.IDMaker;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.io.EmblLikeFormat;
import org.biojava.bio.seq.io.EmblProcessor;
import org.biojava.bio.seq.io.FastaAlignmentFormat;
import org.biojava.bio.seq.io.FastaDescriptionLineParser;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.GenbankFormat;
import org.biojava.bio.seq.io.GenbankProcessor;
import org.biojava.bio.seq.io.MSFAlignmentFormat;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SmartSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.StreamWriter;
import org.biojava.bio.seq.io.SwissprotProcessor;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.NestedError;

public final class SeqIOTools {
    private static SequenceBuilderFactory _emblBuilderFactory;
    private static SequenceBuilderFactory _genbankBuilderFactory;
    private static SequenceBuilderFactory _genpeptBuilderFactory;
    private static SequenceBuilderFactory _swissprotBuilderFactory;
    private static SequenceBuilderFactory _fastaBuilderFactory;

    private SeqIOTools() {
    }

    public static SequenceBuilderFactory getEmblBuilderFactory() {
        if (_emblBuilderFactory == null) {
            _emblBuilderFactory = new EmblProcessor.Factory(SmartSequenceBuilder.FACTORY);
        }
        return _emblBuilderFactory;
    }

    public static SequenceIterator readEmbl(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new EmblLikeFormat(), SeqIOTools.getDNAParser(), SeqIOTools.getEmblBuilderFactory());
    }

    public static SequenceIterator readEmblRNA(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new EmblLikeFormat(), SeqIOTools.getRNAParser(), SeqIOTools.getEmblBuilderFactory());
    }

    public static SequenceIterator readEmblNucleotide(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new EmblLikeFormat(), SeqIOTools.getNucleotideParser(), SeqIOTools.getEmblBuilderFactory());
    }

    public static SequenceBuilderFactory getGenbankBuilderFactory() {
        if (_genbankBuilderFactory == null) {
            _genbankBuilderFactory = new GenbankProcessor.Factory(SmartSequenceBuilder.FACTORY);
        }
        return _genbankBuilderFactory;
    }

    public static SequenceIterator readGenbank(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new GenbankFormat(), SeqIOTools.getDNAParser(), SeqIOTools.getGenbankBuilderFactory());
    }

    public static SequenceBuilderFactory getGenpeptBuilderFactory() {
        if (_genpeptBuilderFactory == null) {
            _genpeptBuilderFactory = new GenbankProcessor.Factory(SmartSequenceBuilder.FACTORY);
        }
        return _genpeptBuilderFactory;
    }

    public static SequenceIterator readGenpept(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new GenbankFormat(), SeqIOTools.getProteinParser(), SeqIOTools.getGenpeptBuilderFactory());
    }

    public static SequenceBuilderFactory getSwissprotBuilderFactory() {
        if (_swissprotBuilderFactory == null) {
            _swissprotBuilderFactory = new SwissprotProcessor.Factory(SmartSequenceBuilder.FACTORY);
        }
        return _swissprotBuilderFactory;
    }

    public static SequenceIterator readSwissprot(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new EmblLikeFormat(), SeqIOTools.getProteinParser(), SeqIOTools.getSwissprotBuilderFactory());
    }

    public static SequenceBuilderFactory getFastaBuilderFactory() {
        if (_fastaBuilderFactory == null) {
            _fastaBuilderFactory = new FastaDescriptionLineParser.Factory(SmartSequenceBuilder.FACTORY);
        }
        return _fastaBuilderFactory;
    }

    public static SequenceIterator readFastaDNA(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new FastaFormat(), SeqIOTools.getDNAParser(), SeqIOTools.getFastaBuilderFactory());
    }

    public static SequenceIterator readFastaRNA(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new FastaFormat(), SeqIOTools.getRNAParser(), SeqIOTools.getFastaBuilderFactory());
    }

    public static SequenceIterator readFastaProtein(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new FastaFormat(), SeqIOTools.getProteinParser(), SeqIOTools.getFastaBuilderFactory());
    }

    public static SequenceDB readFasta(InputStream seqFile, Alphabet alpha) throws BioException {
        HashSequenceDB db = new HashSequenceDB(IDMaker.byName);
        FastaDescriptionLineParser.Factory sbFact = new FastaDescriptionLineParser.Factory(SmartSequenceBuilder.FACTORY);
        FastaFormat fFormat = new FastaFormat();
        StreamReader seqI = new StreamReader(seqFile, (SequenceFormat)fFormat, alpha.getTokenization("token"), (SequenceBuilderFactory)sbFact);
        while (seqI.hasNext()) {
            Sequence seq = seqI.nextSequence();
            try {
                db.addSequence(seq);
            }
            catch (ChangeVetoException cve) {
                throw new NestedError(cve, "Could not successfully add sequence " + seq.getName() + " to sequence database");
            }
        }
        return db;
    }

    public static void writeFasta(OutputStream os, SequenceDB db) throws IOException {
        StreamWriter sw = new StreamWriter(os, new FastaFormat());
        sw.writeStream(db.sequenceIterator());
    }

    public static void writeFasta(OutputStream os, SequenceIterator in) throws IOException {
        StreamWriter sw = new StreamWriter(os, new FastaFormat());
        sw.writeStream(in);
    }

    public static void writeFasta(OutputStream os, Sequence seq) throws IOException {
        SeqIOTools.writeFasta(os, new SingleSeqIterator(seq));
    }

    public static void writeEmbl(OutputStream os, SequenceIterator in) throws IOException {
        StreamWriter sw = new StreamWriter(os, new EmblLikeFormat());
        sw.writeStream(in);
    }

    public static void writeEmbl(OutputStream os, Sequence seq) throws IOException {
        SeqIOTools.writeEmbl(os, new SingleSeqIterator(seq));
    }

    public static void writeSwissprot(OutputStream os, SequenceIterator in) throws IOException, BioException {
        EmblLikeFormat former = new EmblLikeFormat();
        PrintStream ps = new PrintStream(os);
        while (in.hasNext()) {
            former.writeSequence(in.nextSequence(), ps);
        }
    }

    public static void writeSwissprot(OutputStream os, Sequence seq) throws IOException, BioException {
        SeqIOTools.writeSwissprot(os, new SingleSeqIterator(seq));
    }

    public static void writeGenpept(OutputStream os, SequenceIterator in) throws IOException, BioException {
        GenbankFormat former = new GenbankFormat();
        PrintStream ps = new PrintStream(os);
        while (in.hasNext()) {
            former.writeSequence(in.nextSequence(), ps);
        }
    }

    public static void writeGenpept(OutputStream os, Sequence seq) throws IOException, BioException {
        SeqIOTools.writeGenpept(os, new SingleSeqIterator(seq));
    }

    public static void writeGenbank(OutputStream os, SequenceIterator in) throws IOException {
        StreamWriter sw = new StreamWriter(os, new GenbankFormat());
        sw.writeStream(in);
    }

    public static void writeGenbank(OutputStream os, Sequence seq) throws IOException {
        SeqIOTools.writeGenbank(os, new SingleSeqIterator(seq));
    }

    public static int identifyFormat(String formatName, String alphabetName) {
        int alpha;
        int format;
        if (formatName.equalsIgnoreCase("raw")) {
            format = 1;
        } else if (formatName.equalsIgnoreCase("fasta")) {
            format = 2;
        } else if (formatName.equalsIgnoreCase("nbrf")) {
            format = 3;
        } else if (formatName.equalsIgnoreCase("ig")) {
            format = 4;
        } else if (formatName.equalsIgnoreCase("embl")) {
            format = 10;
        } else {
            if (formatName.equalsIgnoreCase("swissprot") || formatName.equalsIgnoreCase("swiss")) {
                if (alphabetName.equalsIgnoreCase("aa") || alphabetName.equalsIgnoreCase("protein")) {
                    return 524299;
                }
                throw new IllegalArgumentException("Illegal format and alphabet combination " + formatName + " + " + alphabetName);
            }
            if (formatName.equalsIgnoreCase("genbank")) {
                format = 12;
            } else {
                if (formatName.equalsIgnoreCase("genpept")) {
                    if (alphabetName.equalsIgnoreCase("aa") || alphabetName.equalsIgnoreCase("protein")) {
                        return 524301;
                    }
                    throw new IllegalArgumentException("Illegal format and alphabet combination " + formatName + " + " + alphabetName);
                }
                if (formatName.equalsIgnoreCase("refseq")) {
                    format = 14;
                } else if (formatName.equalsIgnoreCase("gcg")) {
                    format = 15;
                } else if (formatName.equalsIgnoreCase("gff")) {
                    format = 20;
                } else {
                    if (formatName.equalsIgnoreCase("pdb")) {
                        if (alphabetName.equalsIgnoreCase("aa") || alphabetName.equalsIgnoreCase("protein")) {
                            return 524309;
                        }
                        throw new IllegalArgumentException("Illegal format and alphabet combination " + formatName + " + " + alphabetName);
                    }
                    if (formatName.equalsIgnoreCase("phred")) {
                        if (alphabetName.equalsIgnoreCase("dna")) {
                            return 1179678;
                        }
                        throw new IllegalArgumentException("Illegal format and alphabet combination " + formatName + " + " + alphabetName);
                    }
                    return 0;
                }
            }
        }
        if (alphabetName.equalsIgnoreCase("dna")) {
            alpha = 131072;
        } else if (alphabetName.equalsIgnoreCase("rna")) {
            alpha = 262144;
        } else if (alphabetName.equalsIgnoreCase("aa") || alphabetName.equalsIgnoreCase("protein")) {
            alpha = 524288;
        } else {
            return 0;
        }
        return format | alpha;
    }

    public static SequenceFormat getSequenceFormat(int identifier) throws BioException {
        int alphaType = identifier & 0xFFFF0000;
        if (alphaType == 0) {
            throw new IllegalArgumentException("No alphabet was set in the identifier");
        }
        int formatType = identifier & 0xFFFF;
        if (formatType == 0) {
            throw new IllegalArgumentException("No format was set in the identifier");
        }
        switch (identifier) {
            case 131074: 
            case 262146: 
            case 524290: {
                return new FastaFormat();
            }
            case 131082: 
            case 262154: {
                return new EmblLikeFormat();
            }
            case 131084: 
            case 262156: {
                return new GenbankFormat();
            }
            case 524299: {
                return new EmblLikeFormat();
            }
        }
        throw new BioException("No SequenceFormat available for format/alphabet identifier '" + identifier + "'");
    }

    public static SequenceBuilderFactory getBuilderFactory(int identifier) throws BioException {
        int alphaType = identifier & 0xFFFF0000;
        if (alphaType == 0) {
            throw new IllegalArgumentException("No alphabet was set in the identifier");
        }
        int formatType = identifier & 0xFFFF;
        if (formatType == 0) {
            throw new IllegalArgumentException("No format was set in the identifier");
        }
        switch (identifier) {
            case 131074: 
            case 262146: 
            case 524290: {
                return SeqIOTools.getFastaBuilderFactory();
            }
            case 131082: {
                return SeqIOTools.getEmblBuilderFactory();
            }
            case 131084: {
                return SeqIOTools.getGenbankBuilderFactory();
            }
            case 524299: {
                return SeqIOTools.getSwissprotBuilderFactory();
            }
            case 524301: {
                return SeqIOTools.getGenpeptBuilderFactory();
            }
        }
        throw new BioException("No SequenceBuilderFactory available for format/alphabet identifier '" + identifier + "'");
    }

    public static FiniteAlphabet getAlphabet(int identifier) throws BioException {
        int alphaType = identifier & 0xFFFF0000;
        if (alphaType == 0) {
            throw new IllegalArgumentException("No alphabet was set in the identifier");
        }
        switch (alphaType) {
            case 131072: {
                return DNATools.getDNA();
            }
            case 262144: {
                return RNATools.getRNA();
            }
            case 524288: {
                return ProteinTools.getAlphabet();
            }
        }
        throw new BioException("No FiniteAlphabet available for alphabet identifier '" + identifier + "'");
    }

    public static int guessFileType(File seqFile) throws IOException, FileNotFoundException {
        String fileName = seqFile.getName();
        try {
            if (new RE(".*\\u002eem.*").match(fileName)) {
                return 131082;
            }
            if (new RE(".*\\u002edat.*").match(fileName)) {
                return 131082;
            }
            if (new RE(".*\\u002egb.*").match(fileName)) {
                return 131084;
            }
            if (new RE(".*\\u002esp.*").match(fileName)) {
                return 524299;
            }
            if (new RE(".*\\u002egp.*").match(fileName)) {
                return 524301;
            }
            if (new RE(".*\\u002efa.*").match(fileName)) {
                return SeqIOTools.guessFastaType(seqFile);
            }
            if (new RE(".*\\u002emsf.*").match(fileName)) {
                return SeqIOTools.guessMsfType(seqFile);
            }
        }
        catch (RESyntaxException e) {
            throw new BioError(e, "Internal error in SeqIOTools");
        }
        BufferedReader br = new BufferedReader(new FileReader(seqFile));
        String line1 = br.readLine();
        String line2 = br.readLine();
        br.close();
        if (line1.startsWith(">")) {
            return SeqIOTools.guessFastaType(seqFile);
        }
        if (line1.startsWith("PileUp")) {
            return SeqIOTools.guessMsfType(seqFile);
        }
        if (line1.startsWith("!!AA_MULTIPLE_ALIGNMENT")) {
            return 524392;
        }
        if (line1.startsWith("!!NA_MULTIPLE_ALIGNMENT")) {
            return 131176;
        }
        if (line1.startsWith("ID")) {
            int i = 0;
            while (i < line1.length()) {
                if (Character.toUpperCase(line1.charAt(i)) == 'P' && Character.toUpperCase(line1.charAt(i + 1)) == 'R' && Character.toUpperCase(line1.charAt(i + 2)) == 'T') {
                    return 524299;
                }
                ++i;
            }
            return 131082;
        }
        if (line1.toUpperCase().startsWith("LOCUS")) {
            int i = 0;
            while (i < line1.length()) {
                if (Character.toUpperCase(line1.charAt(i)) == 'A' && Character.toUpperCase(line1.charAt(i + 1)) == 'A') {
                    return 524301;
                }
                ++i;
            }
            return 131084;
        }
        if (line1.length() >= 45 && line1.substring(19, 45).equalsIgnoreCase("GENETIC SEQUENCE DATA BANK")) {
            return SeqIOTools.guessGenType(fileName);
        }
        return 0;
    }

    public static SequenceBuilderFactory formatToFactory(SequenceFormat format, Alphabet alpha) throws BioException {
        if (format instanceof FastaFormat && (alpha == DNATools.getDNA() || alpha == ProteinTools.getAlphabet())) {
            return SeqIOTools.getFastaBuilderFactory();
        }
        if (format instanceof GenbankFormat && alpha == DNATools.getDNA()) {
            return SeqIOTools.getGenbankBuilderFactory();
        }
        if (format instanceof GenbankFormat && alpha == ProteinTools.getAlphabet()) {
            return SeqIOTools.getGenpeptBuilderFactory();
        }
        if (format instanceof EmblLikeFormat && alpha == DNATools.getDNA()) {
            return SeqIOTools.getEmblBuilderFactory();
        }
        if (format instanceof EmblLikeFormat && alpha == ProteinTools.getAlphabet()) {
            return SeqIOTools.getSwissprotBuilderFactory();
        }
        throw new BioException("Unknown combination of Alphabet and Format");
    }

    public static Object fileToBiojava(String formatName, String alphabetName, BufferedReader br) throws BioException {
        int fileType = SeqIOTools.identifyFormat(formatName, alphabetName);
        return SeqIOTools.fileToBiojava(fileType, br);
    }

    public static Object fileToBiojava(int fileType, BufferedReader br) throws BioException {
        int alphaType = fileType & 0xFFFF0000;
        if (alphaType == 0) {
            throw new IllegalArgumentException("No alphabet was set in the identifier");
        }
        int formatType = fileType & 0xFFFF;
        if (formatType == 0) {
            throw new IllegalArgumentException("No format was set in the identifier");
        }
        switch (fileType) {
            case 131174: 
            case 131176: 
            case 524390: 
            case 524392: {
                return SeqIOTools.fileToAlign(fileType, br);
            }
            case 131074: 
            case 131082: 
            case 131084: 
            case 524290: 
            case 524299: 
            case 524301: {
                return SeqIOTools.fileToSeq(fileType, br);
            }
        }
        throw new BioException("Unknown file type '" + fileType + "'");
    }

    public static void biojavaToFile(String formatName, String alphabetName, OutputStream os, Object biojava) throws BioException, IOException, IllegalSymbolException {
        int fileType = SeqIOTools.identifyFormat(formatName, alphabetName);
        SeqIOTools.biojavaToFile(fileType, os, biojava);
    }

    public static void biojavaToFile(int fileType, OutputStream os, Object biojava) throws BioException, IOException, IllegalSymbolException {
        switch (fileType) {
            case 131174: 
            case 131176: 
            case 524390: 
            case 524392: {
                SeqIOTools.alignToFile(fileType, os, (Alignment)biojava);
                break;
            }
            case 131074: 
            case 131082: 
            case 131084: 
            case 524290: 
            case 524299: 
            case 524301: {
                if (biojava instanceof SequenceDB) {
                    SeqIOTools.seqToFile(fileType, os, ((SequenceDB)biojava).sequenceIterator());
                    break;
                }
                if (biojava instanceof Sequence) {
                    SeqIOTools.seqToFile(fileType, os, new SingleSeqIterator((Sequence)biojava));
                    break;
                }
                SeqIOTools.seqToFile(fileType, os, (SequenceIterator)biojava);
                break;
            }
            default: {
                throw new BioException("Unknown file type '" + fileType + "'");
            }
        }
    }

    private static int guessFastaType(File seqFile) throws IOException, FileNotFoundException {
        BufferedReader br = new BufferedReader(new FileReader(seqFile));
        String line = br.readLine();
        line = br.readLine();
        br.close();
        int i = 0;
        while (i < line.length()) {
            if (Character.toUpperCase(line.charAt(i)) == 'F' || Character.toUpperCase(line.charAt(i)) == 'L' || Character.toUpperCase(line.charAt(i)) == 'I' || Character.toUpperCase(line.charAt(i)) == 'P' || Character.toUpperCase(line.charAt(i)) == 'Q' || Character.toUpperCase(line.charAt(i)) == 'E') {
                return 524290;
            }
            ++i;
        }
        return 131074;
    }

    private static SymbolTokenization getDNAParser() {
        try {
            return DNATools.getDNA().getTokenization("token");
        }
        catch (BioException ex) {
            throw new BioError(ex, "Assertion failing: Couldn't get DNA token parser");
        }
    }

    private static SymbolTokenization getRNAParser() {
        try {
            return RNATools.getRNA().getTokenization("token");
        }
        catch (BioException ex) {
            throw new BioError(ex, "Assertion failing: Couldn't get RNA token parser");
        }
    }

    private static SymbolTokenization getNucleotideParser() {
        try {
            return NucleotideTools.getNucleotide().getTokenization("token");
        }
        catch (BioException ex) {
            throw new BioError(ex, "Assertion failing: Couldn't get nucleotide token parser");
        }
    }

    private static SymbolTokenization getProteinParser() {
        try {
            return ProteinTools.getTAlphabet().getTokenization("token");
        }
        catch (BioException ex) {
            throw new BioError(ex, "Assertion failing: Couldn't get PROTEIN token parser");
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int guessMsfType(File seqFile) throws IOException, FileNotFoundException {
        br = new BufferedReader(new FileReader(seqFile));
        line = br.readLine();
        if (line.startsWith("!!NA_MULTIPLE_ALIGNMENT")) {
            return 131176;
        }
        if (!line.startsWith("!!AA_MULTIPLE_ALIGNMENT")) ** GOTO lbl8
        return 524392;
lbl-1000:
        // 1 sources

        {
            line = br.readLine();
lbl8:
            // 2 sources

            ** while (line.indexOf((String)"Type: ") == -1)
        }
lbl9:
        // 1 sources

        br.close();
        typeIndex = line.indexOf("Type: ") + 6;
        if (line.substring(typeIndex).startsWith("N")) {
            return 131176;
        }
        if (line.substring(typeIndex).startsWith("P")) {
            return 524392;
        }
        return 100;
    }

    private static int guessGenType(String fileName) throws IOException, FileNotFoundException {
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        String line = br.readLine();
        while (line.indexOf("LOCUS") == -1) {
            line = br.readLine();
        }
        br.close();
        int i = 0;
        while (i < line.length()) {
            if (Character.toUpperCase(line.charAt(i)) == 'A' && Character.toUpperCase(line.charAt(i + 1)) == 'A') {
                return 524301;
            }
            ++i;
        }
        return 131084;
    }

    private static Alignment fileToAlign(int fileType, BufferedReader br) throws BioException {
        switch (fileType) {
            case 131176: 
            case 524392: {
                return new MSFAlignmentFormat().read(br);
            }
            case 131174: 
            case 524390: {
                return new FastaAlignmentFormat().read(br);
            }
        }
        throw new BioException("Unknown file type '" + fileType + "'");
    }

    private static SequenceIterator fileToSeq(int fileType, BufferedReader br) throws BioException {
        switch (fileType) {
            case 131074: {
                return SeqIOTools.readFastaDNA(br);
            }
            case 524290: {
                return SeqIOTools.readFastaProtein(br);
            }
            case 131082: {
                return SeqIOTools.readEmbl(br);
            }
            case 131084: {
                return SeqIOTools.readGenbank(br);
            }
            case 524299: {
                return SeqIOTools.readSwissprot(br);
            }
            case 524301: {
                return SeqIOTools.readGenpept(br);
            }
        }
        throw new BioException("Unknown file type '" + fileType + "'");
    }

    private static void alignToFile(int fileType, OutputStream os, Alignment align) throws BioException, IllegalSymbolException {
        switch (fileType) {
            case 131176: {
                new MSFAlignmentFormat().writeDna(os, align);
                break;
            }
            case 524392: {
                new MSFAlignmentFormat().writeProtein(os, align);
                break;
            }
            case 131174: {
                new FastaAlignmentFormat().writeDna(os, align);
                break;
            }
            case 524390: {
                new FastaAlignmentFormat().writeProtein(os, align);
                break;
            }
            default: {
                throw new BioException("Unknown file type '" + fileType + "'");
            }
        }
    }

    private static void seqToFile(int fileType, OutputStream os, SequenceIterator seq) throws IOException, BioException {
        switch (fileType) {
            case 131074: 
            case 524290: {
                SeqIOTools.writeFasta(os, seq);
                break;
            }
            case 131082: {
                SeqIOTools.writeEmbl(os, seq);
                break;
            }
            case 524299: {
                SeqIOTools.writeSwissprot(os, seq);
                break;
            }
            case 131084: {
                SeqIOTools.writeGenbank(os, seq);
                break;
            }
            case 524301: {
                SeqIOTools.writeGenpept(os, seq);
                break;
            }
            default: {
                throw new BioException("Unknown file type '" + fileType + "'");
            }
        }
    }

    private static final class SingleSeqIterator
    implements SequenceIterator {
        private Sequence seq;

        SingleSeqIterator(Sequence seq) {
            this.seq = seq;
        }

        public boolean hasNext() {
            return this.seq != null;
        }

        public Sequence nextSequence() {
            Sequence seq = this.seq;
            this.seq = null;
            return seq;
        }
    }
}

