/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.utils.ParseErrorEvent;
import org.biojava.utils.ParseErrorListener;
import org.biojava.utils.ParseErrorSource;

public class StreamReader
implements SequenceIterator,
ParseErrorListener {
    private SymbolTokenization symParser;
    private SequenceFormat format;
    private SequenceBuilderFactory sf;
    private BufferedReader reader;
    private boolean moreSequenceAvailable = true;

    public Sequence nextSequence() throws NoSuchElementException, BioException {
        if (!this.moreSequenceAvailable) {
            throw new NoSuchElementException("Stream is empty");
        }
        try {
            SequenceBuilder builder = this.sf.makeSequenceBuilder();
            this.moreSequenceAvailable = this.format.readSequence(this.reader, this.symParser, builder);
            return builder.makeSequence();
        }
        catch (Exception e) {
            throw new BioException(e, "Could not read sequence");
        }
    }

    public boolean hasNext() {
        return this.moreSequenceAvailable;
    }

    public StreamReader(InputStream is, SequenceFormat format, SymbolTokenization symParser, SequenceBuilderFactory sf) {
        this.reader = new BufferedReader(new InputStreamReader(is));
        this.format = format;
        this.symParser = symParser;
        this.sf = sf;
    }

    public StreamReader(BufferedReader reader, SequenceFormat format, SymbolTokenization symParser, SequenceBuilderFactory sf) {
        this.reader = reader;
        this.format = format;
        this.symParser = symParser;
        this.sf = sf;
        ((ParseErrorSource)((Object)this.format)).addParseErrorListener(this);
    }

    public void BadLineParsed(ParseErrorEvent theEvent) {
        System.err.println(theEvent.getMessage());
    }
}

