/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.filterxml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FramedFeature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.filterxml.QName;
import org.biojava.bio.seq.io.filterxml.XMLAnnotationTypeHandler;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StAXContentHandlerBase;
import org.biojava.utils.stax.StringElementHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLFilterHandler {
    Map handlerFactories = new HashMap();

    public void registerHandlerFactory(String nsURI, String localName, FilterHandlerFactory factory) {
        this.handlerFactories.put(new QName(nsURI, localName), factory);
    }

    public FilterHandler getHandler(String nsURI, String localName) throws SAXException {
        FilterHandlerFactory factory = (FilterHandlerFactory)this.handlerFactories.get(new QName(nsURI, localName));
        if (factory != null) {
            return factory.makeHandler(nsURI, localName, this);
        }
        throw new SAXException("No handler for " + nsURI + ":" + localName);
    }

    public XMLFilterHandler() {
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "byType", new CDATAHandlerFactory(){

            protected FeatureFilter stringToFilter(String s) {
                return new FeatureFilter.ByType(s);
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "bySource", new CDATAHandlerFactory(){

            protected FeatureFilter stringToFilter(String s) {
                return new FeatureFilter.BySource(s);
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "byClass", new CDATAHandlerFactory(){

            protected FeatureFilter stringToFilter(String s) throws SAXException {
                try {
                    return new FeatureFilter.ByClass(this.getClass().getClassLoader().loadClass(s));
                }
                catch (Exception ex) {
                    throw new SAXException("Couldn't load class " + s);
                }
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "byStrand", new CDATAHandlerFactory(){

            protected FeatureFilter stringToFilter(String s) throws SAXException {
                s = s.trim();
                StrandedFeature.Strand strand = StrandedFeature.UNKNOWN;
                if ("POSITIVE".equalsIgnoreCase(s)) {
                    strand = StrandedFeature.POSITIVE;
                } else if ("NEGATIVE".equalsIgnoreCase(s)) {
                    strand = StrandedFeature.NEGATIVE;
                }
                return new FeatureFilter.StrandFilter(strand);
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "byFrame", new CDATAHandlerFactory(){

            protected FeatureFilter stringToFilter(String s) throws SAXException {
                int frameNum = Integer.parseInt(s.trim());
                switch (frameNum) {
                    case 0: {
                        return new FeatureFilter.FrameFilter(FramedFeature.FRAME_0);
                    }
                    case 1: {
                        return new FeatureFilter.FrameFilter(FramedFeature.FRAME_1);
                    }
                    case 2: {
                        return new FeatureFilter.FrameFilter(FramedFeature.FRAME_2);
                    }
                }
                throw new SAXException("Invalid frame: " + frameNum);
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "all", new CDATAHandlerFactory(){

            protected FeatureFilter stringToFilter(String s) {
                return FeatureFilter.all;
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "none", new CDATAHandlerFactory(){

            protected FeatureFilter stringToFilter(String s) {
                return FeatureFilter.none;
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "isTopLevel", new CDATAHandlerFactory(){

            protected FeatureFilter stringToFilter(String s) {
                return FeatureFilter.top_level;
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "isLeaf", new CDATAHandlerFactory(){

            protected FeatureFilter stringToFilter(String s) {
                return FeatureFilter.leaf;
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "bySequenceName", new CDATAHandlerFactory(){

            protected FeatureFilter stringToFilter(String s) {
                return new FeatureFilter.BySequenceName(s);
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "byComponentName", new CDATAHandlerFactory(){

            protected FeatureFilter stringToFilter(String s) {
                return new FeatureFilter.ByComponentName(s);
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "not", new SingleFilterHandlerFactory(){

            protected FeatureFilter filterToFilter(FeatureFilter ff) {
                return new FeatureFilter.Not(ff);
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "byParent", new SingleFilterHandlerFactory(){

            protected FeatureFilter filterToFilter(FeatureFilter ff) {
                return new FeatureFilter.ByParent(ff);
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "byAncestor", new SingleFilterHandlerFactory(){

            protected FeatureFilter filterToFilter(FeatureFilter ff) {
                return new FeatureFilter.ByAncestor(ff);
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "byChild", new SingleFilterHandlerFactory(){

            protected FeatureFilter filterToFilter(FeatureFilter ff) {
                return new FeatureFilter.ByChild(ff);
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "byDescendant", new SingleFilterHandlerFactory(){

            protected FeatureFilter filterToFilter(FeatureFilter ff) {
                return new FeatureFilter.ByDescendant(ff);
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "onlyChildren", new SingleFilterHandlerFactory(){

            protected FeatureFilter filterToFilter(FeatureFilter ff) {
                return new FeatureFilter.OnlyChildren(ff);
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "onlyDescendants", new SingleFilterHandlerFactory(){

            protected FeatureFilter filterToFilter(FeatureFilter ff) {
                return new FeatureFilter.OnlyDescendants(ff);
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "and", new FiltersHandlerFactory(){

            protected FeatureFilter filtersToFilter(List l) {
                Iterator i = l.iterator();
                FeatureFilter ff = (FeatureFilter)i.next();
                while (i.hasNext()) {
                    ff = new FeatureFilter.And(ff, (FeatureFilter)i.next());
                }
                return ff;
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "or", new FiltersHandlerFactory(){

            protected FeatureFilter filtersToFilter(List l) {
                Iterator i = l.iterator();
                FeatureFilter ff = (FeatureFilter)i.next();
                while (i.hasNext()) {
                    ff = new FeatureFilter.Or(ff, (FeatureFilter)i.next());
                }
                return ff;
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "overlapsLocation", new LocationHandlerFactory(){

            protected FeatureFilter locationToFilter(Location loc) {
                return new FeatureFilter.OverlapsLocation(loc);
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "containedByLocation", new LocationHandlerFactory(){

            protected FeatureFilter locationToFilter(Location loc) {
                return new FeatureFilter.ContainedByLocation(loc);
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "shadowOverlapsLocation", new LocationHandlerFactory(){

            protected FeatureFilter locationToFilter(Location loc) {
                return new FeatureFilter.ShadowOverlapsLocation(loc);
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "shadowContainedByLocation", new LocationHandlerFactory(){

            protected FeatureFilter locationToFilter(Location loc) {
                return new FeatureFilter.ShadowContainedByLocation(loc);
            }
        });
        this.registerHandlerFactory("http://www.biojava.org/FeatureFilter", "byAnnotationType", new AnnotationTypeHandlerFactory());
    }

    public FilterHandler getStAXContentHandler() {
        return new AnyFilterHandler();
    }

    private class AnyFilterHandler
    extends StAXContentHandlerBase
    implements FilterHandler {
        private FeatureFilter filter;

        private AnyFilterHandler() {
        }

        public FeatureFilter getFeatureFilter() {
            return this.filter;
        }

        public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
            FilterHandler h = XMLFilterHandler.this.getHandler(nsURI, localName);
            dm.delegate(h);
        }

        public void endElement(String nsURI, String localName, String qName, StAXContentHandler delegate) throws SAXException {
            this.filter = ((FilterHandler)delegate).getFeatureFilter();
        }
    }

    private static class AnnotationTypeHandlerFactory
    implements FilterHandlerFactory {
        private AnnotationTypeHandlerFactory() {
        }

        public FilterHandler makeHandler(String nsURI, String localName, XMLFilterHandler config) {
            return new AnnotationTypeHandler();
        }

        private class AnnotationTypeHandler
        extends StAXContentHandlerBase
        implements FilterHandler {
            private int depth = 0;
            private FeatureFilter filter;

            private AnnotationTypeHandler() {
            }

            public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
                if (this.depth == 1) {
                    dm.delegate(new XMLAnnotationTypeHandler());
                }
                ++this.depth;
            }

            public void endElement(String nsURI, String localName, String qName, StAXContentHandler delegate) throws SAXException {
                if (delegate instanceof XMLAnnotationTypeHandler) {
                    this.filter = new FeatureFilter.ByAnnotationType(((XMLAnnotationTypeHandler)delegate).getAnnotationType());
                }
                --this.depth;
            }

            public FeatureFilter getFeatureFilter() {
                return this.filter;
            }
        }
    }

    private static abstract class CDATAHandlerFactory
    implements FilterHandlerFactory {
        private CDATAHandlerFactory() {
        }

        protected abstract FeatureFilter stringToFilter(String var1) throws SAXException;

        public FilterHandler makeHandler(String nsURI, String localName, XMLFilterHandler config) {
            return new CDATAHandler();
        }

        private class CDATAHandler
        extends StringElementHandlerBase
        implements FilterHandler {
            private FeatureFilter ourFilter;

            private CDATAHandler() {
            }

            public FeatureFilter getFeatureFilter() {
                return this.ourFilter;
            }

            protected void setStringValue(String s) throws SAXException {
                this.ourFilter = CDATAHandlerFactory.this.stringToFilter(s);
            }
        }
    }

    private static abstract class LocationHandlerFactory
    implements FilterHandlerFactory {
        private LocationHandlerFactory() {
        }

        protected abstract FeatureFilter locationToFilter(Location var1) throws SAXException;

        public FilterHandler makeHandler(String nsURI, String localName, XMLFilterHandler config) {
            return new LocationHandler();
        }

        private class LocationHandler
        extends StAXContentHandlerBase
        implements FilterHandler {
            private List spans = new ArrayList();

            private LocationHandler() {
            }

            public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
                if ("span".equals(localName)) {
                    int start = Integer.parseInt(attrs.getValue("start"));
                    int stop = Integer.parseInt(attrs.getValue("stop"));
                    this.spans.add(new RangeLocation(start, stop));
                }
            }

            public FeatureFilter getFeatureFilter() throws SAXException {
                return LocationHandlerFactory.this.locationToFilter(LocationTools.union(this.spans));
            }
        }
    }

    private static abstract class FiltersHandlerFactory
    implements FilterHandlerFactory {
        private FiltersHandlerFactory() {
        }

        protected abstract FeatureFilter filtersToFilter(List var1) throws SAXException;

        public FilterHandler makeHandler(String nsURI, String localName, XMLFilterHandler config) {
            return new FiltersHandler(config);
        }

        private class FiltersHandler
        extends StAXContentHandlerBase
        implements FilterHandler {
            private XMLFilterHandler config;
            private List filterChildren = new ArrayList();
            private int depth = 0;

            public FiltersHandler(XMLFilterHandler config) {
                this.config = config;
            }

            public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
                if (this.depth == 1) {
                    FilterHandler childHandler = this.config.getHandler(nsURI, localName);
                    dm.delegate(childHandler);
                }
                ++this.depth;
            }

            public void endElement(String nsURI, String localName, String qName, StAXContentHandler delegate) throws SAXException {
                if (delegate instanceof FilterHandler) {
                    this.filterChildren.add(((FilterHandler)delegate).getFeatureFilter());
                }
                --this.depth;
            }

            public FeatureFilter getFeatureFilter() throws SAXException {
                return FiltersHandlerFactory.this.filtersToFilter(this.filterChildren);
            }
        }
    }

    private static abstract class SingleFilterHandlerFactory
    extends FiltersHandlerFactory {
        private SingleFilterHandlerFactory() {
        }

        protected abstract FeatureFilter filterToFilter(FeatureFilter var1) throws SAXException;

        protected final FeatureFilter filtersToFilter(List filters) throws SAXException {
            if (filters.size() != 1) {
                throw new SAXException("Expected 1 child filter but got " + filters.size());
            }
            return this.filterToFilter((FeatureFilter)filters.get(0));
        }
    }

    public static interface FilterHandlerFactory {
        public FilterHandler makeHandler(String var1, String var2, XMLFilterHandler var3) throws SAXException;
    }

    public static interface FilterHandler
    extends StAXContentHandler {
        public FeatureFilter getFeatureFilter() throws SAXException;
    }
}

