/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.projection;

import java.util.ArrayList;
import java.util.Iterator;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;

public class ProjectionUtils {
    public static Location transformLocation(Location oldLoc, int translate, boolean oppositeStrand) {
        if (oppositeStrand) {
            if (oldLoc.isContiguous()) {
                if (oldLoc instanceof PointLocation) {
                    return new PointLocation(translate - oldLoc.getMin());
                }
                return new RangeLocation(translate - oldLoc.getMax(), translate - oldLoc.getMin());
            }
            Location compound = Location.empty;
            ArrayList<RangeLocation> locList = new ArrayList<RangeLocation>();
            Iterator i = oldLoc.blockIterator();
            while (i.hasNext()) {
                Location oldBlock = (Location)i.next();
                locList.add(new RangeLocation(translate - oldBlock.getMax(), translate - oldBlock.getMin()));
            }
            compound = LocationTools.union(locList);
            return compound;
        }
        return oldLoc.translate(translate);
    }

    public static StrandedFeature.Strand flipStrand(StrandedFeature.Strand s) {
        if (s == StrandedFeature.POSITIVE) {
            return StrandedFeature.NEGATIVE;
        }
        if (s == StrandedFeature.NEGATIVE) {
            return StrandedFeature.POSITIVE;
        }
        return StrandedFeature.UNKNOWN;
    }
}

