/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.ragbag;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.ragbag.RagbagSequence;
import org.biojava.bio.seq.ragbag.RagbagSequenceItf;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.cache.Cache;
import org.biojava.utils.cache.CacheReference;

class RagbagCachedSequence
implements RagbagSequenceItf {
    private Cache cache;
    protected String seqFilename = null;
    protected List annotFilenames = null;
    private String name;
    private String urn;
    private CacheReference cachedSequence;
    private boolean gotSequenceFile = false;

    public RagbagCachedSequence(String name, String urn, Cache cache) {
        this.cache = cache;
        this.name = name;
        this.urn = urn;
        System.out.println("RagbagCachedSequence constructor: " + name + " " + urn);
    }

    public void addFeatureFile(File thisFile) throws BioException {
        if (!thisFile.exists() || !thisFile.isFile()) {
            throw new BioException("RagbagCachedSequence: not valid file!");
        }
        if (this.annotFilenames == null) {
            this.annotFilenames = new Vector();
        }
        try {
            this.annotFilenames.add(thisFile.getCanonicalPath());
        }
        catch (IOException ioe) {
            throw new BioException(ioe);
        }
    }

    public void addFeatureFile(String filename) throws BioException {
        File thisFile = new File(filename);
        this.addFeatureFile(thisFile);
    }

    public void addSequenceFile(File thisFile) throws BioException {
        if (!thisFile.exists() || !thisFile.isFile()) {
            throw new BioException("RagbagCachedSequence: not valid file!");
        }
        try {
            this.seqFilename = thisFile.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new BioException(ioe);
        }
        this.gotSequenceFile = true;
    }

    public void addSequenceFile(String filename) throws BioException {
        File thisFile = new File(filename);
        this.addSequenceFile(thisFile);
    }

    public void makeSequence() throws BioException {
        if (!this.gotSequenceFile) {
            throw new BioException("RagbagCachedSequence: no sequence file defined");
        }
    }

    private Sequence instantiateSequence() {
        RagbagSequenceItf seq;
        if (this.cachedSequence != null && (seq = (RagbagSequenceItf)this.cachedSequence.get()) != null) {
            return seq;
        }
        if (!this.gotSequenceFile) {
            throw new BioError("RagbagCachedSequence: no sequence file defined");
        }
        try {
            seq = new RagbagSequence(this.name, this.urn);
            seq.addSequenceFile(new File(this.seqFilename));
            if (this.annotFilenames != null) {
                Iterator ai = this.annotFilenames.iterator();
                while (ai.hasNext()) {
                    File currAnnotFile = new File((String)ai.next());
                    seq.addFeatureFile(currAnnotFile);
                }
            }
            seq.makeSequence();
        }
        catch (BioException be) {
            throw new BioError(be);
        }
        this.cachedSequence = this.cache.makeReference(seq);
        return seq;
    }

    public String getName() {
        return this.name;
    }

    public String getURN() {
        return this.urn;
    }

    public void edit(Edit edit) throws IllegalAlphabetException, ChangeVetoException {
        Sequence tempSeq = this.instantiateSequence();
        tempSeq.edit(edit);
    }

    public Alphabet getAlphabet() {
        Sequence tempSeq = this.instantiateSequence();
        return tempSeq.getAlphabet();
    }

    public Iterator iterator() {
        Sequence tempSeq = this.instantiateSequence();
        return tempSeq.iterator();
    }

    public int length() {
        Sequence tempSeq = this.instantiateSequence();
        return tempSeq.length();
    }

    public String seqString() {
        Sequence tempSeq = this.instantiateSequence();
        return tempSeq.seqString();
    }

    public SymbolList subList(int start, int end) {
        Sequence tempSeq = this.instantiateSequence();
        return tempSeq.subList(start, end);
    }

    public String subStr(int start, int end) {
        Sequence tempSeq = this.instantiateSequence();
        return tempSeq.subStr(start, end);
    }

    public Symbol symbolAt(int index) {
        Sequence tempSeq = this.instantiateSequence();
        return tempSeq.symbolAt(index);
    }

    public List toList() {
        Sequence tempSeq = this.instantiateSequence();
        return tempSeq.toList();
    }

    public void addChangeListener(ChangeListener cl) {
        Sequence tempSeq = this.instantiateSequence();
        tempSeq.addChangeListener(cl);
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        Sequence tempSeq = this.instantiateSequence();
        tempSeq.addChangeListener(cl, ct);
    }

    public void removeChangeListener(ChangeListener cl) {
        Sequence tempSeq = this.instantiateSequence();
        tempSeq.addChangeListener(cl);
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        Sequence tempSeq = this.instantiateSequence();
        tempSeq.addChangeListener(cl, ct);
    }

    public boolean isUnchanging(ChangeType ct) {
        Sequence tempSeq = this.instantiateSequence();
        return tempSeq.isUnchanging(ct);
    }

    public boolean containsFeature(Feature f) {
        Sequence tempSeq = this.instantiateSequence();
        return tempSeq.containsFeature(f);
    }

    public int countFeatures() {
        Sequence tempSeq = this.instantiateSequence();
        return tempSeq.countFeatures();
    }

    public Feature createFeature(Feature.Template ft) throws BioException, ChangeVetoException {
        Sequence tempSeq = this.instantiateSequence();
        return tempSeq.createFeature(ft);
    }

    public Iterator features() {
        Sequence tempSeq = this.instantiateSequence();
        return tempSeq.features();
    }

    public FeatureFilter getSchema() {
        return this.instantiateSequence().getSchema();
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        Sequence tempSeq = this.instantiateSequence();
        return tempSeq.filter(ff, recurse);
    }

    public FeatureHolder filter(FeatureFilter ff) {
        Sequence tempSeq = this.instantiateSequence();
        return tempSeq.filter(ff);
    }

    public void removeFeature(Feature f) throws ChangeVetoException {
        Sequence tempSeq = this.instantiateSequence();
        tempSeq.removeFeature(f);
    }

    public Annotation getAnnotation() {
        Sequence tempSeq = this.instantiateSequence();
        return tempSeq.getAnnotation();
    }
}

